/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.ui.components.JExtendedSpinner;
import org.netbeans.modules.profiler.ui.HyperlinkLabel;
import org.netbeans.modules.profiler.ui.stp.DefaultSettingsPanel;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MemorySettingsBasicPanel
extends DefaultSettingsPanel
implements HelpCtx.Provider {
    private static final String ALLOC_RADIO_TEXT = NbBundle.getMessage(MemorySettingsBasicPanel.class, (String)"MemorySettingsBasicPanel_AllocRadioText");
    private static final String LIVENESS_RADIO_TEXT = NbBundle.getMessage(MemorySettingsBasicPanel.class, (String)"MemorySettingsBasicPanel_LivenessRadioText");
    private static final String TRACK_EVERY_LABEL_TEXT = NbBundle.getMessage(MemorySettingsBasicPanel.class, (String)"MemorySettingsBasicPanel_TrackEveryLabelText");
    private static final String ALLOC_LABEL_TEXT = NbBundle.getMessage(MemorySettingsBasicPanel.class, (String)"MemorySettingsBasicPanel_AllocLabelText");
    private static final String RECORD_TRACES_CHECKBOX_TEXT = NbBundle.getMessage(MemorySettingsBasicPanel.class, (String)"MemorySettingsBasicPanel_RecordTracesCheckboxText");
    private static final String USE_PPS_CHECKBOX_TEXT = NbBundle.getMessage(MemorySettingsBasicPanel.class, (String)"MemorySettingsBasicPanel_UsePpsCheckboxText");
    private static final String SHOW_PPS_STRING = NbBundle.getMessage(MemorySettingsBasicPanel.class, (String)"MemorySettingsBasicPanel_ShowPpsString");
    private static final String STP_USEPPS_TOOLTIP = NbBundle.getMessage(MemorySettingsBasicPanel.class, (String)"StpUsePpsTooltip");
    private static final String STP_SHOWPPS_TOOLTIP = NbBundle.getMessage(MemorySettingsBasicPanel.class, (String)"StpShowPpsTooltip");
    private static final String STP_ALLOC_TOOLTIP = NbBundle.getMessage(MemorySettingsBasicPanel.class, (String)"StpAllocTooltip");
    private static final String STP_LIVENESS_TOOLTIP = NbBundle.getMessage(MemorySettingsBasicPanel.class, (String)"StpLivenessTooltip");
    private static final String STP_TRACKEVERY_TOOLTIP = NbBundle.getMessage(MemorySettingsBasicPanel.class, (String)"StpTrackEveryTooltip");
    private static final String STP_STACKTRACE_TOOLTIP = NbBundle.getMessage(MemorySettingsBasicPanel.class, (String)"StpStackTraceTooltip");
    private static final String HELP_CTX_KEY = "MemorySettings.Basic.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("MemorySettings.Basic.HelpCtx");
    private HyperlinkLabel profilingPointsLink;
    private JCheckBox profilingPointsCheckbox;
    private JCheckBox recordStackTraceCheckbox;
    private JLabel trackEveryLabel1;
    private JLabel trackEveryLabel2;
    private JRadioButton allocationsRadio;
    private JRadioButton livenessRadio;
    private JSpinner trackEverySpinner;
    private Runnable profilingPointsDisplayer;

    public MemorySettingsBasicPanel() {
        this.initComponents();
    }

    public void setContext(Runnable runnable) {
        this.profilingPointsDisplayer = runnable;
        this.updateProject();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public void setProfilingType(int n) {
        this.allocationsRadio.setSelected(n == 2);
        this.livenessRadio.setSelected(n == 4);
    }

    public int getProfilingType() {
        if (this.allocationsRadio.isSelected()) {
            return 2;
        }
        return 4;
    }

    public void setRecordStackTrace(boolean bl) {
        this.recordStackTraceCheckbox.setSelected(bl);
    }

    public boolean getRecordStackTrace() {
        return this.recordStackTraceCheckbox.isSelected();
    }

    public void setTrackEvery(int n) {
        this.trackEverySpinner.setValue(n);
    }

    public int getTrackEvery() {
        return (Integer)this.trackEverySpinner.getValue();
    }

    public void setUseProfilingPoints(boolean bl) {
        this.profilingPointsCheckbox.setSelected(bl);
        this.updateEnabling();
    }

    public boolean getUseProfilingPoints() {
        return this.profilingPointsCheckbox.isSelected();
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame jFrame = new JFrame("Tester Frame");
        MemorySettingsBasicPanel memorySettingsBasicPanel = new MemorySettingsBasicPanel();
        memorySettingsBasicPanel.setPreferredSize(new Dimension(375, 255));
        jFrame.getContentPane().add(memorySettingsBasicPanel);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        this.allocationsRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.allocationsRadio, (String)ALLOC_RADIO_TEXT);
        this.allocationsRadio.setToolTipText(STP_ALLOC_TOOLTIP);
        this.allocationsRadio.setOpaque(false);
        this.allocationsRadio.setSelected(true);
        buttonGroup.add(this.allocationsRadio);
        this.allocationsRadio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
            }
        });
        this.allocationsRadio.addActionListener(this.getSettingsChangeListener());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 30, 0, 0);
        this.add((Component)this.allocationsRadio, gridBagConstraints);
        this.livenessRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.livenessRadio, (String)LIVENESS_RADIO_TEXT);
        this.livenessRadio.setToolTipText(STP_LIVENESS_TOOLTIP);
        this.livenessRadio.setOpaque(false);
        this.livenessRadio.setSelected(true);
        buttonGroup.add(this.livenessRadio);
        this.livenessRadio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
            }
        });
        this.livenessRadio.addActionListener(this.getSettingsChangeListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 30, 0, 0);
        this.add((Component)this.livenessRadio, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.trackEveryLabel1 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.trackEveryLabel1, (String)TRACK_EVERY_LABEL_TEXT);
        this.trackEveryLabel1.setToolTipText(STP_TRACKEVERY_TOOLTIP);
        this.trackEveryLabel1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)this.trackEveryLabel1, gridBagConstraints);
        this.trackEverySpinner = new JExtendedSpinner(new SpinnerNumberModel(10, 1, Integer.MAX_VALUE, 1)){

            public Dimension getPreferredSize() {
                return new Dimension(55, Utils.getDefaultSpinnerHeight());
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.trackEveryLabel1.setLabelFor(this.trackEverySpinner);
        this.trackEverySpinner.setToolTipText(STP_TRACKEVERY_TOOLTIP);
        this.trackEverySpinner.addChangeListener(this.getSettingsChangeListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.trackEverySpinner, gridBagConstraints);
        this.trackEveryLabel2 = new JLabel(ALLOC_LABEL_TEXT);
        this.trackEveryLabel2.setToolTipText(STP_TRACKEVERY_TOOLTIP);
        this.trackEveryLabel2.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.trackEveryLabel2, gridBagConstraints);
        jPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 25, 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
        this.recordStackTraceCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.recordStackTraceCheckbox, (String)RECORD_TRACES_CHECKBOX_TEXT);
        this.recordStackTraceCheckbox.setToolTipText(STP_STACKTRACE_TOOLTIP);
        this.recordStackTraceCheckbox.addActionListener(this.getSettingsChangeListener());
        this.recordStackTraceCheckbox.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 25, 0, 0);
        this.add((Component)this.recordStackTraceCheckbox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)Utils.createFillerPanel(), gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.profilingPointsCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.profilingPointsCheckbox, (String)USE_PPS_CHECKBOX_TEXT);
        this.profilingPointsCheckbox.setToolTipText(STP_USEPPS_TOOLTIP);
        this.profilingPointsCheckbox.setOpaque(false);
        this.profilingPointsCheckbox.setSelected(true);
        this.profilingPointsCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MemorySettingsBasicPanel.this.updateEnabling();
            }
        });
        this.profilingPointsCheckbox.addActionListener(this.getSettingsChangeListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        jPanel2.add((Component)this.profilingPointsCheckbox, gridBagConstraints);
        Color color = Color.RED;
        String string = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        this.profilingPointsLink = new HyperlinkLabel("<nobr><a href='#'>" + SHOW_PPS_STRING + "</a></nobr>", "<nobr><a href='#' color=\"" + string + "\">" + SHOW_PPS_STRING + "</a></nobr>", new Runnable(){

            @Override
            public void run() {
                MemorySettingsBasicPanel.this.performShowProfilingPointsAction();
            }
        });
        this.profilingPointsLink.setToolTipText(STP_SHOWPPS_TOOLTIP);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)((Object)this.profilingPointsLink), gridBagConstraints);
        jPanel2.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 25, 10, 0);
        this.add((Component)jPanel2, gridBagConstraints);
    }

    private void performShowProfilingPointsAction() {
        this.profilingPointsDisplayer.run();
    }

    private void updateEnabling() {
        this.profilingPointsLink.setEnabled(this.profilingPointsCheckbox.isSelected() && this.profilingPointsCheckbox.isEnabled());
    }

    private void updateProject() {
        this.profilingPointsCheckbox.setEnabled(false);
    }
}

