/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.profiling.snapshot;

import com.sun.tools.visualvm.core.snapshot.SnapshotCategory;
import com.sun.tools.visualvm.profiling.snapshot.ProfilerSnapshot;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ResultsManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class ProfilerSnapshotCategory
extends SnapshotCategory<ProfilerSnapshot> {
    private static final Logger LOGGER = Logger.getLogger(ProfilerSnapshotCategory.class.getName());
    private static final String NAME = NbBundle.getMessage(ProfilerSnapshotCategory.class, (String)"MSG_Profiler_Snapshots");
    private static final String PREFIX = "snapshot";
    private static final String NPS_SUFFIX = ".nps";
    private static final String NPSS_SUFFIX = ".npss";

    public ProfilerSnapshotCategory() {
        super(NAME, ProfilerSnapshot.class, PREFIX, NPS_SUFFIX, 30);
    }

    public boolean supportsOpenSnapshot() {
        return true;
    }

    protected boolean isSnapshot(File file) {
        if (super.isSnapshot(file)) {
            return true;
        }
        return file != null && file.getName().endsWith(NPSS_SUFFIX);
    }

    public void openSnapshot(final File file) {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressHandle pHandleF;
                ProgressHandle pHandle = null;
                try {
                    pHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ProfilerSnapshotCategory.class, (String)"MSG_Opening_Profiler_Snapshot"));
                    pHandle.setInitialDelay(0);
                    pHandle.start();
                    try {
                        FileObject fileObject = FileUtil.toFileObject((File)file);
                        final LoadedSnapshot loadedSnapshot = ResultsManager.getDefault().loadSnapshot(fileObject);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ResultsManager.getDefault().openSnapshot(loadedSnapshot);
                            }
                        });
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.INFO, "Error loading profiler snapshot", e);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                NetBeansProfiler.getDefaultNB().displayError(NbBundle.getMessage(ProfilerSnapshotCategory.class, (String)"MSG_Opening_snapshot_failed"));
                            }
                        });
                    }
                    pHandleF = pHandle;
                }
                catch (Throwable throwable) {
                    ProgressHandle pHandleF2 = pHandle;
                    SwingUtilities.invokeLater(new Runnable(pHandleF2){
                        final /* synthetic */ ProgressHandle val$pHandleF;
                        {
                            this.val$pHandleF = progressHandle;
                        }

                        @Override
                        public void run() {
                            if (this.val$pHandleF != null) {
                                this.val$pHandleF.finish();
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    public FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || ProfilerSnapshotCategory.this.isSnapshot(f);
            }

            @Override
            public String getDescription() {
                String suff = ProfilerSnapshotCategory.this.getSuffix();
                return ProfilerSnapshotCategory.this.getName() + (suff != null ? " (*" + suff + ", *" + ProfilerSnapshotCategory.NPSS_SUFFIX + ")" : "");
            }
        };
    }
}

