/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import javax.swing.KeyStroke;
import org.openide.util.Utilities;

class Utils {
    Utils() {
    }

    static String getKeyStrokesAsText(KeyStroke[] keyStrokeArray, String string) {
        if (keyStrokeArray == null) {
            return "";
        }
        if (keyStrokeArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(Utils.getKeyStrokeAsText(keyStrokeArray[0]));
        int n = keyStrokeArray.length;
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(string).append(Utils.getKeyStrokeAsText(keyStrokeArray[i]));
        }
        return new String(stringBuffer);
    }

    static KeyStroke getKeyStroke(String string) {
        KeyStroke keyStroke;
        int n = 0;
        if (string.startsWith("Ctrl+")) {
            n |= 0x80;
            string = string.substring(5);
        }
        if (string.startsWith("Alt+")) {
            n |= 0x200;
            string = string.substring(4);
        }
        if (string.startsWith("Shift+")) {
            n |= 0x40;
            string = string.substring(6);
        }
        if (string.startsWith("Meta+")) {
            n |= 0x100;
            string = string.substring(5);
        }
        if ((keyStroke = Utilities.stringToKey((String)string)) == null) {
            return null;
        }
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(keyStroke.getKeyCode(), n);
        return keyStroke2;
    }

    static String getKeyStrokeAsText(KeyStroke keyStroke) {
        int n = keyStroke.getModifiers();
        StringBuilder stringBuilder = new StringBuilder();
        if ((n & 0x80) > 0) {
            stringBuilder.append("Ctrl+");
        }
        if ((n & 0x200) > 0) {
            stringBuilder.append("Alt+");
        }
        if ((n & 0x40) > 0) {
            stringBuilder.append("Shift+");
        }
        if ((n & 0x100) > 0) {
            stringBuilder.append("Meta+");
        }
        if (keyStroke.getKeyCode() != 16 && keyStroke.getKeyCode() != 17 && keyStroke.getKeyCode() != 157 && keyStroke.getKeyCode() != 18 && keyStroke.getKeyCode() != 65406) {
            stringBuilder.append(Utilities.keyToString((KeyStroke)KeyStroke.getKeyStroke(keyStroke.getKeyCode(), 0)));
        }
        return stringBuilder.toString();
    }
}

