/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.action;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.modules.print.provider.ComponentProvider;
import org.netbeans.modules.print.provider.EditorProvider;
import org.netbeans.modules.print.provider.TextProvider;
import org.netbeans.modules.print.ui.Preview;
import org.netbeans.modules.print.util.Config;
import org.netbeans.modules.print.util.UI;
import org.netbeans.spi.print.PrintProvider;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.PrintCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;

public final class PrintAction
extends UI.IconAction {
    private boolean myEnabled;
    private PrintProvider[] myProviders;

    public PrintAction() {
        this("MNU_Print_Action", "TLT_Print_Action", null, false, null);
    }

    public PrintAction(PrintProvider[] printProviderArray) {
        this(null, "ACT_Print_Action", "print", true, printProviderArray);
    }

    public PrintAction(JComponent jComponent) {
        this((PrintProvider[])null);
        this.myProviders = this.getComponentProviders(jComponent);
    }

    private PrintAction(String string, String string2, String string3, boolean bl, PrintProvider[] printProviderArray) {
        super(UI.i18n(PrintAction.class, string), UI.i18n(PrintAction.class, string2), UI.icon(Config.class, string3));
        this.setEnabled(bl);
        this.myEnabled = bl;
        this.myProviders = printProviderArray;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.myProviders == null) {
            this.myProviders = this.getPrintProviders();
        }
        if (this.myProviders != null) {
            Preview.getDefault().print(this.myProviders, true);
            if (!this.myEnabled) {
                this.myProviders = null;
            }
        } else {
            PrintCookie printCookie = this.getPrintCookie();
            if (printCookie != null) {
                printCookie.print();
            }
        }
    }

    private PrintProvider[] getPrintProviders() {
        PrintProvider[] printProviderArray = this.getTopProviders(UI.getActiveTopComponent());
        if (printProviderArray != null) {
            return printProviderArray;
        }
        return this.getEditorInputStreamProviders(UI.getSelectedNodes());
    }

    private PrintProvider[] getTopProviders(TopComponent topComponent) {
        PrintProvider printProvider = this.getLookupProvider(topComponent);
        if (printProvider != null) {
            return this.getProviders(printProvider);
        }
        return this.getComponentProviders((JComponent)topComponent);
    }

    private PrintProvider getLookupProvider(TopComponent topComponent) {
        if (topComponent == null) {
            return null;
        }
        return (PrintProvider)topComponent.getLookup().lookup(PrintProvider.class);
    }

    private PrintProvider[] getComponentProviders(JComponent jComponent) {
        if (jComponent == null) {
            return null;
        }
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        this.findPrintable(jComponent, arrayList);
        if (arrayList.size() == 0) {
            return null;
        }
        return this.getProviders(new ComponentProvider(arrayList, this.getName(arrayList, jComponent), this.getDate(jComponent)));
    }

    private PrintProvider[] getProviders(PrintProvider printProvider) {
        return new PrintProvider[]{printProvider};
    }

    private void findPrintable(Container container, List<JComponent> list) {
        Component[] componentArray;
        if (container.isShowing() && this.isPrintable(container)) {
            list.add((JComponent)container);
        }
        for (Component component : componentArray = container.getComponents()) {
            if (!(component instanceof Container)) continue;
            this.findPrintable((Container)component, list);
        }
    }

    private boolean isPrintable(Container container) {
        return container instanceof JComponent && ((JComponent)container).getClientProperty("print.printable") == Boolean.TRUE;
    }

    private String getName(List<JComponent> list, JComponent jComponent) {
        for (JComponent jComponent2 : list) {
            Object object = jComponent2.getClientProperty("print.name");
            if (!(object instanceof String)) continue;
            return (String)object;
        }
        return this.getName(this.getData(jComponent));
    }

    private String getName(DataObject dataObject) {
        if (dataObject == null) {
            return null;
        }
        return dataObject.getName();
    }

    private Date getDate(JComponent jComponent) {
        return this.getDate(this.getData(jComponent));
    }

    private Date getDate(DataObject dataObject) {
        if (dataObject == null) {
            return null;
        }
        return dataObject.getPrimaryFile().lastModified();
    }

    private DataObject getData(JComponent jComponent) {
        if (!(jComponent instanceof TopComponent)) {
            return null;
        }
        return (DataObject)((TopComponent)jComponent).getLookup().lookup(DataObject.class);
    }

    private PrintProvider[] getEditorInputStreamProviders(Node[] nodeArray) {
        if (nodeArray == null) {
            return null;
        }
        ArrayList<PrintProvider> arrayList = new ArrayList<PrintProvider>();
        for (Node node : nodeArray) {
            PrintProvider printProvider = this.getEditorInputStreamProvider(node);
            if (printProvider == null) continue;
            arrayList.add(printProvider);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new PrintProvider[arrayList.size()]);
    }

    private PrintProvider getEditorInputStreamProvider(Node node) {
        String string = this.getText((InputStream)node.getLookup().lookup(InputStream.class));
        if (string != null) {
            return new TextProvider(string);
        }
        EditorCookie editorCookie = (EditorCookie)node.getLookup().lookup(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        if (editorCookie.getDocument() == null) {
            return null;
        }
        return new EditorProvider(editorCookie, this.getDate(UI.getDataObject(node)));
    }

    private String getText(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        try {
            inputStream.reset();
            int n = inputStream.available();
            byte[] byArray = new byte[n];
            inputStream.read(byArray);
            inputStream.close();
            return new String(byArray);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private PrintCookie getPrintCookie() {
        Node node = UI.getSelectedNode();
        if (node == null) {
            return null;
        }
        return (PrintCookie)node.getCookie(PrintCookie.class);
    }

    @Override
    public boolean isEnabled() {
        if (this.myEnabled) {
            return true;
        }
        return this.getPrintProviders() != null || this.getPrintCookie() != null;
    }
}

