/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities.soql;

import sun.jvm.hotspot.oops.Array;
import sun.jvm.hotspot.oops.TypeArray;
import sun.jvm.hotspot.oops.TypeArrayKlass;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.soql.JSJavaArrayKlass;
import sun.jvm.hotspot.utilities.soql.JSJavaFactory;

public class JSJavaTypeArrayKlass
extends JSJavaArrayKlass {
    public JSJavaTypeArrayKlass(TypeArrayKlass kls, JSJavaFactory fac) {
        super(kls, fac);
    }

    public final TypeArrayKlass getTypeArrayKlass() {
        return (TypeArrayKlass)this.getArrayKlass();
    }

    public String getName() {
        int type = this.getTypeArrayKlass().getElementType();
        switch (type) {
            case 4: {
                return "boolean[]";
            }
            case 5: {
                return "char[]";
            }
            case 6: {
                return "float[]";
            }
            case 7: {
                return "double[]";
            }
            case 8: {
                return "byte[]";
            }
            case 9: {
                return "short[]";
            }
            case 10: {
                return "int[]";
            }
            case 11: {
                return "long[]";
            }
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(false, "Unknown primitive array type");
        }
        return null;
    }

    public Object getFieldValue(int index, Array array) {
        TypeArray typeArr = (TypeArray)array;
        int type = this.getTypeArrayKlass().getElementType();
        switch (type) {
            case 4: {
                return typeArr.getBooleanAt(index);
            }
            case 5: {
                return new String(new char[]{typeArr.getCharAt(index)});
            }
            case 6: {
                return new Float(typeArr.getFloatAt(index));
            }
            case 7: {
                return new Double(typeArr.getDoubleAt(index));
            }
            case 8: {
                return new Byte(typeArr.getByteAt(index));
            }
            case 9: {
                return new Short(typeArr.getShortAt(index));
            }
            case 10: {
                return new Integer(typeArr.getIntAt(index));
            }
            case 11: {
                return new Long(typeArr.getLongAt(index));
            }
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(false, "Unknown primitive array type");
        }
        return null;
    }
}

