/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.sparc.SPARCFloatRegisters;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.utilities.Assert;

public class SPARCFloatRegister
extends SPARCRegister {
    public static final int SINGLE_PRECISION = 1;
    public static final int DOUBLE_PRECISION = 2;
    public static final int QUAD_PRECISION = 3;
    private static final int nofRegisters = 63;

    public SPARCFloatRegister(int number) {
        super(number);
    }

    public int getNumber() {
        return this.number;
    }

    public int getNumber(int width) {
        switch (width) {
            case 1: {
                Assert.that(this.number < 32, "bad single-prec fp register");
                return this.number;
            }
            case 2: {
                Assert.that(this.number < 64 && (this.number & 1) == 0, "bad double-prec fp register");
                return this.number & 0x1E | (this.number & 0x20) >> 5;
            }
            case 3: {
                Assert.that(this.number < 64 && (this.number & 3) == 0, "bad quad-prec fp register");
                return this.number & 0x1C | (this.number & 0x20) >> 5;
            }
        }
        throw new RuntimeException("Invalid floating point width supplied");
    }

    public int getNumberOfRegisters() {
        return 63;
    }

    public boolean isFloat() {
        return true;
    }

    public boolean isFramePointer() {
        return false;
    }

    public boolean isStackPointer() {
        return false;
    }

    public boolean isV9Only() {
        return this.number > 31;
    }

    public boolean isValid() {
        return this.number >= 0 && this.number < 63;
    }

    public String toString() {
        return SPARCFloatRegisters.getRegisterName(this.number);
    }
}

