/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.util.Arrays;
import java.util.Comparator;

public final class CharSequences {
    private static final CompactCharSequence EMPTY = new Fixed_0_7(new byte[0], 0);
    private static final CharSequenceComparator Comparator = new CharSequenceComparator();

    public static CharSequence create(char[] cArray, int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > cArray.length - n2) {
            throw new StringIndexOutOfBoundsException(n + n2);
        }
        int n3 = n2;
        if (n3 == 0) {
            return EMPTY;
        }
        byte[] byArray = new byte[n3];
        boolean bl = true;
        for (int i = 0; i < n3; ++i) {
            char c = cArray[n + i];
            if ((c & 0xFF) != c) {
                bl = false;
                break;
            }
            byArray[i] = (byte)c;
        }
        if (bl) {
            return CharSequences.createFromBytes(byArray, n3);
        }
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        return new CharBasedSequence(cArray2);
    }

    public static CharSequence create(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        if (charSequence instanceof CompactCharSequence) {
            return charSequence;
        }
        int n = charSequence.length();
        if (n == 0) {
            return EMPTY;
        }
        byte[] byArray = new byte[n];
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if ((c & 0xFF) != c) {
                bl = false;
                break;
            }
            byArray[i] = (byte)c;
        }
        if (bl) {
            return CharSequences.createFromBytes(byArray, n);
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = charSequence.charAt(i);
        }
        return new CharBasedSequence(cArray);
    }

    public static Comparator<CharSequence> comparator() {
        return Comparator;
    }

    public static CharSequence empty() {
        return EMPTY;
    }

    public static boolean isCompact(CharSequence charSequence) {
        return charSequence instanceof CompactCharSequence;
    }

    public static int indexOf(CharSequence charSequence, CharSequence charSequence2) {
        return CharSequences.indexOf(charSequence, charSequence2, 0);
    }

    public static int indexOf(CharSequence charSequence, CharSequence charSequence2, int n) {
        int n2 = charSequence.length();
        int n3 = charSequence2.length();
        if (n >= n2) {
            return n3 == 0 ? n2 : -1;
        }
        if (n < 0) {
            n = 0;
        }
        if (n3 == 0) {
            return n;
        }
        char c = charSequence2.charAt(0);
        int n4 = n2 - n3;
        for (int i = n; i <= n4; ++i) {
            if (charSequence.charAt(i) != c) {
                while (++i <= n4 && charSequence.charAt(i) != c) {
                }
            }
            if (i > n4) continue;
            int n5 = i + 1;
            int n6 = n5 + n3 - 1;
            int n7 = 1;
            while (n5 < n6 && charSequence.charAt(n5) == charSequence2.charAt(n7)) {
                ++n5;
                ++n7;
            }
            if (n5 != n6) continue;
            return i;
        }
        return -1;
    }

    private static CompactCharSequence createFromBytes(byte[] byArray, int n) {
        if (n < 8) {
            return new Fixed_0_7(byArray, n);
        }
        if (n < 16) {
            return new Fixed_8_15(byArray, n);
        }
        if (n < 24) {
            return new Fixed_16_23(byArray, n);
        }
        return new ByteBasedSequence(byArray);
    }

    private CharSequences() {
    }

    private static interface CompactCharSequence
    extends CharSequence {
    }

    private static class CharSequenceComparator
    implements Comparator<CharSequence> {
        private CharSequenceComparator() {
        }

        @Override
        public int compare(CharSequence charSequence, CharSequence charSequence2) {
            if (charSequence instanceof ByteBasedSequence) {
                return CharSequenceComparator.compareByteBasedWithOther((ByteBasedSequence)charSequence, charSequence2);
            }
            if (charSequence2 instanceof ByteBasedSequence) {
                return -CharSequenceComparator.compareByteBasedWithOther((ByteBasedSequence)charSequence2, charSequence);
            }
            if (charSequence instanceof CharBasedSequence) {
                return CharSequenceComparator.compareCharBasedWithOther((CharBasedSequence)charSequence, charSequence2);
            }
            if (charSequence2 instanceof CharBasedSequence) {
                return -CharSequenceComparator.compareCharBasedWithOther((CharBasedSequence)charSequence2, charSequence);
            }
            int n = charSequence.length();
            int n2 = charSequence2.length();
            int n3 = Math.min(n, n2);
            for (int i = 0; i < n3; ++i) {
                char c;
                char c2 = charSequence.charAt(i);
                if (c2 == (c = charSequence2.charAt(i))) continue;
                return c2 - c;
            }
            return n - n2;
        }

        private static int compareByteBased(ByteBasedSequence byteBasedSequence, ByteBasedSequence byteBasedSequence2) {
            int n = byteBasedSequence.value.length;
            int n2 = byteBasedSequence2.value.length;
            int n3 = Math.min(n, n2);
            for (int i = 0; i < n3; ++i) {
                if (byteBasedSequence.value[i] == byteBasedSequence2.value[i]) continue;
                return (byteBasedSequence.value[i] & 0xFF) - (byteBasedSequence2.value[i] & 0xFF);
            }
            return n - n2;
        }

        private static int compareCharBased(CharBasedSequence charBasedSequence, CharBasedSequence charBasedSequence2) {
            int n = charBasedSequence.value.length;
            int n2 = charBasedSequence2.value.length;
            int n3 = Math.min(n, n2);
            for (int i = 0; i < n3; ++i) {
                if (charBasedSequence.value[i] == charBasedSequence2.value[i]) continue;
                return charBasedSequence.value[i] - charBasedSequence2.value[i];
            }
            return n - n2;
        }

        private static int compareByteBasedWithCharBased(ByteBasedSequence byteBasedSequence, CharBasedSequence charBasedSequence) {
            int n = byteBasedSequence.value.length;
            int n2 = charBasedSequence.value.length;
            int n3 = Math.min(n, n2);
            for (int i = 0; i < n3; ++i) {
                char c;
                int n4 = byteBasedSequence.value[i] & 0xFF;
                if (n4 == (c = charBasedSequence.value[i])) continue;
                return n4 - c;
            }
            return n - n2;
        }

        private static int compareByteBasedWithOther(ByteBasedSequence byteBasedSequence, CharSequence charSequence) {
            if (charSequence instanceof ByteBasedSequence) {
                return CharSequenceComparator.compareByteBased(byteBasedSequence, (ByteBasedSequence)charSequence);
            }
            if (charSequence instanceof CharBasedSequence) {
                return CharSequenceComparator.compareByteBasedWithCharBased(byteBasedSequence, (CharBasedSequence)charSequence);
            }
            int n = byteBasedSequence.value.length;
            int n2 = charSequence.length();
            int n3 = Math.min(n, n2);
            for (int i = 0; i < n3; ++i) {
                char c;
                int n4 = byteBasedSequence.value[i] & 0xFF;
                if (n4 == (c = charSequence.charAt(i))) continue;
                return n4 - c;
            }
            return n - n2;
        }

        private static int compareCharBasedWithOther(CharBasedSequence charBasedSequence, CharSequence charSequence) {
            if (charSequence instanceof CharBasedSequence) {
                return CharSequenceComparator.compareCharBased(charBasedSequence, (CharBasedSequence)charSequence);
            }
            if (charSequence instanceof ByteBasedSequence) {
                return -CharSequenceComparator.compareByteBasedWithCharBased((ByteBasedSequence)charSequence, charBasedSequence);
            }
            int n = charBasedSequence.value.length;
            int n2 = charSequence.length();
            int n3 = Math.min(n, n2);
            for (int i = 0; i < n3; ++i) {
                char c;
                char c2 = charBasedSequence.value[i];
                if (c2 == (c = charSequence.charAt(i))) continue;
                return c2 - c;
            }
            return n - n2;
        }
    }

    private static final class ByteBasedSequence
    implements CompactCharSequence,
    Comparable<CharSequence> {
        private final byte[] value;
        private int hash;

        private ByteBasedSequence(byte[] byArray) {
            this.value = byArray;
        }

        @Override
        public int length() {
            return this.value.length;
        }

        @Override
        public char charAt(int n) {
            int n2 = this.value[n] & 0xFF;
            return (char)n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof ByteBasedSequence) {
                ByteBasedSequence byteBasedSequence = (ByteBasedSequence)object;
                if (this.hash != 0 && byteBasedSequence.hash != 0 && this.hash != byteBasedSequence.hash) {
                    return false;
                }
                return Arrays.equals(this.value, byteBasedSequence.value);
            }
            return false;
        }

        public int hashCode() {
            int n = this.hash;
            if (n == 0) {
                int n2 = this.value.length;
                for (int i = 0; i < n2; ++i) {
                    n = 31 * n + this.value[i];
                }
                this.hash = n;
            }
            return n;
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return CharSequences.create(this.toChars(), n, n2 - n);
        }

        @Override
        public String toString() {
            char[] cArray = this.toChars();
            return new String(cArray);
        }

        private char[] toChars() {
            int n = this.value.length;
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                int n2 = this.value[i] & 0xFF;
                cArray[i] = (char)n2;
            }
            return cArray;
        }

        @Override
        public int compareTo(CharSequence charSequence) {
            return CharSequenceComparator.compareByteBasedWithOther(this, charSequence);
        }
    }

    private static final class CharBasedSequence
    implements CompactCharSequence,
    Comparable<CharSequence> {
        private final char[] value;
        private int hash;

        private CharBasedSequence(char[] cArray) {
            this.value = cArray;
        }

        @Override
        public int length() {
            return this.value.length;
        }

        @Override
        public char charAt(int n) {
            return this.value[n];
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof CharBasedSequence) {
                CharBasedSequence charBasedSequence = (CharBasedSequence)object;
                if (this.hash != 0 && charBasedSequence.hash != 0 && this.hash != charBasedSequence.hash) {
                    return false;
                }
                return Arrays.equals(this.value, charBasedSequence.value);
            }
            return false;
        }

        public int hashCode() {
            int n = this.hash;
            if (n == 0) {
                int n2 = this.value.length;
                for (int i = 0; i < n2; ++i) {
                    n = 31 * n + this.value[i];
                }
                this.hash = n;
            }
            return n;
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return CharSequences.create(this.value, n, n2 - n);
        }

        @Override
        public String toString() {
            return new String(this.value);
        }

        @Override
        public int compareTo(CharSequence charSequence) {
            return CharSequenceComparator.compareCharBasedWithOther(this, charSequence);
        }
    }

    private static final class Fixed_16_23
    implements CompactCharSequence,
    Comparable<CharSequence> {
        private final long i1;
        private final long i2;
        private final long i3;

        private Fixed_16_23(byte[] byArray, int n) {
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            switch (n) {
                case 23: {
                    l3 += (long)((byArray[22] & 0xFF) << 24);
                }
                case 22: {
                    l3 += (long)((byArray[21] & 0xFF) << 16);
                }
                case 21: {
                    l3 += (long)((byArray[20] & 0xFF) << 8);
                }
                case 20: {
                    l3 += (long)(byArray[19] & 0xFF);
                    l3 <<= 32;
                }
                case 19: {
                    l3 += (long)((byArray[18] & 0xFF) << 24);
                }
                case 18: {
                    l3 += (long)((byArray[17] & 0xFF) << 16);
                }
                case 17: {
                    l3 += (long)((byArray[16] & 0xFF) << 8);
                }
                case 16: {
                    l3 += (long)(byArray[15] & 0xFF);
                }
                case 15: {
                    l2 += (long)((byArray[14] & 0xFF) << 24);
                }
                case 14: {
                    l2 += (long)((byArray[13] & 0xFF) << 16);
                }
                case 13: {
                    l2 += (long)((byArray[12] & 0xFF) << 8);
                }
                case 12: {
                    l2 += (long)(byArray[11] & 0xFF);
                    l2 <<= 32;
                }
                case 11: {
                    l2 += (long)((byArray[10] & 0xFF) << 24);
                }
                case 10: {
                    l2 += (long)((byArray[9] & 0xFF) << 16);
                }
                case 9: {
                    l2 += (long)((byArray[8] & 0xFF) << 8);
                }
                case 8: {
                    l2 += (long)(byArray[7] & 0xFF);
                }
                case 7: {
                    l += (long)((byArray[6] & 0xFF) << 24);
                }
                case 6: {
                    l += (long)((byArray[5] & 0xFF) << 16);
                }
                case 5: {
                    l += (long)((byArray[4] & 0xFF) << 8);
                }
                case 4: {
                    l += (long)(byArray[3] & 0xFF);
                    l <<= 32;
                }
                case 3: {
                    l += (long)((byArray[2] & 0xFF) << 24);
                }
                case 2: {
                    l += (long)((byArray[1] & 0xFF) << 16);
                }
                case 1: {
                    l += (long)((byArray[0] & 0xFF) << 8);
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.i1 = l += (long)n;
            this.i2 = l2;
            this.i3 = l3;
        }

        @Override
        public int length() {
            return (int)(this.i1 & 0xFFL);
        }

        @Override
        public char charAt(int n) {
            int n2 = 0;
            switch (n) {
                case 0: {
                    n2 = (int)(this.i1 >> 8 & 0xFFL);
                    break;
                }
                case 1: {
                    n2 = (int)(this.i1 >> 16 & 0xFFL);
                    break;
                }
                case 2: {
                    n2 = (int)(this.i1 >> 24 & 0xFFL);
                    break;
                }
                case 3: {
                    n2 = (int)(this.i1 >> 32 & 0xFFL);
                    break;
                }
                case 4: {
                    n2 = (int)(this.i1 >> 40 & 0xFFL);
                    break;
                }
                case 5: {
                    n2 = (int)(this.i1 >> 48 & 0xFFL);
                    break;
                }
                case 6: {
                    n2 = (int)(this.i1 >> 56 & 0xFFL);
                    break;
                }
                case 7: {
                    n2 = (int)(this.i2 & 0xFFL);
                    break;
                }
                case 8: {
                    n2 = (int)(this.i2 >> 8 & 0xFFL);
                    break;
                }
                case 9: {
                    n2 = (int)(this.i2 >> 16 & 0xFFL);
                    break;
                }
                case 10: {
                    n2 = (int)(this.i2 >> 24 & 0xFFL);
                    break;
                }
                case 11: {
                    n2 = (int)(this.i2 >> 32 & 0xFFL);
                    break;
                }
                case 12: {
                    n2 = (int)(this.i2 >> 40 & 0xFFL);
                    break;
                }
                case 13: {
                    n2 = (int)(this.i2 >> 48 & 0xFFL);
                    break;
                }
                case 14: {
                    n2 = (int)(this.i2 >> 56 & 0xFFL);
                    break;
                }
                case 15: {
                    n2 = (int)(this.i3 & 0xFFL);
                    break;
                }
                case 16: {
                    n2 = (int)(this.i3 >> 8 & 0xFFL);
                    break;
                }
                case 17: {
                    n2 = (int)(this.i3 >> 16 & 0xFFL);
                    break;
                }
                case 18: {
                    n2 = (int)(this.i3 >> 24 & 0xFFL);
                    break;
                }
                case 19: {
                    n2 = (int)(this.i3 >> 32 & 0xFFL);
                    break;
                }
                case 20: {
                    n2 = (int)(this.i3 >> 40 & 0xFFL);
                    break;
                }
                case 21: {
                    n2 = (int)(this.i3 >> 48 & 0xFFL);
                    break;
                }
                case 22: {
                    n2 = (int)(this.i3 >> 56 & 0xFFL);
                }
            }
            return (char)n2;
        }

        @Override
        public String toString() {
            int n = this.length();
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = this.charAt(i);
            }
            return new String(cArray);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Fixed_16_23) {
                Fixed_16_23 fixed_16_23 = (Fixed_16_23)object;
                return this.i1 == fixed_16_23.i1 && this.i2 == fixed_16_23.i2 && this.i3 == fixed_16_23.i3;
            }
            return false;
        }

        public int hashCode() {
            long l = this.i1 + 31L * (this.i2 + 31L * this.i3);
            l = l + (l >> 32) & 0xFFFFFFFFL;
            return (int)l;
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return CharSequences.create(this.toString().substring(n, n2));
        }

        @Override
        public int compareTo(CharSequence charSequence) {
            return Comparator.compare(this, charSequence);
        }
    }

    private static final class Fixed_8_15
    implements CompactCharSequence,
    Comparable<CharSequence> {
        private final int i1;
        private final int i2;
        private final int i3;
        private final int i4;

        private Fixed_8_15(byte[] byArray, int n) {
            int n2 = n;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            switch (n) {
                case 15: {
                    n5 += (byArray[14] & 0xFF) << 24;
                }
                case 14: {
                    n5 += (byArray[13] & 0xFF) << 16;
                }
                case 13: {
                    n5 += (byArray[12] & 0xFF) << 8;
                }
                case 12: {
                    n5 += byArray[11] & 0xFF;
                }
                case 11: {
                    n4 += (byArray[10] & 0xFF) << 24;
                }
                case 10: {
                    n4 += (byArray[9] & 0xFF) << 16;
                }
                case 9: {
                    n4 += (byArray[8] & 0xFF) << 8;
                }
                case 8: {
                    n4 += byArray[7] & 0xFF;
                }
                case 7: {
                    n3 += (byArray[6] & 0xFF) << 24;
                }
                case 6: {
                    n3 += (byArray[5] & 0xFF) << 16;
                }
                case 5: {
                    n3 += (byArray[4] & 0xFF) << 8;
                }
                case 4: {
                    n3 += byArray[3] & 0xFF;
                }
                case 3: {
                    n2 += (byArray[2] & 0xFF) << 24;
                }
                case 2: {
                    n2 += (byArray[1] & 0xFF) << 16;
                }
                case 1: {
                    n2 += (byArray[0] & 0xFF) << 8;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.i1 = n2;
            this.i2 = n3;
            this.i3 = n4;
            this.i4 = n5;
        }

        @Override
        public int length() {
            return this.i1 & 0xFF;
        }

        @Override
        public char charAt(int n) {
            int n2 = 0;
            switch (n) {
                case 0: {
                    n2 = (this.i1 & 0xFF00) >> 8;
                    break;
                }
                case 1: {
                    n2 = (this.i1 & 0xFF0000) >> 16;
                    break;
                }
                case 2: {
                    n2 = this.i1 >> 24 & 0xFF;
                    break;
                }
                case 3: {
                    n2 = this.i2 & 0xFF;
                    break;
                }
                case 4: {
                    n2 = (this.i2 & 0xFF00) >> 8;
                    break;
                }
                case 5: {
                    n2 = (this.i2 & 0xFF0000) >> 16;
                    break;
                }
                case 6: {
                    n2 = this.i2 >> 24 & 0xFF;
                    break;
                }
                case 7: {
                    n2 = this.i3 & 0xFF;
                    break;
                }
                case 8: {
                    n2 = (this.i3 & 0xFF00) >> 8;
                    break;
                }
                case 9: {
                    n2 = (this.i3 & 0xFF0000) >> 16;
                    break;
                }
                case 10: {
                    n2 = this.i3 >> 24 & 0xFF;
                    break;
                }
                case 11: {
                    n2 = this.i4 & 0xFF;
                    break;
                }
                case 12: {
                    n2 = (this.i4 & 0xFF00) >> 8;
                    break;
                }
                case 13: {
                    n2 = (this.i4 & 0xFF0000) >> 16;
                    break;
                }
                case 14: {
                    n2 = this.i4 >> 24 & 0xFF;
                }
            }
            return (char)n2;
        }

        @Override
        public String toString() {
            int n = this.length();
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = this.charAt(i);
            }
            return new String(cArray);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Fixed_8_15) {
                Fixed_8_15 fixed_8_15 = (Fixed_8_15)object;
                return this.i1 == fixed_8_15.i1 && this.i2 == fixed_8_15.i2 && this.i3 == fixed_8_15.i3 && this.i4 == fixed_8_15.i4;
            }
            return false;
        }

        public int hashCode() {
            return this.i1 + 31 * (this.i2 + 31 * (this.i3 + 31 * this.i4));
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return CharSequences.create(this.toString().substring(n, n2));
        }

        @Override
        public int compareTo(CharSequence charSequence) {
            return Comparator.compare(this, charSequence);
        }
    }

    private static final class Fixed_0_7
    implements CompactCharSequence,
    Comparable<CharSequence> {
        private final int i1;
        private final int i2;

        private Fixed_0_7(byte[] byArray, int n) {
            int n2 = n;
            int n3 = 0;
            switch (n) {
                case 7: {
                    n3 += (byArray[6] & 0xFF) << 24;
                }
                case 6: {
                    n3 += (byArray[5] & 0xFF) << 16;
                }
                case 5: {
                    n3 += (byArray[4] & 0xFF) << 8;
                }
                case 4: {
                    n3 += byArray[3] & 0xFF;
                }
                case 3: {
                    n2 += (byArray[2] & 0xFF) << 24;
                }
                case 2: {
                    n2 += (byArray[1] & 0xFF) << 16;
                }
                case 1: {
                    n2 += (byArray[0] & 0xFF) << 8;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.i1 = n2;
            this.i2 = n3;
        }

        @Override
        public int length() {
            return this.i1 & 0xFF;
        }

        @Override
        public char charAt(int n) {
            int n2 = 0;
            switch (n) {
                case 0: {
                    n2 = (this.i1 & 0xFF00) >> 8;
                    break;
                }
                case 1: {
                    n2 = (this.i1 & 0xFF0000) >> 16;
                    break;
                }
                case 2: {
                    n2 = this.i1 >> 24 & 0xFF;
                    break;
                }
                case 3: {
                    n2 = this.i2 & 0xFF;
                    break;
                }
                case 4: {
                    n2 = (this.i2 & 0xFF00) >> 8;
                    break;
                }
                case 5: {
                    n2 = (this.i2 & 0xFF0000) >> 16;
                    break;
                }
                case 6: {
                    n2 = this.i2 >> 24 & 0xFF;
                }
            }
            return (char)n2;
        }

        @Override
        public String toString() {
            int n = this.length();
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = this.charAt(i);
            }
            return new String(cArray);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Fixed_0_7) {
                Fixed_0_7 fixed_0_7 = (Fixed_0_7)object;
                return this.i1 == fixed_0_7.i1 && this.i2 == fixed_0_7.i2;
            }
            return false;
        }

        public int hashCode() {
            int n = 0;
            for (int i = 0; i < this.length(); ++i) {
                n = 31 * n + this.charAt(i);
            }
            return n;
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return CharSequences.create(this.toString().substring(n, n2));
        }

        @Override
        public int compareTo(CharSequence charSequence) {
            return Comparator.compare(this, charSequence);
        }
    }
}

