/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.spi.multiview;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.core.multiview.MultiViewCloneableTopComponent;
import org.netbeans.core.multiview.MultiViewTopComponent;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.openide.awt.UndoRedo;
import org.openide.util.Lookup;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public final class MultiViewFactory {
    public static final MultiViewElement BLANK_ELEMENT = new Blank();
    public static final Action NOOP_CLOSE_ACTION = new NoopAction();

    private MultiViewFactory() {
    }

    public static TopComponent createMultiView(MultiViewDescription[] multiViewDescriptionArray, MultiViewDescription multiViewDescription) {
        return MultiViewFactory.createMultiView(multiViewDescriptionArray, multiViewDescription, MultiViewFactory.createDefaultCloseOpHandler());
    }

    public static TopComponent createMultiView(MultiViewDescription[] multiViewDescriptionArray, MultiViewDescription multiViewDescription, CloseOperationHandler closeOperationHandler) {
        if (multiViewDescriptionArray == null) {
            return null;
        }
        if (closeOperationHandler == null) {
            closeOperationHandler = MultiViewFactory.createDefaultCloseOpHandler();
        }
        MultiViewTopComponent multiViewTopComponent = new MultiViewTopComponent();
        multiViewTopComponent.setMultiViewDescriptions(multiViewDescriptionArray, multiViewDescription);
        multiViewTopComponent.setCloseOperationHandler(closeOperationHandler);
        return multiViewTopComponent;
    }

    public static CloneableTopComponent createCloneableMultiView(MultiViewDescription[] multiViewDescriptionArray, MultiViewDescription multiViewDescription) {
        return MultiViewFactory.createCloneableMultiView(multiViewDescriptionArray, multiViewDescription, MultiViewFactory.createDefaultCloseOpHandler());
    }

    public static CloneableTopComponent createCloneableMultiView(MultiViewDescription[] multiViewDescriptionArray, MultiViewDescription multiViewDescription, CloseOperationHandler closeOperationHandler) {
        if (multiViewDescriptionArray == null) {
            return null;
        }
        if (closeOperationHandler == null) {
            closeOperationHandler = MultiViewFactory.createDefaultCloseOpHandler();
        }
        MultiViewCloneableTopComponent multiViewCloneableTopComponent = new MultiViewCloneableTopComponent();
        multiViewCloneableTopComponent.setMultiViewDescriptions(multiViewDescriptionArray, multiViewDescription);
        multiViewCloneableTopComponent.setCloseOperationHandler(closeOperationHandler);
        return multiViewCloneableTopComponent;
    }

    static CloseOperationState createSafeCloseState() {
        return new CloseOperationState(true, "ID_CLOSE_OK", NOOP_CLOSE_ACTION, NOOP_CLOSE_ACTION);
    }

    public static CloseOperationState createUnsafeCloseState(String string, Action action, Action action2) {
        return new CloseOperationState(false, string == null ? "" : string, action == null ? NOOP_CLOSE_ACTION : action, action2 == null ? NOOP_CLOSE_ACTION : action2);
    }

    static CloseOperationHandler createDefaultCloseOpHandler() {
        return new DefaultCloseHandler();
    }

    private static final class NoopAction
    extends AbstractAction {
        private NoopAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private static final class DefaultCloseHandler
    implements CloseOperationHandler,
    Serializable {
        private static final long serialVersionUID = -3126744916624172427L;

        private DefaultCloseHandler() {
        }

        @Override
        public boolean resolveCloseOperation(CloseOperationState[] closeOperationStateArray) {
            if (closeOperationStateArray != null) {
                boolean bl = true;
                ArrayList<CloseOperationState> arrayList = new ArrayList<CloseOperationState>();
                for (int i = 0; i < closeOperationStateArray.length; ++i) {
                    if (closeOperationStateArray[i].canClose()) continue;
                    arrayList.add(closeOperationStateArray[i]);
                    bl = false;
                }
                if (!bl) {
                    throw new IllegalStateException("Cannot close component. Some of the elements require close operation handling. See MultiViewFactory.createMultiView()");
                }
            }
            return true;
        }
    }

    private static final class Blank
    implements MultiViewElement,
    Serializable {
        private JPanel panel = new JPanel();
        private JPanel bar = new JPanel();

        Blank() {
        }

        @Override
        public void componentActivated() {
        }

        @Override
        public void componentClosed() {
        }

        @Override
        public void componentDeactivated() {
        }

        @Override
        public void componentHidden() {
        }

        @Override
        public void componentOpened() {
        }

        @Override
        public void componentShowing() {
        }

        @Override
        public Action[] getActions() {
            return new Action[0];
        }

        @Override
        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        @Override
        public JComponent getToolbarRepresentation() {
            return this.bar;
        }

        @Override
        public JComponent getVisualRepresentation() {
            return this.panel;
        }

        @Override
        public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        }

        @Override
        public UndoRedo getUndoRedo() {
            return null;
        }

        @Override
        public CloseOperationState canCloseElement() {
            return CloseOperationState.STATE_OK;
        }
    }
}

