/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.interceptor.DefaultMBeanServerInterceptor;
import com.sun.jmx.interceptor.MBeanServerInterceptor;
import com.sun.jmx.mbeanserver.ClassLoaderRepositorySupport;
import com.sun.jmx.mbeanserver.MBeanInstantiator;
import com.sun.jmx.mbeanserver.MBeanServerDelegateImpl;
import com.sun.jmx.mbeanserver.ModifiableClassLoaderRepository;
import com.sun.jmx.mbeanserver.Repository;
import com.sun.jmx.mbeanserver.SecureClassLoaderRepository;
import com.sun.jmx.mbeanserver.SunJmxMBeanServer;
import com.sun.jmx.trace.Trace;
import java.io.ObjectInputStream;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanPermission;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerPermission;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.loading.ClassLoaderRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JmxMBeanServer
implements SunJmxMBeanServer {
    private static final String dbgTag = "MBeanServer";
    private final MBeanInstantiator instantiator;
    private final SecureClassLoaderRepository secureClr;
    private final boolean interceptorsEnabled;
    private final transient MBeanServer outerShell;
    private transient MBeanServerInterceptor mbsInterceptor = null;
    private final transient MBeanServerDelegate mBeanServerDelegateObject;

    JmxMBeanServer(String string, MBeanServer mBeanServer, MBeanServerDelegate mBeanServerDelegate) {
        this(string, mBeanServer, mBeanServerDelegate, null, false);
    }

    JmxMBeanServer(String string, MBeanServer mBeanServer, MBeanServerDelegate mBeanServerDelegate, boolean bl) {
        this(string, mBeanServer, mBeanServerDelegate, null, false);
    }

    JmxMBeanServer(String string, MBeanServer mBeanServer, MBeanServerDelegate mBeanServerDelegate, MBeanInstantiator mBeanInstantiator, boolean bl) {
        Object object;
        if (mBeanInstantiator == null) {
            object = new ClassLoaderRepositorySupport();
            mBeanInstantiator = new MBeanInstantiator((ModifiableClassLoaderRepository)object);
        }
        this.secureClr = new SecureClassLoaderRepository(mBeanInstantiator.getClassLoaderRepository());
        if (mBeanServerDelegate == null) {
            mBeanServerDelegate = new MBeanServerDelegateImpl();
        }
        if (mBeanServer == null) {
            mBeanServer = this;
        }
        this.instantiator = mBeanInstantiator;
        this.mBeanServerDelegateObject = mBeanServerDelegate;
        this.outerShell = mBeanServer;
        object = new Repository(string);
        this.mbsInterceptor = new DefaultMBeanServerInterceptor(mBeanServer, mBeanServerDelegate, mBeanInstantiator, (Repository)object);
        this.interceptorsEnabled = bl;
        this.initialize();
    }

    @Override
    public boolean interceptorsEnabled() {
        return this.interceptorsEnabled;
    }

    @Override
    public MBeanInstantiator getMBeanInstantiator() {
        if (this.interceptorsEnabled) {
            return this.instantiator;
        }
        throw new UnsupportedOperationException("MBeanServerInterceptors are disabled.");
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.mbsInterceptor.createMBean(string, this.cloneObjectName(objectName), null, null);
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.mbsInterceptor.createMBean(string, this.cloneObjectName(objectName), objectName2, null, null);
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.mbsInterceptor.createMBean(string, this.cloneObjectName(objectName), objectArray, stringArray);
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.mbsInterceptor.createMBean(string, this.cloneObjectName(objectName), objectName2, objectArray, stringArray);
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.mbsInterceptor.registerMBean(object, this.cloneObjectName(objectName));
    }

    @Override
    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        this.mbsInterceptor.unregisterMBean(this.cloneObjectName(objectName));
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        return this.mbsInterceptor.getObjectInstance(this.cloneObjectName(objectName));
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName objectName, QueryExp queryExp) {
        return this.mbsInterceptor.queryMBeans(this.cloneObjectName(objectName), queryExp);
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName objectName, QueryExp queryExp) {
        return this.mbsInterceptor.queryNames(this.cloneObjectName(objectName), queryExp);
    }

    @Override
    public boolean isRegistered(ObjectName objectName) {
        return this.mbsInterceptor.isRegistered(objectName);
    }

    @Override
    public Integer getMBeanCount() {
        return this.mbsInterceptor.getMBeanCount();
    }

    @Override
    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        return this.mbsInterceptor.getAttribute(this.cloneObjectName(objectName), string);
    }

    @Override
    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        return this.mbsInterceptor.getAttributes(this.cloneObjectName(objectName), stringArray);
    }

    @Override
    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.mbsInterceptor.setAttribute(this.cloneObjectName(objectName), this.cloneAttribute(attribute));
    }

    @Override
    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        return this.mbsInterceptor.setAttributes(this.cloneObjectName(objectName), this.cloneAttributeList(attributeList));
    }

    @Override
    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.mbsInterceptor.invoke(this.cloneObjectName(objectName), string, objectArray, stringArray);
    }

    @Override
    public String getDefaultDomain() {
        return this.mbsInterceptor.getDefaultDomain();
    }

    @Override
    public String[] getDomains() {
        return this.mbsInterceptor.getDomains();
    }

    @Override
    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        this.mbsInterceptor.addNotificationListener(this.cloneObjectName(objectName), notificationListener, notificationFilter, object);
    }

    @Override
    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        this.mbsInterceptor.addNotificationListener(this.cloneObjectName(objectName), objectName2, notificationFilter, object);
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbsInterceptor.removeNotificationListener(this.cloneObjectName(objectName), notificationListener);
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbsInterceptor.removeNotificationListener(this.cloneObjectName(objectName), notificationListener, notificationFilter, object);
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbsInterceptor.removeNotificationListener(this.cloneObjectName(objectName), objectName2);
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbsInterceptor.removeNotificationListener(this.cloneObjectName(objectName), objectName2, notificationFilter, object);
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.mbsInterceptor.getMBeanInfo(this.cloneObjectName(objectName));
    }

    @Override
    public Object instantiate(String string) throws ReflectionException, MBeanException {
        JmxMBeanServer.checkMBeanPermission(string, null, null, "instantiate");
        return this.instantiator.instantiate(string);
    }

    @Override
    public Object instantiate(String string, ObjectName objectName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        JmxMBeanServer.checkMBeanPermission(string, null, null, "instantiate");
        ClassLoader classLoader = this.outerShell.getClass().getClassLoader();
        return this.instantiator.instantiate(string, objectName, classLoader);
    }

    @Override
    public Object instantiate(String string, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException {
        JmxMBeanServer.checkMBeanPermission(string, null, null, "instantiate");
        ClassLoader classLoader = this.outerShell.getClass().getClassLoader();
        return this.instantiator.instantiate(string, objectArray, stringArray, classLoader);
    }

    @Override
    public Object instantiate(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException, InstanceNotFoundException {
        JmxMBeanServer.checkMBeanPermission(string, null, null, "instantiate");
        ClassLoader classLoader = this.outerShell.getClass().getClassLoader();
        return this.instantiator.instantiate(string, objectName, objectArray, stringArray, classLoader);
    }

    @Override
    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        return this.mbsInterceptor.isInstanceOf(this.cloneObjectName(objectName), string);
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(ObjectName objectName, byte[] byArray) throws InstanceNotFoundException, OperationsException {
        ClassLoader classLoader = this.getClassLoaderFor(objectName);
        return this.instantiator.deserialize(classLoader, byArray);
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(String string, byte[] byArray) throws OperationsException, ReflectionException {
        Class<?> clazz;
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null className passed in parameter");
        }
        ClassLoaderRepository classLoaderRepository = this.getClassLoaderRepository();
        try {
            if (classLoaderRepository == null) {
                throw new ClassNotFoundException(string);
            }
            clazz = classLoaderRepository.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException, "The given class could not be loaded by the default loader repository");
        }
        return this.instantiator.deserialize(clazz.getClassLoader(), byArray);
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(String string, ObjectName objectName, byte[] byArray) throws InstanceNotFoundException, OperationsException, ReflectionException {
        objectName = this.cloneObjectName(objectName);
        try {
            this.getClassLoader(objectName);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            // empty catch block
        }
        ClassLoader classLoader = this.outerShell.getClass().getClassLoader();
        return this.instantiator.deserialize(string, objectName, byArray, classLoader);
    }

    private void initialize() {
        if (this.instantiator == null) {
            throw new IllegalStateException("instantiator must not be null.");
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    JmxMBeanServer.this.mbsInterceptor.registerMBean(JmxMBeanServer.this.mBeanServerDelegateObject, MBeanServerDelegate.DELEGATE_NAME);
                    return null;
                }
            });
        }
        catch (SecurityException securityException) {
            if (this.isDebugOn()) {
                this.debug("new", "Unexpected security exception occurred: " + securityException);
            }
            throw securityException;
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("new", "Unexpected exception occurred: " + exception.getClass().getName());
            }
            throw new IllegalStateException("Can't register delegate.");
        }
        ClassLoader classLoader = this.outerShell.getClass().getClassLoader();
        ModifiableClassLoaderRepository modifiableClassLoaderRepository = this.instantiator.getClassLoaderRepository();
        if (modifiableClassLoaderRepository != null) {
            modifiableClassLoaderRepository.addClassLoader(classLoader);
            ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
            if (classLoader2 != classLoader) {
                modifiableClassLoaderRepository.addClassLoader(classLoader2);
            }
        }
    }

    @Override
    public synchronized MBeanServerInterceptor getMBeanServerInterceptor() {
        if (this.interceptorsEnabled) {
            return this.mbsInterceptor;
        }
        throw new UnsupportedOperationException("MBeanServerInterceptors are disabled.");
    }

    @Override
    public synchronized void setMBeanServerInterceptor(MBeanServerInterceptor mBeanServerInterceptor) {
        if (!this.interceptorsEnabled) {
            throw new UnsupportedOperationException("MBeanServerInterceptors are disabled.");
        }
        if (mBeanServerInterceptor == null) {
            throw new IllegalArgumentException("MBeanServerInterceptor is null");
        }
        this.mbsInterceptor = mBeanServerInterceptor;
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        return this.mbsInterceptor.getClassLoaderFor(this.cloneObjectName(objectName));
    }

    @Override
    public ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        return this.mbsInterceptor.getClassLoader(this.cloneObjectName(objectName));
    }

    @Override
    public ClassLoaderRepository getClassLoaderRepository() {
        JmxMBeanServer.checkMBeanPermission(null, null, null, "getClassLoaderRepository");
        return this.secureClr;
    }

    @Override
    public MBeanServerDelegate getMBeanServerDelegate() {
        if (!this.interceptorsEnabled) {
            throw new UnsupportedOperationException("MBeanServerInterceptors are disabled.");
        }
        return this.mBeanServerDelegateObject;
    }

    public static MBeanServerDelegate newMBeanServerDelegate() {
        return new MBeanServerDelegateImpl();
    }

    public static MBeanServer newMBeanServer(String string, MBeanServer mBeanServer, MBeanServerDelegate mBeanServerDelegate, boolean bl) {
        JmxMBeanServer.checkNewMBeanServerPermission();
        return new JmxMBeanServer(string, mBeanServer, mBeanServerDelegate, bl);
    }

    private ObjectName cloneObjectName(ObjectName objectName) {
        if (objectName != null) {
            return ObjectName.getInstance(objectName);
        }
        return objectName;
    }

    private Attribute cloneAttribute(Attribute attribute) {
        if (attribute != null && !attribute.getClass().equals(Attribute.class)) {
            return new Attribute(attribute.getName(), attribute.getValue());
        }
        return attribute;
    }

    private AttributeList cloneAttributeList(AttributeList attributeList) {
        if (attributeList != null) {
            if (!attributeList.getClass().equals(AttributeList.class)) {
                AttributeList attributeList2 = new AttributeList(attributeList.size());
                for (Attribute attribute : attributeList) {
                    attributeList2.add(this.cloneAttribute(attribute));
                }
                return attributeList2;
            }
            for (int i = 0; i < attributeList.size(); ++i) {
                Attribute attribute = (Attribute)attributeList.get(i);
                if (attribute.getClass().equals(Attribute.class)) continue;
                attributeList.set(i, this.cloneAttribute(attribute));
            }
            return attributeList;
        }
        return attributeList;
    }

    private static void checkMBeanPermission(String string, String string2, ObjectName objectName, String string3) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            MBeanPermission mBeanPermission = new MBeanPermission(string, string2, objectName, string3);
            securityManager.checkPermission(mBeanPermission);
        }
    }

    private static void checkNewMBeanServerPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            MBeanServerPermission mBeanServerPermission = new MBeanServerPermission("newMBeanServer");
            securityManager.checkPermission(mBeanServerPermission);
        }
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, 1);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, 1, string, string2, string3);
    }

    private void trace(String string, String string2) {
        this.trace(dbgTag, string, string2);
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, 1);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(2, 1, string, string2, string3);
    }

    private void debug(String string, String string2) {
        this.debug(dbgTag, string, string2);
    }
}

