/*
 * %W% %E%
 *
 * Copyright (c) 2006, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

#include <stdio.h>
#include "splashscreen.h"

extern void* SplashProcAddress(const char* name); /* in java_md.c */

/*
 * Prototypes of pointers to functions in splashscreen shared lib
 */
typedef int (*SplashLoadMemory_t)(void* pdata, int size);
typedef int (*SplashLoadFile_t)(const char* filename);
typedef void (*SplashInit_t)(void);
typedef void (*SplashClose_t)(void);
typedef void (*SplashSetFileJarName_t)(const char* fileName, 
                                       const char* jarName);

/*
 * This macro invokes a function from the shared lib.
 * it locates a function with SplashProcAddress on demand.
 * if SplashProcAddress fails, def value is returned.
 *
 * it is further wrapped with INVOKEV (works with functions which return
 * void and INVOKE (for all other functions). INVOKEV looks a bit ugly,
 * that's due being unable to return a value of type void in C. INVOKEV
 * works around this by using semicolon instead of return operator.
 */
#define _INVOKE(name,def,ret) \
    static void* proc = NULL; \
    if (!proc) { proc = SplashProcAddress(#name); } \
    if (!proc) { return def; } \
    ret ((name##_t)proc)

#define INVOKE(name,def) _INVOKE(name,def,return)
#define INVOKEV(name) _INVOKE(name,;,;)

int     DoSplashLoadMemory(void* pdata, int size) {
    INVOKE(SplashLoadMemory,0)(pdata, size);
}

int     DoSplashLoadFile(const char* filename) {
    INVOKE(SplashLoadFile,0)(filename);
}

void    DoSplashInit(void) {
    INVOKEV(SplashInit)();
}

void    DoSplashClose(void) {
    INVOKEV(SplashClose)();
}

void    DoSplashSetFileJarName(const char* fileName, const char* jarName) {
    INVOKEV(SplashSetFileJarName)(fileName, jarName);
}
