/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.netbeans.lib.profiler.wireprotocol.AsyncMessageCommand;
import org.netbeans.lib.profiler.wireprotocol.CalibrationDataResponse;
import org.netbeans.lib.profiler.wireprotocol.ClassLoadedCommand;
import org.netbeans.lib.profiler.wireprotocol.CodeRegionCPUResultsResponse;
import org.netbeans.lib.profiler.wireprotocol.Command;
import org.netbeans.lib.profiler.wireprotocol.DefiningLoaderResponse;
import org.netbeans.lib.profiler.wireprotocol.DumpResultsResponse;
import org.netbeans.lib.profiler.wireprotocol.EventBufferDumpedCommand;
import org.netbeans.lib.profiler.wireprotocol.GetClassIdCommand;
import org.netbeans.lib.profiler.wireprotocol.GetClassIdResponse;
import org.netbeans.lib.profiler.wireprotocol.GetDefiningClassLoaderCommand;
import org.netbeans.lib.profiler.wireprotocol.GetMethodNamesForJMethodIdsCommand;
import org.netbeans.lib.profiler.wireprotocol.InitiateInstrumentationCommand;
import org.netbeans.lib.profiler.wireprotocol.InstrumentMethodGroupCommand;
import org.netbeans.lib.profiler.wireprotocol.InstrumentMethodGroupResponse;
import org.netbeans.lib.profiler.wireprotocol.InternalStatsResponse;
import org.netbeans.lib.profiler.wireprotocol.MethodInvokedFirstTimeCommand;
import org.netbeans.lib.profiler.wireprotocol.MethodLoadedCommand;
import org.netbeans.lib.profiler.wireprotocol.MethodNamesResponse;
import org.netbeans.lib.profiler.wireprotocol.MonitoredNumbersResponse;
import org.netbeans.lib.profiler.wireprotocol.ObjectAllocationResultsResponse;
import org.netbeans.lib.profiler.wireprotocol.Response;
import org.netbeans.lib.profiler.wireprotocol.RootClassLoadedCommand;
import org.netbeans.lib.profiler.wireprotocol.SetChangeableInstrParamsCommand;
import org.netbeans.lib.profiler.wireprotocol.SetUnchangeableInstrParamsCommand;
import org.netbeans.lib.profiler.wireprotocol.TakeHeapDumpCommand;
import org.netbeans.lib.profiler.wireprotocol.ThreadLivenessStatusResponse;
import org.netbeans.lib.profiler.wireprotocol.VMPropertiesResponse;

public class WireIO {
    static final boolean DEBUG = System.getProperty("org.netbeans.lib.profiler.wireprotocol.WireIO") != null;
    private static final int IS_SIMPLE_COMMAND = 1;
    private static final int IS_COMPLEX_COMMAND = 2;
    private static final int IS_SIMPLE_RESPONSE = 3;
    private static final int IS_COMPLEX_RESPONSE = 4;
    private ObjectInputStream in;
    private ObjectOutputStream out;
    private long wasAlive;

    public WireIO(ObjectOutputStream objectOutputStream, ObjectInputStream objectInputStream) {
        this.out = objectOutputStream;
        this.in = objectInputStream;
    }

    public Object receiveCommandOrResponse() throws IOException {
        int n = this.in.read();
        this.wasAlive = System.currentTimeMillis();
        switch (n) {
            case 1: {
                Command command = new Command(this.in.read());
                if (DEBUG) {
                    System.out.println("WireIO.DEBUG: received simple command: " + command);
                }
                return command;
            }
            case 2: {
                int n2 = this.in.read();
                if (DEBUG) {
                    System.out.println("WireIO.DEBUG: received complex command type: " + Command.cmdTypeToString(n2));
                }
                Command command = null;
                switch (n2) {
                    case 23: {
                        command = new MethodInvokedFirstTimeCommand();
                        break;
                    }
                    case 3: {
                        command = new ClassLoadedCommand();
                        break;
                    }
                    case 14: {
                        command = new AsyncMessageCommand();
                        break;
                    }
                    case 22: {
                        command = new MethodLoadedCommand();
                        break;
                    }
                    case 17: {
                        command = new RootClassLoadedCommand();
                        break;
                    }
                    case 13: {
                        command = new InitiateInstrumentationCommand();
                        break;
                    }
                    case 4: {
                        command = new SetChangeableInstrParamsCommand();
                        break;
                    }
                    case 5: {
                        command = new SetUnchangeableInstrParamsCommand();
                        break;
                    }
                    case 26: {
                        command = new EventBufferDumpedCommand();
                        break;
                    }
                    case 7: {
                        command = new InstrumentMethodGroupCommand();
                        break;
                    }
                    case 31: {
                        command = new GetMethodNamesForJMethodIdsCommand();
                        break;
                    }
                    case 35: {
                        command = new GetDefiningClassLoaderCommand();
                        break;
                    }
                    case 41: {
                        command = new TakeHeapDumpCommand();
                        break;
                    }
                    case 42: {
                        command = new GetClassIdCommand();
                        break;
                    }
                    default: {
                        throw new IOException("JFluid wire protocol error: received unknown command type. Value: " + n2);
                    }
                }
                command.readObject(this.in);
                if (DEBUG) {
                    System.out.println("WireIO.DEBUG:         command is: " + command);
                }
                return command;
            }
            case 3: {
                Response response = new Response(this.in.readBoolean());
                if (this.in.read() != 0) {
                    response.setErrorMessage(this.in.readUTF());
                } else {
                    response.setErrorMessage(null);
                }
                if (DEBUG) {
                    System.out.println("WireIO.DEBUG: received simple response " + response);
                }
                return response;
            }
            case 4: {
                int n3 = this.in.read();
                if (DEBUG) {
                    System.out.println("WireIO.DEBUG: received complex response " + Response.respTypeToString(n3));
                }
                Response response = null;
                switch (n3) {
                    case 1: {
                        response = new CodeRegionCPUResultsResponse();
                        break;
                    }
                    case 2: {
                        response = new InstrumentMethodGroupResponse();
                        break;
                    }
                    case 3: {
                        response = new InternalStatsResponse();
                        break;
                    }
                    case 4: {
                        response = new VMPropertiesResponse();
                        break;
                    }
                    case 5: {
                        response = new DumpResultsResponse();
                        break;
                    }
                    case 6: {
                        response = new ObjectAllocationResultsResponse();
                        break;
                    }
                    case 7: {
                        response = new MethodNamesResponse();
                        break;
                    }
                    case 8: {
                        response = new ThreadLivenessStatusResponse();
                        break;
                    }
                    case 9: {
                        response = new MonitoredNumbersResponse();
                        break;
                    }
                    case 10: {
                        response = new DefiningLoaderResponse();
                        break;
                    }
                    case 11: {
                        response = new CalibrationDataResponse();
                        break;
                    }
                    case 12: {
                        response = new GetClassIdResponse();
                        break;
                    }
                    default: {
                        throw new IOException("JFluid wire protocol error: received unknown response type. Value: " + n3);
                    }
                }
                response.setYes(this.in.readBoolean());
                if (this.in.read() != 0) {
                    response.setErrorMessage(this.in.readUTF());
                } else {
                    response.setErrorMessage(null);
                }
                response.readObject(this.in);
                if (DEBUG) {
                    System.out.println("WireIO.DEBUG:    response is: " + response);
                }
                return response;
            }
        }
        if (DEBUG) {
            System.out.println("WireIO.DEBUG: received unknown code: " + n);
        }
        throw new IOException("JFluid wire protocol error: code does not correspond to command or response. Value " + n);
    }

    public synchronized void sendComplexCommand(Command command) throws IOException {
        if (DEBUG) {
            System.out.println("WireIO.DEBUG: gonna send complex command: " + command);
        }
        this.out.write(2);
        this.out.write(command.getType());
        command.writeObject(this.out);
        this.out.flush();
    }

    public synchronized void sendComplexResponse(Response response) throws IOException {
        if (DEBUG) {
            System.out.println("WireIO.DEBUG: gonna send response: " + response);
        }
        this.out.write(4);
        this.out.write(response.getType());
        this.out.writeBoolean(response.yes());
        String string = response.getErrorMessage();
        if (string == null) {
            this.out.write(0);
        } else {
            this.out.write(1);
            this.out.writeUTF(string);
        }
        response.writeObject(this.out);
        this.out.flush();
    }

    public synchronized void sendSimpleCommand(int n) throws IOException {
        if (DEBUG) {
            System.out.println("WireIO.DEBUG: gonna send simple command:" + Command.cmdTypeToString(n));
        }
        this.out.write(1);
        this.out.write(n);
        this.out.flush();
    }

    public synchronized void sendSimpleResponse(boolean bl, String string) throws IOException {
        if (DEBUG) {
            System.out.println("WireIO.DEBUG: gonna send simple response: yes: " + bl + ", errorMessage: " + string);
        }
        this.out.write(3);
        this.out.writeBoolean(bl);
        if (string == null) {
            this.out.write(0);
        } else {
            this.out.write(1);
            this.out.writeUTF(string);
        }
        this.out.flush();
    }

    public long wasAlive() {
        return this.wasAlive;
    }
}

