/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;

class SingletonLookup
extends Lookup {
    private final Object objectToLookup;
    private final String id;

    SingletonLookup(Object object) {
        this(object, null);
    }

    SingletonLookup(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException("null");
        }
        this.objectToLookup = object;
        this.id = string;
    }

    @Override
    public <T> T lookup(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("null");
        }
        return clazz.isInstance(this.objectToLookup) ? (T)clazz.cast(this.objectToLookup) : null;
    }

    @Override
    public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        if (template == null) {
            throw new IllegalArgumentException("null");
        }
        Lookup.Item<T> item = this.lookupItem(template);
        if (item != null) {
            return new SingletonResult<T>(item);
        }
        return Lookup.EMPTY.lookup(template);
    }

    @Override
    public <T> Collection<? extends T> lookupAll(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("null");
        }
        return clazz.isInstance(this.objectToLookup) ? Collections.singletonList(clazz.cast(this.objectToLookup)) : Collections.emptyList();
    }

    @Override
    public <T> Lookup.Item<T> lookupItem(Lookup.Template<T> template) {
        if (template == null) {
            throw new IllegalArgumentException("null");
        }
        String string = template.getId();
        if (string != null && (this.id == null ? !string.equals(this.objectToLookup.toString()) : !string.equals(this.id))) {
            return null;
        }
        T t = template.getInstance();
        if (t != null && this.objectToLookup != t) {
            return null;
        }
        Class<T> clazz = template.getType();
        if (clazz != null && !clazz.isInstance(this.objectToLookup)) {
            return null;
        }
        Lookup.Item<Object> item = clazz != null ? Lookups.lookupItem(clazz.cast(this.objectToLookup), this.id) : Lookups.lookupItem(this.objectToLookup, this.id);
        return item;
    }

    static class SingletonResult<T>
    extends Lookup.Result<T> {
        private final Lookup.Item<T> item;

        SingletonResult(Lookup.Item<T> item) {
            this.item = item;
        }

        @Override
        public void addLookupListener(LookupListener lookupListener) {
        }

        @Override
        public void removeLookupListener(LookupListener lookupListener) {
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            return Collections.singleton(this.item.getType());
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            return Collections.singletonList(this.item);
        }

        @Override
        public Collection<? extends T> allInstances() {
            return Collections.singletonList(this.item.getInstance());
        }
    }
}

