/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InheritanceTree;

final class ArrayStorage
implements AbstractLookup.Storage<Transaction> {
    static final Integer DEFAULT_TRASH = new Integer(11);
    private Object content;
    private transient AbstractLookup.ReferenceToResult<?> results;

    public ArrayStorage() {
        this(DEFAULT_TRASH);
    }

    public ArrayStorage(Integer n) {
        this.content = n;
    }

    @Override
    public boolean add(AbstractLookup.Pair<?> pair, Transaction transaction) {
        Object[] objectArray = transaction.current;
        if (transaction.arr == null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    objectArray[i] = pair;
                    transaction.add(pair);
                    return true;
                }
                if (!objectArray[i].equals(pair)) continue;
                pair.setIndex(null, ((AbstractLookup.Pair)objectArray[i]).getIndex());
                objectArray[i] = pair;
                return false;
            }
            throw new IllegalStateException();
        }
        int n = transaction.addPair(pair);
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) {
                transaction.add(pair);
                return true;
            }
            if (!objectArray[i].equals(pair)) continue;
            if (i != n) {
                transaction.add(pair);
                return false;
            }
            return false;
        }
        transaction.add(pair);
        return true;
    }

    @Override
    public void remove(AbstractLookup.Pair pair, Transaction transaction) {
        Object[] objectArray = transaction.current;
        if (objectArray == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) {
                return;
            }
            if (n != -1 || !objectArray[i].equals(pair)) continue;
            AbstractLookup.Pair pair2 = (AbstractLookup.Pair)objectArray[i];
            pair2.setIndex(null, -1);
            transaction.add(pair2);
            n = i;
            if (n == -1) continue;
            if (i < objectArray.length && !(objectArray[i] instanceof Integer)) {
                objectArray[i - 1] = objectArray[i];
                continue;
            }
            objectArray[i - 1] = null;
        }
    }

    @Override
    public void retainAll(Map map, Transaction transaction) {
        Object[] objectArray = transaction.current;
        for (int i = 0; i < objectArray.length && objectArray[i] instanceof AbstractLookup.Pair; ++i) {
            AbstractLookup.Pair pair = (AbstractLookup.Pair)objectArray[i];
            AbstractLookup.Info info = (AbstractLookup.Info)map.get(pair);
            if (info != null) continue;
            transaction.add(pair);
        }
    }

    @Override
    public <T> Enumeration<AbstractLookup.Pair<T>> lookup(final Class<T> clazz) {
        if (this.content instanceof Object[]) {
            final Enumeration<Object> enumeration = InheritanceTree.arrayEn((Object[])this.content);
            class JustPairs
            implements Enumeration<AbstractLookup.Pair<T>> {
                private AbstractLookup.Pair<T> next;

                JustPairs() {
                }

                private AbstractLookup.Pair<T> findNext() {
                    while (this.next == null) {
                        if (!enumeration.hasMoreElements()) {
                            return null;
                        }
                        Object e = enumeration.nextElement();
                        boolean bl = e instanceof AbstractLookup.Pair ? clazz == null || ((AbstractLookup.Pair)e).instanceOf(clazz) : false;
                        this.next = bl ? (AbstractLookup.Pair)e : null;
                    }
                    return this.next;
                }

                @Override
                public boolean hasMoreElements() {
                    return this.findNext() != null;
                }

                @Override
                public AbstractLookup.Pair<T> nextElement() {
                    AbstractLookup.Pair pair = this.findNext();
                    if (pair == null) {
                        throw new NoSuchElementException();
                    }
                    this.next = null;
                    return pair;
                }
            }
            return new JustPairs();
        }
        return InheritanceTree.emptyEn();
    }

    @Override
    public AbstractLookup.ReferenceToResult registerReferenceToResult(AbstractLookup.ReferenceToResult<?> referenceToResult) {
        AbstractLookup.ReferenceToResult<?> referenceToResult2 = this.results;
        this.results = referenceToResult;
        return referenceToResult2;
    }

    @Override
    public AbstractLookup.ReferenceToResult cleanUpResult(Lookup.Template<?> template) {
        AbstractLookup.ReferenceIterator referenceIterator = new AbstractLookup.ReferenceIterator(this.results);
        while (referenceIterator.next()) {
        }
        this.results = referenceIterator.first();
        return this.results;
    }

    @Override
    public Transaction beginTransaction(int n) {
        return new Transaction(n, this.content);
    }

    @Override
    public void endTransaction(Transaction transaction, Set<AbstractLookup.R> set) {
        AbstractLookup.ReferenceIterator referenceIterator = new AbstractLookup.ReferenceIterator(this.results);
        if (transaction.arr == null) {
            while (referenceIterator.next()) {
                AbstractLookup.ReferenceToResult<?> referenceToResult = referenceIterator.current();
                for (AbstractLookup.Pair pair : transaction) {
                    if (!AbstractLookup.matches(referenceToResult.template, pair, true)) continue;
                    set.add(referenceToResult.getResult());
                }
            }
        } else {
            block2: while (referenceIterator.next()) {
                AbstractLookup.ReferenceToResult<?> referenceToResult = referenceIterator.current();
                int n = -1;
                int n2 = -1;
                do {
                    n = ArrayStorage.findMatching(referenceToResult.template, transaction.current, n);
                    n2 = ArrayStorage.findMatching(referenceToResult.template, transaction.arr, n2);
                    if (n == -1 && n2 == -1) continue block2;
                } while (n != -1 && n2 != -1 && transaction.current[n].equals(transaction.arr[n2]));
                set.add(referenceToResult.getResult());
            }
        }
        this.results = referenceIterator.first();
        this.content = transaction.newContent(this.content);
    }

    private static int findMatching(Lookup.Template template, Object[] objectArray, int n) {
        while (++n < objectArray.length) {
            if (!(objectArray[n] instanceof AbstractLookup.Pair) || !AbstractLookup.matches(template, (AbstractLookup.Pair)objectArray[n], true)) continue;
            return n;
        }
        return -1;
    }

    static final class Transaction
    extends HashSet<AbstractLookup.Pair<?>> {
        public final Object[] current;
        public final Object[] arr;
        private int cnt;

        public Transaction(int n, Object object) {
            int n2;
            Object[] objectArray;
            Integer n3;
            if (object instanceof Integer) {
                n3 = (Integer)object;
                objectArray = null;
            } else {
                objectArray = (Object[])object;
                n3 = objectArray[objectArray.length - 1] instanceof Integer ? (Integer)objectArray[objectArray.length - 1] : null;
            }
            int n4 = n2 = n3 == null ? objectArray.length : n3;
            if (n > n2) {
                throw new UnsupportedOperationException();
            }
            if (n == -1) {
                this.current = object instanceof Integer ? null : (Object[])object;
                this.arr = null;
                return;
            }
            if (n == -2) {
                if (objectArray == null) {
                    objectArray = new Object[2];
                    objectArray[1] = n3;
                } else {
                    if (objectArray[objectArray.length - 1] instanceof AbstractLookup.Pair) {
                        throw new UnsupportedOperationException();
                    }
                    if (objectArray.length < 2 || objectArray[objectArray.length - 2] != null) {
                        int n5 = (objectArray.length - 1) * 2;
                        if (n5 <= 1) {
                            n5 = 2;
                        }
                        if (n5 > n2) {
                            n5 = n2;
                            if (n5 <= objectArray.length) {
                                throw new UnsupportedOperationException();
                            }
                            objectArray = new Object[n5];
                        } else {
                            objectArray = new Object[n5 + 1];
                            objectArray[n5] = n3;
                        }
                        System.arraycopy(object, 0, objectArray, 0, ((Object[])object).length - 1);
                    }
                }
                this.current = objectArray;
                this.arr = null;
            } else {
                if (n == n2) {
                    this.arr = new Object[n];
                } else {
                    this.arr = new Object[n + 1];
                    this.arr[n] = n3;
                }
                this.current = object instanceof Object[] ? (Object[])object : new Object[]{};
            }
        }

        public int addPair(AbstractLookup.Pair<?> pair) {
            pair.setIndex(null, this.cnt);
            this.arr[this.cnt++] = pair;
            return pair.getIndex();
        }

        public Object newContent(Object object) {
            if (this.arr == null) {
                if (this.current == null) {
                    return object;
                }
                return this.current;
            }
            return this.arr;
        }
    }
}

