/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.settings.convertors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.MainLookup;
import org.netbeans.modules.settings.convertors.SerialDataConvertor;
import org.netbeans.modules.settings.convertors.XMLSettingsSupport;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

final class ModuleInfoManager {
    private static final ModuleInfoManager mim = new ModuleInfoManager();
    private HashMap<String, ModuleInfo> modules = null;
    private Lookup.Result<ModuleInfo> modulesResult = null;
    private HashMap<ModuleInfo, PCL> mapOfListeners;

    private ModuleInfoManager() {
    }

    public static final ModuleInfoManager getDefault() {
        return mim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleInfo getModule(String string) {
        Collection collection = null;
        if (this.modules == null) {
            collection = this.getModulesResult().allInstances();
        }
        ModuleInfoManager moduleInfoManager = this;
        synchronized (moduleInfoManager) {
            if (this.modules == null) {
                this.fillModules(collection);
            }
            return this.modules.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lookup.Result<ModuleInfo> getModulesResult() {
        ModuleInfoManager moduleInfoManager = this;
        synchronized (moduleInfoManager) {
            if (this.modulesResult == null) {
                Lookup lookup = ModuleInfoManager.getModuleLookup();
                this.modulesResult = lookup.lookup(new Lookup.Template(ModuleInfo.class));
                this.modulesResult.addLookupListener(new LookupListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void resultChanged(LookupEvent lookupEvent) {
                        List list;
                        Collection collection = ModuleInfoManager.this.getModulesResult().allInstances();
                        XMLSettingsSupport.err.fine("Modules changed: " + collection);
                        1 var4_3 = this;
                        synchronized (var4_3) {
                            ModuleInfoManager.this.fillModules(collection);
                            list = ModuleInfoManager.this.replaceReloadedModules();
                            XMLSettingsSupport.err.fine("Reloaded modules: " + list);
                        }
                        ModuleInfoManager.this.notifyReloads(list);
                    }
                });
            }
            return this.modulesResult;
        }
    }

    private static Lookup getModuleLookup() {
        Lookup lookup = Lookup.getDefault();
        if (lookup instanceof MainLookup) {
            lookup = Main.getModuleSystem().getManager().getModuleLookup();
        }
        return lookup;
    }

    private void notifyReloads(List list) {
        for (PCL pCL : list) {
            pCL.notifyReload();
        }
    }

    private void fillModules(Collection<? extends ModuleInfo> collection) {
        HashMap<String, ModuleInfo> hashMap = new HashMap<String, ModuleInfo>((collection.size() << 2) / 3 + 1);
        for (ModuleInfo moduleInfo : collection) {
            hashMap.put(moduleInfo.getCodeNameBase(), moduleInfo);
        }
        this.modules = hashMap;
    }

    private List<PCL> replaceReloadedModules() {
        if (this.mapOfListeners == null) {
            return Collections.emptyList();
        }
        Iterator<ModuleInfo> iterator = new ArrayList<ModuleInfo>(this.mapOfListeners.keySet()).iterator();
        ArrayList<PCL> arrayList = new ArrayList<PCL>();
        while (iterator.hasNext()) {
            ModuleInfo moduleInfo;
            ModuleInfo moduleInfo2 = iterator.next();
            if (moduleInfo2 == (moduleInfo = this.modules.get(moduleInfo2.getCodeNameBase())) || moduleInfo == null) continue;
            PCL pCL = this.mapOfListeners.remove(moduleInfo2);
            pCL.setModuleInfo(moduleInfo);
            arrayList.add(pCL);
            this.mapOfListeners.put(moduleInfo, pCL);
        }
        return arrayList;
    }

    public ModuleInfo getModuleInfo(Class clazz) {
        for (ModuleInfo moduleInfo : this.getModulesResult().allInstances()) {
            if (!moduleInfo.owns(clazz)) continue;
            return moduleInfo;
        }
        return null;
    }

    public synchronized void registerPropertyChangeListener(SerialDataConvertor serialDataConvertor, ModuleInfo moduleInfo) {
        PCL pCL;
        if (this.mapOfListeners == null) {
            this.mapOfListeners = new HashMap(this.modules.size());
        }
        if ((pCL = this.mapOfListeners.get(moduleInfo)) == null) {
            pCL = new PCL(moduleInfo);
            this.mapOfListeners.put(moduleInfo, pCL);
        }
        PropertyChangeListener propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)serialDataConvertor, (Object)pCL);
        pCL.addPropertyChangeListener(serialDataConvertor, propertyChangeListener);
    }

    public synchronized void unregisterPropertyChangeListener(SerialDataConvertor serialDataConvertor, ModuleInfo moduleInfo) {
        if (this.mapOfListeners == null) {
            return;
        }
        PCL pCL = this.mapOfListeners.get(moduleInfo);
        if (pCL != null) {
            pCL.removePropertyChangeListener(serialDataConvertor);
        }
    }

    public synchronized boolean isReloaded(ModuleInfo moduleInfo) {
        if (this.mapOfListeners == null) {
            return false;
        }
        PCL pCL = this.mapOfListeners.get(moduleInfo);
        return pCL != null && pCL.isReloaded();
    }

    public synchronized boolean isReloaded(String string) {
        if (this.mapOfListeners == null) {
            return false;
        }
        return this.isReloaded(this.getModule(string));
    }

    private static final class PCL
    implements PropertyChangeListener {
        private boolean aModuleHasBeenChanged = false;
        private boolean wasModuleEnabled;
        private ModuleInfo mi;
        private PropertyChangeSupport changeSupport;
        private Map<SerialDataConvertor, PropertyChangeListener> origs;

        public PCL(ModuleInfo moduleInfo) {
            this.mi = moduleInfo;
            this.wasModuleEnabled = moduleInfo.isEnabled();
            moduleInfo.addPropertyChangeListener((PropertyChangeListener)this);
        }

        void setModuleInfo(ModuleInfo moduleInfo) {
            this.mi.removePropertyChangeListener((PropertyChangeListener)this);
            this.aModuleHasBeenChanged = true;
            this.mi = moduleInfo;
            moduleInfo.addPropertyChangeListener((PropertyChangeListener)this);
        }

        void notifyReload() {
            this.firePropertyChange();
        }

        boolean isReloaded() {
            return this.aModuleHasBeenChanged;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                boolean bl;
                if (!Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                    this.aModuleHasBeenChanged = true;
                    bl = this.wasModuleEnabled;
                } else {
                    bl = !this.wasModuleEnabled;
                }
                this.wasModuleEnabled = this.mi.isEnabled();
                if (bl) {
                    this.firePropertyChange();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPropertyChangeListener(SerialDataConvertor serialDataConvertor, PropertyChangeListener propertyChangeListener) {
            PCL pCL = this;
            synchronized (pCL) {
                PropertyChangeListener propertyChangeListener2;
                if (this.changeSupport == null) {
                    this.changeSupport = new PropertyChangeSupport(this);
                    this.origs = new WeakHashMap<SerialDataConvertor, PropertyChangeListener>();
                }
                if ((propertyChangeListener2 = this.origs.get(serialDataConvertor)) != null) {
                    return;
                }
                this.origs.put(serialDataConvertor, propertyChangeListener);
            }
            this.changeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.changeSupport != null) {
                this.changeSupport.removePropertyChangeListener(propertyChangeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removePropertyChangeListener(SerialDataConvertor serialDataConvertor) {
            PCL pCL = this;
            synchronized (pCL) {
                if (this.origs == null) {
                    return;
                }
                PropertyChangeListener propertyChangeListener = this.origs.remove(serialDataConvertor);
                if (propertyChangeListener != null) {
                    this.removePropertyChangeListener(propertyChangeListener);
                }
            }
        }

        private void firePropertyChange() {
            if (this.changeSupport != null) {
                this.changeSupport.firePropertyChange("enabled", null, null);
            }
        }
    }
}

