/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.util;

import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.metal.MetalTheme;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLReaderAdapter;

public class NbTheme
extends MetalTheme
implements DocumentHandler {
    public static final String THEMEFILE_NAME = "themes.xml";
    private static final String THEMESET_TAG = "themeset";
    private static final String ACTIVE_ATTR = "active";
    private static final String THEME_TAG = "theme";
    private static final String BOOL_TAG = "boolean";
    private static final String DIM_TAG = "dimension";
    private static final String FONT_TAG = "font";
    private static final String INSETS_TAG = "insets";
    private static final String ETCHEDBORDER_TAG = "etchedborder";
    private static final String EMPTYBORDER_TAG = "emptyborder";
    private static final String BEVELBORDER_TAG = "bevelborder";
    private static final String LINEBORDER_TAG = "lineborder";
    private static final String COLOR_ATTR = "color";
    private static final String KEY_ATTR = "key";
    private static final String METRIC_TAG = "metric";
    private static final String STRING_TAG = "string";
    private static final String NAME_ATTR = "name";
    private static final String FONTSTYLE_ATTR = "style";
    private static final String FONTSIZE_ATTR = "size";
    private static final String VALUE_ATTR = "value";
    private static final String WIDTH_ATTR = "width";
    private static final String HEIGHT_ATTR = "height";
    private static final String RED_ATTR = "r";
    private static final String GREEN_ATTR = "g";
    private static final String BLUE_ATTR = "b";
    private static final String LEFT_ATTR = "left";
    private static final String TOP_ATTR = "top";
    private static final String RIGHT_ATTR = "right";
    private static final String BOTTOM_ATTR = "bottom";
    private static final String TYPE_ATTR = "type";
    private static final String REFERENCE_ATTR = "reference";
    private static final String FONTSTYLE_BOLD = "bold";
    private static final String FONTSTYLE_ITALIC = "italic";
    private static final String TYPE_LOWERED = "lowered";
    private static final String CONTROLFONT = "controlFont";
    private static final String SYSTEMFONT = "systemFont";
    private static final String USERFONT = "userFont";
    private static final String MENUFONT = "menuFont";
    private static final String WINDOWTITLEFONT = "windowTitleFont";
    private static final String SUBFONT = "subFont";
    private static final String PRIMARY1 = "primary1";
    private static final String PRIMARY2 = "primary2";
    private static final String PRIMARY3 = "primary3";
    private static final String SECONDARY1 = "secondary1";
    private static final String SECONDARY2 = "secondary2";
    private static final String SECONDARY3 = "secondary3";
    private static final String WHITE = "white";
    private static final String BLACK = "black";
    private HashSet<String> activeThemes = null;
    private boolean inActiveTheme = false;
    private URL themeURL = null;
    private UIDefaults defaults;
    Locator locator = null;

    @Override
    public String getName() {
        return "NetBeans XML Theme";
    }

    public NbTheme(URL uRL, LookAndFeel lookAndFeel) {
        this.themeURL = uRL;
        this.defaults = lookAndFeel.getDefaults();
        this.initThemeDefaults();
        this.parseTheme();
        UIManager.getDefaults().putAll(this.defaults);
    }

    void initThemeDefaults() {
        this.defaults.put(PRIMARY1, new ColorUIResource(102, 102, 153));
        this.defaults.put(PRIMARY2, new ColorUIResource(153, 153, 204));
        this.defaults.put(PRIMARY3, new ColorUIResource(204, 204, 255));
        this.defaults.put(SECONDARY1, new ColorUIResource(102, 102, 102));
        this.defaults.put(SECONDARY2, new ColorUIResource(153, 153, 153));
        this.defaults.put(SECONDARY3, new ColorUIResource(204, 204, 204));
        this.defaults.put(WHITE, new ColorUIResource(255, 255, 255));
        this.defaults.put(BLACK, new ColorUIResource(0, 0, 0));
    }

    private void parseTheme() {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            sAXParserFactory.setNamespaceAware(false);
            XMLReaderAdapter xMLReaderAdapter = new XMLReaderAdapter(sAXParserFactory.newSAXParser().getXMLReader());
            xMLReaderAdapter.setDocumentHandler(this);
            String string = this.themeURL.toExternalForm();
            InputSource inputSource = new InputSource(string);
            xMLReaderAdapter.parse(inputSource);
            this.activeThemes = null;
            this.locator = null;
        }
        catch (IOException iOException) {
            System.err.println("IO exception reading theme file");
        }
        catch (SAXException sAXException) {
            System.err.println("Error parsing theme file " + (this.locator != null ? "line " + this.locator.getLineNumber() : ""));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println("Couldn't create XML parser for theme file");
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (string.equals(THEMESET_TAG)) {
            String string2 = attributeList.getValue(ACTIVE_ATTR);
            if (string2 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                this.activeThemes = new HashSet(stringTokenizer.countTokens() + 1);
                while (stringTokenizer.hasMoreTokens()) {
                    this.activeThemes.add(stringTokenizer.nextToken().trim());
                }
            }
        } else if (string.equals(THEME_TAG) && this.activeThemes != null) {
            String string3 = attributeList.getValue(NAME_ATTR);
            this.inActiveTheme = this.activeThemes.contains(string3);
        } else if (this.inActiveTheme) {
            if (this.handleReference(attributeList)) {
                return;
            }
            if (string.equals(COLOR_ATTR)) {
                this.handleColor(attributeList);
                return;
            }
            if (string.equals(FONT_TAG)) {
                this.handleFont(attributeList);
                return;
            }
            if (string.equals(EMPTYBORDER_TAG)) {
                this.handleEmptyBorder(attributeList);
                return;
            }
            if (string.equals(METRIC_TAG)) {
                this.handleMetric(attributeList);
                return;
            }
            if (string.equals(STRING_TAG)) {
                this.handleString(attributeList);
                return;
            }
            if (string.equals(INSETS_TAG)) {
                this.handleInsets(attributeList);
                return;
            }
            if (string.equals(BOOL_TAG)) {
                this.handleBool(attributeList);
                return;
            }
            if (string.equals(DIM_TAG)) {
                this.handleDim(attributeList);
                return;
            }
            if (string.equals(ETCHEDBORDER_TAG)) {
                this.handleEtchedBorder(attributeList);
                return;
            }
            if (string.equals(LINEBORDER_TAG)) {
                this.handleLineBorder(attributeList);
                return;
            }
            if (string.equals(BEVELBORDER_TAG)) {
                this.handleBevelBorder(attributeList);
                return;
            }
            System.err.println("UNRECOGNIZED THEME ENTRY " + string + "\" " + attributeList.toString());
        }
    }

    private boolean handleReference(AttributeList attributeList) throws SAXException {
        Object object;
        String string = attributeList.getValue(KEY_ATTR);
        String string2 = attributeList.getValue(REFERENCE_ATTR);
        if (string2 != null && (object = this.defaults.get(string2)) != null) {
            this.defaults.put(string, object);
            return true;
        }
        return false;
    }

    private final void handleFont(AttributeList attributeList) throws SAXException {
        String string = attributeList.getValue(KEY_ATTR);
        String string2 = attributeList.getValue(NAME_ATTR);
        String string3 = attributeList.getValue(FONTSTYLE_ATTR);
        int n = this.intFromAttr(attributeList, FONTSIZE_ATTR);
        int n2 = 0;
        if (string3.equals(FONTSTYLE_BOLD)) {
            n2 = 1;
        } else if (string3.equals(FONTSTYLE_ITALIC)) {
            n2 = 2;
        }
        FontUIResource fontUIResource = new FontUIResource(string2, n2, n);
        this.defaults.put(string, fontUIResource);
    }

    private final void handleColor(AttributeList attributeList) throws SAXException {
        int n = this.intFromAttr(attributeList, RED_ATTR);
        int n2 = this.intFromAttr(attributeList, GREEN_ATTR);
        int n3 = this.intFromAttr(attributeList, BLUE_ATTR);
        String string = attributeList.getValue(KEY_ATTR);
        ColorUIResource colorUIResource = new ColorUIResource(n, n2, n3);
        this.defaults.put(string, colorUIResource);
    }

    private final void handleMetric(AttributeList attributeList) throws SAXException {
        String string = attributeList.getValue(KEY_ATTR);
        Integer n = Integer.valueOf(attributeList.getValue(VALUE_ATTR));
        this.defaults.put(string, n);
    }

    private final void handleString(AttributeList attributeList) throws SAXException {
        String string = attributeList.getValue(KEY_ATTR);
        String string2 = attributeList.getValue(VALUE_ATTR);
        this.defaults.put(string, string2);
    }

    private final void handleBool(AttributeList attributeList) throws SAXException {
        String string = attributeList.getValue(KEY_ATTR);
        Boolean bl = Boolean.valueOf(string);
        this.defaults.put(string, bl);
    }

    private final void handleDim(AttributeList attributeList) throws SAXException {
        String string = attributeList.getValue(KEY_ATTR);
        int n = this.intFromAttr(attributeList, WIDTH_ATTR);
        int n2 = this.intFromAttr(attributeList, HEIGHT_ATTR);
        DimensionUIResource dimensionUIResource = new DimensionUIResource(n, n2);
        this.defaults.put(string, dimensionUIResource);
    }

    private final void handleInsets(AttributeList attributeList) throws SAXException {
        String string = attributeList.getValue(KEY_ATTR);
        int n = this.intFromAttr(attributeList, TOP_ATTR);
        int n2 = this.intFromAttr(attributeList, LEFT_ATTR);
        int n3 = this.intFromAttr(attributeList, BOTTOM_ATTR);
        int n4 = this.intFromAttr(attributeList, RIGHT_ATTR);
        InsetsUIResource insetsUIResource = new InsetsUIResource(n, n2, n3, n4);
        this.defaults.put(string, insetsUIResource);
    }

    private final void handleEtchedBorder(AttributeList attributeList) {
        String string = attributeList.getValue(KEY_ATTR);
        int n = 1;
        String string2 = attributeList.getValue(TYPE_ATTR);
        if (string2 != null) {
            n = string2.equals(TYPE_LOWERED) ? 1 : 0;
        }
        BorderUIResource.EtchedBorderUIResource etchedBorderUIResource = new BorderUIResource.EtchedBorderUIResource(n);
        this.defaults.put(string, etchedBorderUIResource);
    }

    private final void handleBevelBorder(AttributeList attributeList) {
        String string = attributeList.getValue(KEY_ATTR);
        int n = 1;
        String string2 = attributeList.getValue(TYPE_ATTR);
        if (string2 != null) {
            n = string2.equals(TYPE_LOWERED) ? 1 : 0;
        }
        BorderUIResource.BevelBorderUIResource bevelBorderUIResource = new BorderUIResource.BevelBorderUIResource(n);
        this.defaults.put(string, bevelBorderUIResource);
    }

    private final void handleEmptyBorder(AttributeList attributeList) throws SAXException {
        String string = attributeList.getValue(KEY_ATTR);
        int n = this.intFromAttr(attributeList, TOP_ATTR);
        int n2 = this.intFromAttr(attributeList, LEFT_ATTR);
        int n3 = this.intFromAttr(attributeList, BOTTOM_ATTR);
        int n4 = this.intFromAttr(attributeList, RIGHT_ATTR);
        BorderUIResource.EmptyBorderUIResource emptyBorderUIResource = new BorderUIResource.EmptyBorderUIResource(n, n2, n3, n4);
        this.defaults.put(string, emptyBorderUIResource);
    }

    private final void handleLineBorder(AttributeList attributeList) throws SAXException {
        String string = attributeList.getValue(KEY_ATTR);
        int n = this.intFromAttr(attributeList, RED_ATTR);
        int n2 = this.intFromAttr(attributeList, GREEN_ATTR);
        int n3 = this.intFromAttr(attributeList, BLUE_ATTR);
        int n4 = 1;
        if (attributeList.getValue(WIDTH_ATTR) != null) {
            n4 = this.intFromAttr(attributeList, WIDTH_ATTR);
        }
        Color color = new Color(n, n2, n3);
        BorderUIResource.LineBorderUIResource lineBorderUIResource = new BorderUIResource.LineBorderUIResource(color);
        this.defaults.put(string, lineBorderUIResource);
    }

    private final int intFromAttr(AttributeList attributeList, String string) throws SAXException {
        try {
            return Integer.valueOf(attributeList.getValue(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException(attributeList.getValue(string) + " is not an integer");
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void endElement(String string) throws SAXException {
        if (string.equals(THEME_TAG)) {
            this.inActiveTheme = false;
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    private final ColorUIResource getColor(String string) {
        return (ColorUIResource)this.defaults.get(string);
    }

    private final FontUIResource getFont(String string) {
        return (FontUIResource)this.defaults.get(string);
    }

    @Override
    public FontUIResource getControlTextFont() {
        return this.getFont(CONTROLFONT);
    }

    @Override
    public FontUIResource getSystemTextFont() {
        return this.getFont(SYSTEMFONT);
    }

    @Override
    public FontUIResource getUserTextFont() {
        return this.getFont(USERFONT);
    }

    @Override
    public FontUIResource getMenuTextFont() {
        return this.getFont(MENUFONT);
    }

    @Override
    public FontUIResource getWindowTitleFont() {
        return this.getFont(WINDOWTITLEFONT);
    }

    @Override
    public FontUIResource getSubTextFont() {
        return this.getFont(SUBFONT);
    }

    @Override
    protected ColorUIResource getPrimary1() {
        return this.getColor(PRIMARY1);
    }

    @Override
    protected ColorUIResource getPrimary2() {
        return this.getColor(PRIMARY2);
    }

    @Override
    protected ColorUIResource getPrimary3() {
        return this.getColor(PRIMARY3);
    }

    @Override
    protected ColorUIResource getSecondary1() {
        return this.getColor(SECONDARY1);
    }

    @Override
    protected ColorUIResource getSecondary2() {
        return this.getColor(SECONDARY2);
    }

    @Override
    protected ColorUIResource getSecondary3() {
        return this.getColor(SECONDARY3);
    }

    @Override
    protected ColorUIResource getWhite() {
        return this.getColor(WHITE);
    }

    @Override
    protected ColorUIResource getBlack() {
        return this.getColor(BLACK);
    }
}

