/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.jmx;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.Storage;
import com.sun.tools.visualvm.core.explorer.ExplorerSupport;
import com.sun.tools.visualvm.core.properties.PropertiesPanel;
import com.sun.tools.visualvm.core.ui.components.Spacer;
import com.sun.tools.visualvm.host.Host;
import com.sun.tools.visualvm.jmx.CredentialsProvider;
import com.sun.tools.visualvm.jmx.EnvironmentProvider;
import com.sun.tools.visualvm.jmx.JmxConnectionCustomizer;
import com.sun.tools.visualvm.jmx.impl.JmxApplication;
import com.sun.tools.visualvm.jmx.impl.JmxApplicationProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import sun.net.util.IPAddressUtil;

public class DefaultCustomizer
extends JmxConnectionCustomizer {
    DefaultCustomizer() {
        super(NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Default_jmx_connection_name"), NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Default_jmx_connection_descr"), 1, false);
    }

    public boolean providesProperties(Application application) {
        if (!(application instanceof JmxApplication)) {
            return false;
        }
        EnvironmentProvider provider = ((JmxApplication)application).getEnvironmentProvider();
        return provider != null && provider instanceof CredentialsProvider;
    }

    public PropertiesPanel createPanel(Application application) {
        if (application == null) {
            return new CustomizerUI();
        }
        return new PropertiesUI(application);
    }

    public JmxConnectionCustomizer.Setup getConnectionSetup(PropertiesPanel customizerPanel) {
        if (!(customizerPanel instanceof CustomizerUI)) {
            throw new IllegalArgumentException("Panel must be DefaultCustomizer.CustomizerUI");
        }
        CustomizerUI panel = (CustomizerUI)customizerPanel;
        String connectionString = panel.getConnectionString();
        String displayName = panel.getDisplayName();
        CredentialsProvider.Custom provider = new CredentialsProvider.Custom(panel.getUsername(), panel.getPassword(), panel.getSaveCredentials());
        boolean persistent = true;
        return new JmxConnectionCustomizer.Setup(connectionString, displayName, provider, persistent);
    }

    protected static boolean isValidConnectionString(String jmxurl) {
        boolean valid = false;
        if (jmxurl != null) {
            if ((jmxurl = jmxurl.trim()).startsWith("service:jmx:")) {
                if (jmxurl.length() > "service:jmx:".length()) {
                    valid = true;
                }
            } else if (jmxurl.startsWith("[")) {
                String address;
                int index = jmxurl.indexOf("]:");
                if (index != -1 && IPAddressUtil.isIPv6LiteralAddress(address = jmxurl.substring(1, index))) {
                    try {
                        String portStr = jmxurl.substring(index + 2);
                        int port = Integer.parseInt(portStr);
                        if (port >= 0 && port <= 65535) {
                            valid = true;
                        }
                    }
                    catch (NumberFormatException ex) {
                        valid = false;
                    }
                }
            } else {
                String[] s = jmxurl.split(":");
                if (s.length == 2) {
                    try {
                        int port = Integer.parseInt(s[1]);
                        if (port >= 0 && port <= 65535) {
                            valid = true;
                        }
                    }
                    catch (NumberFormatException ex) {
                        valid = false;
                    }
                }
            }
        }
        return valid;
    }

    public static class PropertiesUI
    extends PropertiesPanel {
        private JLabel connectionLabel;
        private JTextField connectionField;
        private JCheckBox securityCheckbox;
        private JLabel usernameLabel;
        private JTextField usernameField;
        private JLabel passwordLabel;
        private JPasswordField passwordField;
        private JCheckBox saveCheckbox;

        public PropertiesUI(Application application) {
            this.initComponents();
            this.setValues(application);
        }

        private void setValues(Application application) {
            JmxApplication app = (JmxApplication)application;
            String connectionString = JmxApplicationProvider.getConnectionString(app);
            Storage storage = application.getStorage();
            CredentialsProvider provider = (CredentialsProvider)app.getEnvironmentProvider();
            String username = provider.getUsername(storage);
            boolean password = provider.hasPassword(storage);
            boolean persistent = provider.isPersistent(storage);
            this.connectionField.setText(connectionString);
            this.connectionField.setCaretPosition(0);
            this.securityCheckbox.setSelected(username != null || password);
            this.usernameField.setText(username);
            this.usernameField.setCaretPosition(0);
            this.passwordField.setText(password ? "----------" : "");
            this.passwordField.setCaretPosition(0);
            this.saveCheckbox.setSelected(persistent);
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            Color checkboxForeground = UIManager.getColor("CheckBox.foreground");
            Color checkboxText = new Color(checkboxForeground.getRGB());
            this.connectionLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.connectionLabel, (String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Connection"));
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(3, 0, 3, 0);
            this.add(this.connectionLabel, constraints);
            this.connectionField = new JTextField();
            this.connectionLabel.setLabelFor(this.connectionField);
            this.connectionField.setEditable(false);
            Dimension size = this.connectionField.getPreferredSize();
            size.width = 1;
            this.connectionField.setPreferredSize(size);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(3, 5, 3, 0);
            this.add(this.connectionField, constraints);
            this.securityCheckbox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.securityCheckbox, (String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Use_security_credentials"));
            this.securityCheckbox.setEnabled(false);
            this.securityCheckbox.setOpaque(false);
            this.securityCheckbox.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.securityCheckbox.setForeground(checkboxText);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 3;
            constraints.gridwidth = 0;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(15, 0, 3, 0);
            this.add(this.securityCheckbox, constraints);
            this.usernameLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.usernameLabel, (String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Username"));
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 4;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(3, 20, 3, 0);
            this.add(this.usernameLabel, constraints);
            this.usernameField = new JTextField();
            this.usernameLabel.setLabelFor(this.usernameField);
            this.usernameField.setEditable(false);
            size = this.usernameField.getPreferredSize();
            size.width = 1;
            this.usernameField.setPreferredSize(size);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 4;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(3, 5, 3, 0);
            this.add(this.usernameField, constraints);
            this.passwordLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Password"));
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 5;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(3, 20, 3, 0);
            this.add(this.passwordLabel, constraints);
            this.passwordField = new JPasswordField();
            this.passwordLabel.setLabelFor(this.passwordField);
            this.passwordField.setEditable(false);
            this.passwordField.setFocusable(false);
            size = this.passwordField.getPreferredSize();
            size.width = 1;
            this.passwordField.setPreferredSize(size);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 5;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(3, 5, 3, 0);
            this.add(this.passwordField, constraints);
            this.saveCheckbox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.saveCheckbox, (String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Save_security_credentials"));
            this.saveCheckbox.setEnabled(false);
            this.saveCheckbox.setOpaque(false);
            this.saveCheckbox.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 3));
            this.saveCheckbox.setForeground(checkboxText);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 6;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(3, 20, 3, 0);
            this.add(this.saveCheckbox, constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 7;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.gridwidth = 0;
            constraints.fill = 1;
            constraints.anchor = 18;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)Spacer.create(), constraints);
        }
    }

    public static class CustomizerUI
    extends PropertiesPanel {
        private boolean internalChange = false;
        private JLabel connectionLabel;
        private JTextField connectionField;
        private JLabel usageLabel;
        private JCheckBox displaynameCheckbox;
        private JTextField displaynameField;
        private JCheckBox securityCheckbox;
        private JLabel usernameLabel;
        private JTextField usernameField;
        private JLabel passwordLabel;
        private JPasswordField passwordField;
        private JCheckBox saveCheckbox;

        public CustomizerUI() {
            this.initComponents();
            this.initDefaults();
            this.update();
        }

        public final String getConnectionString() {
            return this.connectionField.getText().trim();
        }

        public final String getDisplayName() {
            return this.displaynameField.getText().trim();
        }

        public final String getUsername() {
            return !this.securityCheckbox.isSelected() ? null : this.usernameField.getText().trim();
        }

        public final char[] getPassword() {
            return !this.securityCheckbox.isSelected() ? null : this.passwordField.getPassword();
        }

        public final boolean getSaveCredentials() {
            return !this.securityCheckbox.isSelected() ? false : this.saveCheckbox.isSelected();
        }

        private void initDefaults() {
            Set selectedDataSources = ExplorerSupport.sharedInstance().getSelectedDataSources();
            if (selectedDataSources.size() != 1) {
                return;
            }
            DataSource selectedDataSource = (DataSource)selectedDataSources.iterator().next();
            if (!(selectedDataSource instanceof Host)) {
                return;
            }
            Host host = (Host)selectedDataSource;
            this.connectionField.setText(host.getHostName() + ":");
        }

        private void update() {
            if (this.internalChange) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String username = CustomizerUI.this.getUsername();
                    String url = CustomizerUI.this.getConnectionString();
                    if (!CustomizerUI.this.displaynameCheckbox.isSelected()) {
                        CustomizerUI.this.internalChange = true;
                        CustomizerUI.this.displaynameField.setText((username == null || username.isEmpty() ? "" : username + "@") + url);
                        CustomizerUI.this.internalChange = false;
                    }
                    String displayname = CustomizerUI.this.getDisplayName();
                    CustomizerUI.this.displaynameField.setEnabled(CustomizerUI.this.displaynameCheckbox.isSelected());
                    CustomizerUI.this.usernameField.setEnabled(CustomizerUI.this.securityCheckbox.isSelected());
                    CustomizerUI.this.passwordField.setEnabled(CustomizerUI.this.securityCheckbox.isSelected());
                    CustomizerUI.this.saveCheckbox.setEnabled(CustomizerUI.this.securityCheckbox.isSelected());
                    CustomizerUI.this.setSettingsValid(DefaultCustomizer.isValidConnectionString(url) && displayname.length() > 0);
                }
            });
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            this.connectionLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.connectionLabel, (String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Connection"));
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.anchor = 13;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add(this.connectionLabel, constraints);
            this.connectionField = new JTextField();
            this.connectionLabel.setLabelFor(this.connectionField);
            this.connectionField.setPreferredSize(new Dimension(250, this.connectionField.getPreferredSize().height));
            this.connectionField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent e) {
                    CustomizerUI.this.update();
                }

                public void removeUpdate(DocumentEvent e) {
                    CustomizerUI.this.update();
                }

                public void changedUpdate(DocumentEvent e) {
                    CustomizerUI.this.update();
                }
            });
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(0, 5, 0, 0);
            this.add(this.connectionField, constraints);
            Font normalLabelFont = this.connectionLabel.getFont();
            Font smallLabelFont = normalLabelFont.deriveFont(normalLabelFont.getSize2D() - 1.0f);
            this.usageLabel = new JLabel(NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Usage"));
            this.usageLabel.setFont(smallLabelFont);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.gridwidth = 0;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(0, 5, 0, 0);
            this.add(this.usageLabel, constraints);
            this.displaynameCheckbox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.displaynameCheckbox, (String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Display_name"));
            this.displaynameCheckbox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CustomizerUI.this.update();
                }
            });
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.anchor = 13;
            constraints.insets = new Insets(8, 4, 0, 0);
            this.add(this.displaynameCheckbox, constraints);
            this.displaynameField = new JTextField();
            this.displaynameField.setPreferredSize(new Dimension(250, this.displaynameField.getPreferredSize().height));
            this.displaynameField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent e) {
                    CustomizerUI.this.update();
                }

                public void removeUpdate(DocumentEvent e) {
                    CustomizerUI.this.update();
                }

                public void changedUpdate(DocumentEvent e) {
                    CustomizerUI.this.update();
                }
            });
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 2;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(8, 5, 0, 0);
            this.add(this.displaynameField, constraints);
            this.securityCheckbox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.securityCheckbox, (String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Use_security_credentials"));
            this.securityCheckbox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CustomizerUI.this.update();
                }
            });
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 3;
            constraints.gridwidth = 0;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(15, 0, 0, 0);
            this.add(this.securityCheckbox, constraints);
            this.usernameLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.usernameLabel, (String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Username"));
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 4;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.anchor = 13;
            constraints.insets = new Insets(5, 0, 0, 0);
            this.add(this.usernameLabel, constraints);
            this.usernameField = new JTextField();
            this.usernameLabel.setLabelFor(this.usernameField);
            this.usernameField.setPreferredSize(new Dimension(320, this.usernameField.getPreferredSize().height));
            this.usernameField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent e) {
                    CustomizerUI.this.update();
                }

                public void removeUpdate(DocumentEvent e) {
                    CustomizerUI.this.update();
                }

                public void changedUpdate(DocumentEvent e) {
                    CustomizerUI.this.update();
                }
            });
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 4;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(5, 5, 0, 0);
            this.add(this.usernameField, constraints);
            this.passwordLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Password"));
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 5;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.anchor = 13;
            constraints.insets = new Insets(8, 0, 0, 0);
            this.add(this.passwordLabel, constraints);
            this.passwordField = new JPasswordField();
            this.passwordLabel.setLabelFor(this.passwordField);
            this.passwordField.setPreferredSize(new Dimension(200, this.passwordField.getPreferredSize().height));
            this.passwordField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent e) {
                    CustomizerUI.this.update();
                }

                public void removeUpdate(DocumentEvent e) {
                    CustomizerUI.this.update();
                }

                public void changedUpdate(DocumentEvent e) {
                    CustomizerUI.this.update();
                }
            });
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 5;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(8, 5, 0, 0);
            this.add(this.passwordField, constraints);
            this.saveCheckbox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.saveCheckbox, (String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Save_security_credentials"));
            this.saveCheckbox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CustomizerUI.this.update();
                }
            });
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 6;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.anchor = 13;
            constraints.insets = new Insets(8, 30, 0, 0);
            this.add(this.saveCheckbox, constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 7;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.gridwidth = 0;
            constraints.fill = 1;
            constraints.anchor = 18;
            constraints.insets = new Insets(10, 0, 0, 0);
            this.add((Component)Spacer.create(), constraints);
            this.displaynameCheckbox.setBorder(this.connectionLabel.getBorder());
        }
    }
}

