/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Window;
import java.util.Arrays;
import javax.swing.FocusManager;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ModeContainer;
import org.netbeans.core.windows.view.ModeView;
import org.netbeans.core.windows.view.dnd.TopComponentDroppable;
import org.netbeans.core.windows.view.dnd.WindowDnDManager;
import org.netbeans.core.windows.view.ui.Tabbed;
import org.netbeans.core.windows.view.ui.TabbedHandler;
import org.openide.windows.TopComponent;

public abstract class AbstractModeContainer
implements ModeContainer {
    protected final ModeView modeView;
    protected final TabbedHandler tabbedHandler;
    protected final WindowDnDManager windowDnDManager;
    private final int kind;

    public AbstractModeContainer(ModeView modeView, WindowDnDManager windowDnDManager, int n) {
        this.modeView = modeView;
        this.windowDnDManager = windowDnDManager;
        this.kind = n;
        this.tabbedHandler = new TabbedHandler(modeView, n, this.createTabbed());
    }

    @Override
    public ModeView getModeView() {
        return this.modeView;
    }

    @Override
    public Component getComponent() {
        return this.getModeComponent();
    }

    protected abstract Component getModeComponent();

    protected abstract Tabbed createTabbed();

    @Override
    public void addTopComponent(TopComponent topComponent) {
        this.tabbedHandler.addTopComponent(topComponent, this.kind);
    }

    @Override
    public void removeTopComponent(TopComponent topComponent) {
        this.tabbedHandler.removeTopComponent(topComponent);
        TopComponent topComponent2 = this.tabbedHandler.getSelectedTopComponent();
        this.updateTitle(topComponent2 == null ? "" : WindowManagerImpl.getInstance().getTopComponentDisplayName(topComponent2));
    }

    @Override
    public void setSelectedTopComponent(TopComponent topComponent) {
        this.tabbedHandler.setSelectedTopComponent(topComponent);
        this.updateTitle(WindowManagerImpl.getInstance().getTopComponentDisplayName(topComponent));
    }

    @Override
    public void setTopComponents(TopComponent[] topComponentArray, TopComponent topComponent) {
        if (!Arrays.equals(topComponentArray, this.getTopComponents())) {
            this.tabbedHandler.setTopComponents(topComponentArray, topComponent);
            this.updateTitle(WindowManagerImpl.getInstance().getTopComponentDisplayName(topComponent));
        } else {
            this.setSelectedTopComponent(topComponent);
        }
    }

    protected abstract void updateTitle(String var1);

    protected abstract void updateActive(boolean var1);

    @Override
    public TopComponent getSelectedTopComponent() {
        return this.tabbedHandler.getSelectedTopComponent();
    }

    @Override
    public void setActive(boolean bl) {
        this.updateActive(bl);
        TopComponent topComponent = this.tabbedHandler.getSelectedTopComponent();
        this.updateTitle(topComponent == null ? "" : WindowManagerImpl.getInstance().getTopComponentDisplayName(topComponent));
        this.tabbedHandler.setActive(bl);
    }

    @Override
    public void focusSelectedTopComponent() {
        TopComponent topComponent = this.tabbedHandler.getSelectedTopComponent();
        if (topComponent == null) {
            return;
        }
        Window window = FocusManager.getCurrentManager().getFocusedWindow();
        Window window2 = SwingUtilities.getWindowAncestor((Component)topComponent);
        if (window2 != null) {
            if (window2.equals(window)) {
                topComponent.requestFocusInWindow();
            } else {
                window2.toFront();
                topComponent.requestFocus();
            }
        }
    }

    @Override
    public TopComponent[] getTopComponents() {
        return this.tabbedHandler.getTopComponents();
    }

    @Override
    public void updateName(TopComponent topComponent) {
        TopComponent topComponent2 = this.getSelectedTopComponent();
        if (topComponent == topComponent2) {
            this.updateTitle(topComponent == null ? "" : WindowManagerImpl.getInstance().getTopComponentDisplayName(topComponent));
        }
        this.tabbedHandler.topComponentNameChanged(topComponent, this.kind);
    }

    @Override
    public void updateToolTip(TopComponent topComponent) {
        this.tabbedHandler.topComponentToolTipChanged(topComponent);
    }

    @Override
    public void updateIcon(TopComponent topComponent) {
        this.tabbedHandler.topComponentIconChanged(topComponent);
    }

    protected int getKind() {
        return this.kind;
    }

    protected Shape getIndicationForLocation(Point point) {
        return this.tabbedHandler.getIndicationForLocation(point, this.windowDnDManager.getStartingTransfer(), this.windowDnDManager.getStartingPoint(), this.isAttachingPossible());
    }

    protected Object getConstraintForLocation(Point point) {
        return this.tabbedHandler.getConstraintForLocation(point, this.isAttachingPossible());
    }

    protected abstract boolean isAttachingPossible();

    protected ModeView getDropModeView() {
        return this.modeView;
    }

    protected Component getDropComponent() {
        return this.tabbedHandler.getComponent();
    }

    protected abstract TopComponentDroppable getModeDroppable();

    protected boolean canDrop(TopComponent topComponent) {
        if (Constants.SWITCH_MODE_ADD_NO_RESTRICT || WindowManagerImpl.getInstance().isTopComponentAllowedToMoveAnywhere(topComponent)) {
            return true;
        }
        ModeImpl modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent);
        int n = modeImpl != null ? modeImpl.getKind() : 1;
        boolean bl = n == 0 || n == 2;
        boolean bl2 = this.kind == 0 || this.kind == 2;
        return bl == bl2;
    }
}

