/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.FolderChildrenPair;
import org.openide.loaders.FolderList;
import org.openide.loaders.FolderOrder;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Task;
import org.openide.util.WeakListeners;

final class FolderChildren
extends Children.Keys<FolderChildrenPair>
implements PropertyChangeListener,
ChangeListener,
FileChangeListener {
    private FolderList folder;
    private final DataFilter filter;
    private PropertyChangeListener listener;
    private FileChangeListener fcListener;
    private ChangeListener changeListener;
    private final Logger err;
    private volatile Task refTask = Task.EMPTY;

    public FolderChildren(DataFolder dataFolder) {
        this(dataFolder, DataFilter.ALL);
    }

    public FolderChildren(DataFolder dataFolder, DataFilter dataFilter) {
        super(true);
        String string = dataFolder.getPrimaryFile().isRoot() ? "org.openide.loaders.FolderChildren" : "org.openide.loaders.FolderChildren." + dataFolder.getPrimaryFile().getPath().replace('/', '.');
        this.err = Logger.getLogger(string);
        this.folder = FolderList.find(dataFolder.getPrimaryFile(), true);
        this.filter = dataFilter;
        this.listener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.folder);
        this.fcListener = FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)this.folder.getPrimaryFile());
    }

    DataFilter getFilter() {
        return this.filter;
    }

    static void waitRefresh() {
        DataNode.RP.post((Runnable)Task.EMPTY, 0, 1).waitFinished();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.err.log(Level.FINE, "Got a change {0}", propertyChangeEvent.getPropertyName());
        this.refreshChildren(RefreshMode.SHALLOW);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.refreshChildren(RefreshMode.DEEP);
    }

    private void refreshChildren(RefreshMode refreshMode) {
        class R
        implements Runnable {
            RefreshMode op;

            R() {
            }

            @Override
            public void run() {
                if (this.op == RefreshMode.DEEP) {
                    this.op = RefreshMode.DEEP_LATER;
                    Children.MUTEX.postWriteRequest((Runnable)this);
                    return;
                }
                FolderChildren.this.err.log(Level.FINE, "refreshChildren {0}", (Object)this.op);
                try {
                    if (this.op == RefreshMode.CLEAR) {
                        FolderChildren.this.setKeys(Collections.emptyList());
                        return;
                    }
                    FileObject[] fileObjectArray = FolderChildren.this.folder.getPrimaryFile().getChildren();
                    FolderOrder folderOrder = FolderOrder.findFor(FolderChildren.this.folder.getPrimaryFile());
                    Arrays.sort(fileObjectArray, folderOrder);
                    ArrayList<FolderChildrenPair> arrayList = new ArrayList<FolderChildrenPair>(fileObjectArray.length);
                    for (FileObject fileObject : FileUtil.getOrder(Arrays.asList(fileObjectArray), (boolean)false)) {
                        DataFilter.FileBased fileBased;
                        if (FolderChildren.this.filter instanceof DataFilter.FileBased && !(fileBased = (DataFilter.FileBased)FolderChildren.this.filter).acceptFileObject(fileObject)) continue;
                        arrayList.add(new FolderChildrenPair(fileObject));
                    }
                    if (this.op == RefreshMode.DEEP_LATER) {
                        FolderChildren.this.setKeys(Collections.emptyList());
                        FolderChildren.this.setKeys(arrayList);
                        return;
                    }
                    if (this.op == RefreshMode.SHALLOW) {
                        FolderChildren.this.setKeys(arrayList);
                        return;
                    }
                    throw new IllegalStateException("Unknown op: " + (Object)((Object)this.op));
                }
                finally {
                    FolderChildren.this.err.log(Level.FINE, "refreshChildren {0}, done", (Object)this.op);
                }
            }
        }
        R r = new R();
        if (refreshMode == RefreshMode.SHALLOW_IMMEDIATE) {
            this.refTask.waitFinished();
            r.op = RefreshMode.SHALLOW;
            r.run();
        } else {
            r.op = refreshMode;
            this.refTask = DataNode.RP.post((Runnable)r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected Node[] createNodes(FolderChildrenPair var1_1) {
        block9: {
            var3_2 = System.currentTimeMillis();
            var5_3 = null;
            try {
                var6_4 = var1_1.primaryFile;
                var2_8 = DataObject.find(var6_4);
                if (!var2_8.isValid() || !var6_4.equals(var2_8.getPrimaryFile()) || this.filter != null && !this.filter.acceptDataObject(var2_8)) break block9;
                var5_3 = var2_8.getClonedNodeDelegate(this.filter);
                if (var2_8.isValid()) break block9;
                var5_3 = null;
            }
            catch (DataObjectNotFoundException var6_6) {
                try {
                    Logger.getLogger(FolderChildren.class.getName()).log(Level.FINE, null, var6_6);
                }
                catch (Throwable var8_9) {
                    var9_10 = System.currentTimeMillis() - var3_2;
                    if (this.err.isLoggable(Level.FINE)) {
                        this.err.log(Level.FINE, "createNodes: {0} took: {1} ms", new Object[]{var1_1, var9_10});
                        this.err.log(Level.FINE, "  returning: {0}", var5_3);
                    }
                    throw var8_9;
                }
                var6_7 = System.currentTimeMillis() - var3_2;
                if (this.err.isLoggable(Level.FINE)) {
                    this.err.log(Level.FINE, "createNodes: {0} took: {1} ms", new Object[]{var1_1, var6_7});
                    this.err.log(Level.FINE, "  returning: {0}", var5_3);
                } else {
                    ** GOTO lbl30
                }
            }
        }
        var6_5 = System.currentTimeMillis() - var3_2;
        if (this.err.isLoggable(Level.FINE)) {
            this.err.log(Level.FINE, "createNodes: {0} took: {1} ms", new Object[]{var1_1, var6_5});
            this.err.log(Level.FINE, "  returning: {0}", var5_3);
        }
        if (var5_3 == null) {
            v0 = null;
        } else {
            v1 = new Node[1];
            v0 = v1;
            v1[0] = var5_3;
        }
        return v0;
    }

    public Node[] getNodes(boolean bl) {
        if (bl) {
            this.waitOptimalResult();
        }
        return this.getNodes();
    }

    public Node findChild(String string) {
        if (FolderChildren.checkChildrenMutex()) {
            this.getNodesCount(true);
        }
        return super.findChild(string);
    }

    private void waitOptimalResult() {
        if (FolderChildren.checkChildrenMutex()) {
            this.err.fine("waitOptimalResult");
            this.folder.waitProcessingFinished();
            this.refTask.waitFinished();
            this.err.fine("waitOptimalResult: waitProcessingFinished");
        } else {
            Logger.getLogger(FolderChildren.class.getName()).log(Level.WARNING, null, new IllegalStateException("getNodes(true) called while holding the Children.MUTEX"));
        }
    }

    public int getNodesCount(boolean bl) {
        if (bl) {
            this.waitOptimalResult();
        }
        return this.getNodesCount();
    }

    static boolean checkChildrenMutex() {
        return !Children.MUTEX.isReadAccess() && !Children.MUTEX.isWriteAccess();
    }

    protected void addNotify() {
        this.err.fine("addNotify begin");
        this.folder.addPropertyChangeListener(this.listener);
        this.folder.getPrimaryFile().addFileChangeListener(this.fcListener);
        if (this.filter instanceof ChangeableDataFilter) {
            ChangeableDataFilter changeableDataFilter = (ChangeableDataFilter)this.filter;
            this.changeListener = WeakListeners.change((ChangeListener)this, (Object)changeableDataFilter);
            changeableDataFilter.addChangeListener(this.changeListener);
        }
        if (Boolean.TRUE.equals(this.folder.getPrimaryFile().getAttribute("isRemoteAndSlow"))) {
            this.refreshChildren(RefreshMode.SHALLOW);
        } else {
            this.refreshChildren(RefreshMode.SHALLOW_IMMEDIATE);
        }
        this.err.fine("addNotify end");
    }

    protected void removeNotify() {
        this.err.fine("removeNotify begin");
        this.folder.getPrimaryFile().removeFileChangeListener(this.fcListener);
        this.folder.removePropertyChangeListener(this.listener);
        if (this.filter instanceof ChangeableDataFilter) {
            ((ChangeableDataFilter)this.filter).removeChangeListener(this.changeListener);
            this.changeListener = null;
        }
        List list = Collections.emptyList();
        this.setKeys(list);
        this.err.fine("removeNotify end");
    }

    public String toString() {
        return this.folder != null ? this.folder.getPrimaryFile().toString() : super.toString();
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        if ("NetBeansAttrAssignedLoader".equals(fileAttributeEvent.getName())) {
            DataObjectPool.checkAttributeChanged(fileAttributeEvent);
            this.refreshKey(new FolderChildrenPair(fileAttributeEvent.getFile()));
            this.refreshChildren(RefreshMode.SHALLOW_IMMEDIATE);
        }
    }

    public void fileChanged(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
        this.refreshChildren(RefreshMode.SHALLOW);
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.refreshChildren(RefreshMode.SHALLOW);
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        this.refreshChildren(RefreshMode.SHALLOW);
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.refreshChildren(RefreshMode.SHALLOW);
    }

    private static enum RefreshMode {
        SHALLOW,
        SHALLOW_IMMEDIATE,
        DEEP,
        DEEP_LATER,
        CLEAR;

    }
}

