/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ui.HyperlinkLabel;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AttachSettingsPanel
extends JPanel {
    private static final String PROJECT_PENDING_STRING = NbBundle.getMessage(AttachSettingsPanel.class, (String)"AttachSettingsPanel_ProjectPendingString");
    private static final String DEFINE_SETTINGS_STRING = NbBundle.getMessage(AttachSettingsPanel.class, (String)"AttachSettingsPanel_DefineSettingsString");
    private static final String DIRECT_ATTACH_STRING = NbBundle.getMessage(AttachSettingsPanel.class, (String)"AttachSettingsPanel_DirectAttachString");
    private static final String DYNAMIC_ATTACH_STRING = NbBundle.getMessage(AttachSettingsPanel.class, (String)"AttachSettingsPanel_DynamicAttachString");
    private static final String REMOTE_ATTACH_HINT_TEXT = NbBundle.getMessage(AttachSettingsPanel.class, (String)"AttachSettingsPanel_RemoteAttachHintText");
    private static final String LOCAL_ATTACH_HINT_TEXT = NbBundle.getMessage(AttachSettingsPanel.class, (String)"AttachSettingsPanel_LocalAttachHintText");
    private static final String ATTACH_MODE_LABEL_TEXT = NbBundle.getMessage(AttachSettingsPanel.class, (String)"AttachSettingsPanel_AttachModeLabelText");
    private static final int PREFERRED_HINT_HEIGHT = new HyperlinkLabel((String)"ABC<a href='#'>ABC</a>", (String)"ABC<a href='#'>ABC</a>", null).getPreferredSize().height;
    private AttachSettings settings;
    private HyperlinkLabel attachModeHintLabel;
    private JLabel attachModeLabel;
    private boolean settingsValid;

    public AttachSettingsPanel() {
        this.initComponents();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.attachModeLabel.setEnabled(bl);
        this.attachModeHintLabel.setEnabled(bl);
    }

    public void setSettings(boolean bl) {
        this.settingsValid = bl;
        this.settings = Utils.getAttachSettings();
        this.updateSettingsHint();
    }

    public AttachSettings getSettings() {
        return this.settingsValid ? this.settings : null;
    }

    public void resetSettings() {
        this.setSettings(false);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.attachModeLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.attachModeLabel, (String)ATTACH_MODE_LABEL_TEXT);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 15, 6, 4);
        this.add((Component)this.attachModeLabel, gridBagConstraints);
        this.attachModeHintLabel = new HyperlinkLabel("ABC<a href='#'>ABC</a>", "ABC<a href='#'>ABC</a>", new Runnable(){

            @Override
            public void run() {
                final AttachSettings attachSettings = Utils.selectAttachSettings();
                if (attachSettings != null) {
                    AttachSettingsPanel.this.settings = attachSettings;
                    AttachSettingsPanel.this.updateSettingsHint();
                    IDEUtils.runInProfilerRequestProcessor(new Runnable(){

                        @Override
                        public void run() {
                            NetBeansProfiler.saveAttachSettings(attachSettings);
                        }
                    });
                }
            }
        }){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, PREFERRED_HINT_HEIGHT);
            }
        };
        this.attachModeLabel.setLabelFor((Component)((Object)this.attachModeHintLabel));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 5);
        this.add((Component)((Object)this.attachModeHintLabel), gridBagConstraints);
    }

    private void updateSettingsHint() {
        Color color = Color.RED;
        String string = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        String string2 = "";
        String string3 = "";
        if (!this.settingsValid) {
            this.attachModeHintLabel.setFocusable(false);
            string3 = string2 = "<nobr>" + PROJECT_PENDING_STRING + "</nobr>";
        } else if (this.settings == null) {
            this.attachModeHintLabel.setFocusable(true);
            string2 = "<nobr>" + MessageFormat.format(DEFINE_SETTINGS_STRING, "") + "</nobr>";
            string3 = "<nobr>" + MessageFormat.format(DEFINE_SETTINGS_STRING, "color=\"" + string + "\"") + "</nobr>";
        } else {
            this.attachModeHintLabel.setFocusable(true);
            String string4 = this.settings.isDirect() ? DIRECT_ATTACH_STRING : DYNAMIC_ATTACH_STRING;
            String string5 = this.settings.getTargetType();
            String string6 = this.settings.getServerType();
            String string7 = "".equals(string6) ? string5 : string6;
            String string8 = this.settings.getHost();
            if (this.settings.isRemote()) {
                string2 = "<nobr>" + MessageFormat.format(REMOTE_ATTACH_HINT_TEXT, string4, string7, string8, "") + "</nobr>";
                string3 = "<nobr>" + MessageFormat.format(REMOTE_ATTACH_HINT_TEXT, string4, string7, string8, "color=\"" + string + "\"") + "</nobr>";
                this.attachModeHintLabel.setText("<nobr>" + MessageFormat.format(REMOTE_ATTACH_HINT_TEXT, string4, string7, string8) + "</nobr>");
            } else {
                string2 = "<nobr>" + MessageFormat.format(LOCAL_ATTACH_HINT_TEXT, string4, string7, "") + "</nobr>";
                string3 = "<nobr>" + MessageFormat.format(LOCAL_ATTACH_HINT_TEXT, string4, string7, "color=\"" + string + "\"") + "</nobr>";
            }
        }
        this.attachModeHintLabel.setText(string2, string3);
    }
}

