/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import sun.jvm.hotspot.debugger.Debugger;
import sun.jvm.hotspot.debugger.ProcessInfo;

public class ProcessListPanel
extends JPanel {
    private Debugger dbg;
    private AbstractTableModel dataModel;
    private List els;
    private boolean sortByName = true;
    private boolean sortReversed = false;
    private Timer timer;
    private JTable table;

    public ProcessListPanel(Debugger dbg) {
        this.dbg = dbg;
        this.update();
        this.dataModel = new AbstractTableModel(){

            public int getColumnCount() {
                return 2;
            }

            public int getRowCount() {
                return ProcessListPanel.this.els.size();
            }

            public String getColumnName(int col) {
                switch (col) {
                    case 0: {
                        return "Process Name";
                    }
                    case 1: {
                        return "Process ID";
                    }
                }
                throw new RuntimeException("Index " + col + " out of bounds");
            }

            public Object getValueAt(int row, int col) {
                ProcessInfo info = (ProcessInfo)ProcessListPanel.this.els.get(row);
                switch (col) {
                    case 0: {
                        return info.getName();
                    }
                    case 1: {
                        return new Integer(info.getPid());
                    }
                }
                throw new RuntimeException("Index (" + col + ", " + row + ") out of bounds");
            }
        };
        this.setLayout(new BorderLayout());
        this.table = new JTable(this.dataModel);
        this.table.setSelectionMode(0);
        JTableHeader header = this.table.getTableHeader();
        header.setReorderingAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        header.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int viewColumn = ProcessListPanel.this.table.getColumnModel().getColumnIndexAtX(e.getX());
                int column = ProcessListPanel.this.table.convertColumnIndexToModel(viewColumn);
                if (column != -1) {
                    boolean newSortByName;
                    boolean bl = newSortByName = column == 0;
                    if (newSortByName == ProcessListPanel.this.sortByName) {
                        ProcessListPanel.this.sortReversed = !ProcessListPanel.this.sortReversed;
                    } else {
                        ProcessListPanel.this.sortByName = newSortByName;
                        ProcessListPanel.this.sortReversed = false;
                    }
                    int i = ProcessListPanel.this.table.getSelectedRow();
                    int pid = ProcessListPanel.this.getPid(ProcessListPanel.this.els, i);
                    ProcessListPanel.this.sort(ProcessListPanel.this.els);
                    i = ProcessListPanel.this.findPid(ProcessListPanel.this.els, pid);
                    ProcessListPanel.this.dataModel.fireTableDataChanged();
                    if (i >= 0 || ProcessListPanel.this.els.size() > 0) {
                        if (i >= 0) {
                            ProcessListPanel.this.table.setRowSelectionInterval(i, i);
                        } else {
                            ProcessListPanel.this.table.setRowSelectionInterval(0, 0);
                        }
                    }
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add((Component)scrollPane, "Center");
        if (this.els.size() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    public void setAutoUpdateInterval(int millis) {
        this.getTimer().setDelay(millis);
    }

    public void start() {
        this.getTimer().start();
    }

    public void stop() {
        this.getTimer().stop();
    }

    public synchronized void update() {
        if (!this.dbg.hasProcessList()) {
            throw new RuntimeException("ProcessListPanel requires that debugger supports getProcessList()");
        }
        List newEls = this.dbg.getProcessList();
        this.sort(newEls);
        if (this.table != null) {
            int i = this.table.getSelectedRow();
            int pid = this.getPid(this.els, i);
            i = this.findPid(newEls, pid);
            this.els = newEls;
            this.dataModel.fireTableDataChanged();
            if (i >= 0 || this.els.size() > 0) {
                if (i >= 0) {
                    this.table.setRowSelectionInterval(i, i);
                } else {
                    this.table.setRowSelectionInterval(0, 0);
                }
            }
        } else {
            this.els = newEls;
        }
    }

    public synchronized ProcessInfo getSelectedProcess() {
        int i = this.table.getSelectedRow();
        if (i < 0) {
            return null;
        }
        return (ProcessInfo)this.els.get(i);
    }

    private synchronized void sort(List els) {
        Comparator c = this.sortByName ? new Comparator(){

            public int compare(Object o1, Object o2) {
                int scale = ProcessListPanel.this.sortReversed ? -1 : 1;
                return scale * ((ProcessInfo)o1).getName().compareToIgnoreCase(((ProcessInfo)o2).getName());
            }
        } : new Comparator(){

            public int compare(Object o1, Object o2) {
                int pid2;
                int scale = ProcessListPanel.this.sortReversed ? -1 : 1;
                int pid1 = ((ProcessInfo)o1).getPid();
                int ret = pid1 < (pid2 = ((ProcessInfo)o2).getPid()) ? -1 : (pid1 == pid2 ? 0 : 1);
                return ret * scale;
            }
        };
        Collections.sort(els, c);
    }

    private Timer getTimer() {
        if (this.timer == null) {
            this.timer = new Timer(1000, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProcessListPanel.this.update();
                }
            });
        }
        return this.timer;
    }

    private synchronized int getPid(List els, int index) {
        return ((ProcessInfo)els.get(index)).getPid();
    }

    private synchronized int findPid(List els, int pid) {
        for (int i = 0; i < els.size(); ++i) {
            ProcessInfo info = (ProcessInfo)els.get(i);
            if (info.getPid() != pid) continue;
            return i;
        }
        return -1;
    }
}

