/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.x86;

import sun.jvm.hotspot.asm.Address;
import sun.jvm.hotspot.asm.Immediate;
import sun.jvm.hotspot.asm.Instruction;
import sun.jvm.hotspot.asm.Operand;
import sun.jvm.hotspot.asm.Register;
import sun.jvm.hotspot.asm.SymbolFinder;
import sun.jvm.hotspot.asm.x86.X86Opcodes;

public abstract class X86Instruction
implements Instruction,
X86Opcodes {
    private final String name;
    private final int size;
    private final int prefixes;
    protected static String comma = ", ";
    protected static String spaces = "\t";

    public X86Instruction(String name, int size, int prefixes) {
        this.name = name;
        this.size = size;
        this.prefixes = prefixes;
    }

    public abstract String asString(long var1, SymbolFinder var3);

    public String getName() {
        return this.name;
    }

    public String getPrefixString() {
        StringBuffer buf = new StringBuffer();
        if ((this.prefixes & 1) != 0) {
            buf.append("repz ");
        }
        if ((this.prefixes & 2) != 0) {
            buf.append("repnz ");
        }
        if ((this.prefixes & 4) != 0) {
            buf.append("lock ");
        }
        return buf.toString();
    }

    protected String getOperandAsString(Operand op) {
        StringBuffer buf = new StringBuffer();
        if (op instanceof Register || op instanceof Address) {
            buf.append(op.toString());
        } else {
            Number number = ((Immediate)op).getNumber();
            buf.append("0x");
            buf.append(Integer.toHexString(number.intValue()));
        }
        return buf.toString();
    }

    public int getSize() {
        return this.size;
    }

    public boolean isArithmetic() {
        return false;
    }

    public boolean isBranch() {
        return false;
    }

    public boolean isCall() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isIllegal() {
        return false;
    }

    public boolean isLoad() {
        return false;
    }

    public boolean isLogical() {
        return false;
    }

    public boolean isMove() {
        return false;
    }

    public boolean isReturn() {
        return false;
    }

    public boolean isShift() {
        return false;
    }

    public boolean isStore() {
        return false;
    }

    public boolean isTrap() {
        return false;
    }

    public boolean isNoop() {
        return false;
    }
}

