/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Immediate;
import sun.jvm.hotspot.asm.ImmediateOrRegister;
import sun.jvm.hotspot.asm.Instruction;
import sun.jvm.hotspot.asm.sparc.InstructionDecoder;
import sun.jvm.hotspot.asm.sparc.SPARCInstructionFactory;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCRegisters;
import sun.jvm.hotspot.asm.sparc.V9InstructionDecoder;

class V9ShiftDecoder
extends InstructionDecoder
implements V9InstructionDecoder {
    final int op3;
    final String name;
    final int rtlOperation;

    V9ShiftDecoder(int op3, String name, int rtlOperation) {
        this.op3 = op3;
        this.name = name;
        this.rtlOperation = rtlOperation;
    }

    static boolean isXBitSet(int instruction) {
        return (instruction & 0x1000) != 0;
    }

    Instruction decode(int instruction, SPARCInstructionFactory factory) {
        SPARCRegister rs1 = SPARCRegisters.getRegister(V9ShiftDecoder.getSourceRegister1(instruction));
        SPARCRegister rd = SPARCRegisters.getRegister(V9ShiftDecoder.getDestinationRegister(instruction));
        boolean xBit = V9ShiftDecoder.isXBitSet(instruction);
        ImmediateOrRegister operand2 = null;
        if (V9ShiftDecoder.isIBitSet(instruction)) {
            int value = instruction & (xBit ? 63 : 31);
            operand2 = new Immediate(new Short((short)value));
        } else {
            operand2 = SPARCRegisters.getRegister(V9ShiftDecoder.getSourceRegister2(instruction));
        }
        return factory.newShiftInstruction(xBit ? this.name + "x" : this.name, this.op3, this.rtlOperation, rs1, operand2, rd);
    }
}

