/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Immediate;
import sun.jvm.hotspot.asm.ImmediateOrRegister;
import sun.jvm.hotspot.asm.MoveInstruction;
import sun.jvm.hotspot.asm.Register;
import sun.jvm.hotspot.asm.SymbolFinder;
import sun.jvm.hotspot.asm.sparc.SPARCInstruction;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCRegisters;

public class SPARCSethiInstruction
extends SPARCInstruction
implements MoveInstruction {
    private final SPARCRegister register;
    private final ImmediateOrRegister value;
    private final String description;

    public SPARCSethiInstruction(int value, SPARCRegister register) {
        super("sethi");
        this.register = register;
        this.value = new Immediate(new Integer(value <<= 10));
        this.description = this.initDescription(value);
    }

    private String initDescription(int val) {
        if (val == 0 && this.register == SPARCRegisters.G0) {
            return "nop";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName());
        buf.append(spaces);
        buf.append("%hi(0x");
        buf.append(Integer.toHexString(val));
        buf.append(')');
        buf.append(comma);
        buf.append(this.register.toString());
        return buf.toString();
    }

    public String asString(long currentPc, SymbolFinder symFinder) {
        return this.description;
    }

    public Register getMoveDestination() {
        return this.register;
    }

    public ImmediateOrRegister getMoveSource() {
        return this.value;
    }

    public boolean isConditional() {
        return false;
    }
}

