/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.core.startup.layers.BinaryFS;
import org.netbeans.core.startup.layers.LayerCacheManager;
import org.netbeans.core.startup.layers.ParsingLayerCacheManager;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

final class BinaryCacheManager
extends ParsingLayerCacheManager {
    private final String cacheLocation;
    private static final String[] ATTR_TYPES = new String[]{"bytevalue", "shortvalue", "intvalue", "longvalue", "floatvalue", "doublevalue", "boolvalue", "charvalue", "stringvalue", "urlvalue", "methodvalue", "newvalue", "serialvalue", "bundlevalue"};
    private HashMap<ParsingLayerCacheManager.MemFileOrFolder, Integer> sizes;

    BinaryCacheManager() {
        this("all-layers.dat");
    }

    BinaryCacheManager(String string) {
        this.cacheLocation = string;
    }

    @Override
    public FileSystem createEmptyFileSystem() throws IOException {
        return FileUtil.createMemoryFileSystem();
    }

    @Override
    public FileSystem load(FileSystem fileSystem, ByteBuffer byteBuffer) throws IOException {
        try {
            BinaryFS binaryFS = new BinaryFS(this.cacheLocation(), byteBuffer);
            return binaryFS;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw (IOException)new IOException().initCause(bufferUnderflowException);
        }
    }

    @Override
    public String cacheLocation() {
        return this.cacheLocation;
    }

    @Override
    protected boolean openURLs() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void store(FileSystem fileSystem, ParsingLayerCacheManager.MemFolder memFolder, OutputStream outputStream) throws IOException {
        try {
            this.sizes = new HashMap(1000);
            int n = this.computeSize(memFolder);
            LayerCacheManager.err.fine("Writing binary layer cache of length " + (n + BinaryFS.MAGIC.length) + " to " + this.cacheLocation());
            outputStream.write(BinaryFS.MAGIC);
            BinaryWriter binaryWriter = new BinaryWriter(outputStream, memFolder, n);
            this.writeFolder(binaryWriter, memFolder, true);
        }
        finally {
            this.sizes = null;
            outputStream.close();
        }
    }

    void writeFolder(BinaryWriter binaryWriter, ParsingLayerCacheManager.MemFolder memFolder) throws IOException {
        this.writeFolder(binaryWriter, memFolder, false);
    }

    void writeFolder(BinaryWriter binaryWriter, ParsingLayerCacheManager.MemFolder memFolder, boolean bl) throws IOException {
        this.writeBaseURLs(memFolder, binaryWriter, bl);
        if (memFolder.attrs != null) {
            binaryWriter.writeInt(memFolder.attrs.size());
            Iterator iterator = memFolder.attrs.iterator();
            while (iterator.hasNext()) {
                this.writeAttribute(binaryWriter, (ParsingLayerCacheManager.MemAttr)iterator.next());
            }
        } else {
            binaryWriter.writeInt(0);
        }
        if (memFolder.children != null) {
            binaryWriter.writeInt(memFolder.children.size());
            int n = binaryWriter.getPosition();
            for (ParsingLayerCacheManager.MemFileOrFolder memFileOrFolder : memFolder.children) {
                n += this.computeHeaderSize(memFileOrFolder);
            }
            for (ParsingLayerCacheManager.MemFileOrFolder memFileOrFolder : memFolder.children) {
                binaryWriter.writeString(memFileOrFolder.name);
                binaryWriter.writeByte(memFileOrFolder instanceof ParsingLayerCacheManager.MemFile ? (byte)0 : 1);
                binaryWriter.writeInt(n);
                n += this.computeSize(memFileOrFolder);
            }
            for (ParsingLayerCacheManager.MemFileOrFolder memFileOrFolder : memFolder.children) {
                if (memFileOrFolder instanceof ParsingLayerCacheManager.MemFile) {
                    this.writeFile(binaryWriter, (ParsingLayerCacheManager.MemFile)memFileOrFolder);
                    continue;
                }
                this.writeFolder(binaryWriter, (ParsingLayerCacheManager.MemFolder)memFileOrFolder);
            }
        } else {
            binaryWriter.writeInt(0);
        }
    }

    private void writeBaseURLs(ParsingLayerCacheManager.MemFileOrFolder memFileOrFolder, BinaryWriter binaryWriter, boolean bl) throws IOException {
        List<URL> list = memFileOrFolder.getURLs();
        if (list.size() > 0) {
            int n = list.size() - 1;
            for (int i = 0; i < n; ++i) {
                URL uRL = list.get(i);
                binaryWriter.writeBaseURL(uRL);
            }
            binaryWriter.writeBaseURL(list.get(n), true);
        } else assert (bl);
    }

    private void writeFile(BinaryWriter binaryWriter, ParsingLayerCacheManager.MemFile memFile) throws IOException {
        this.writeBaseURLs(memFile, binaryWriter, false);
        if (memFile.attrs != null) {
            binaryWriter.writeInt(memFile.attrs.size());
            Iterator iterator = memFile.attrs.iterator();
            while (iterator.hasNext()) {
                this.writeAttribute(binaryWriter, (ParsingLayerCacheManager.MemAttr)iterator.next());
            }
        } else {
            binaryWriter.writeInt(0);
        }
        if (memFile.ref != null) {
            binaryWriter.writeInt(-1);
            binaryWriter.writeString(memFile.ref.toString());
        } else if (memFile.contents != null) {
            binaryWriter.writeInt(memFile.contents.length);
            binaryWriter.writeBytes(memFile.contents);
        } else {
            binaryWriter.writeInt(0);
        }
    }

    private void writeAttribute(BinaryWriter binaryWriter, ParsingLayerCacheManager.MemAttr memAttr) throws IOException {
        binaryWriter.writeString(memAttr.name);
        for (int i = 0; i < ATTR_TYPES.length; ++i) {
            if (!ATTR_TYPES[i].equals(memAttr.type)) continue;
            binaryWriter.writeByte((byte)i);
            binaryWriter.writeString(memAttr.data);
            return;
        }
        throw new IOException("Wrong type: " + memAttr);
    }

    private int computeSize(ParsingLayerCacheManager.MemFileOrFolder memFileOrFolder) {
        int n;
        block7: {
            Object object;
            block5: {
                block6: {
                    Integer n2 = this.sizes.get(memFileOrFolder);
                    if (n2 != null) {
                        return n2;
                    }
                    n = memFileOrFolder.getURLs().size() * 4;
                    n += 4;
                    if (memFileOrFolder.attrs != null) {
                        object = memFileOrFolder.attrs.iterator();
                        while (object.hasNext()) {
                            n += this.computeSize((ParsingLayerCacheManager.MemAttr)object.next());
                        }
                    }
                    if (!(memFileOrFolder instanceof ParsingLayerCacheManager.MemFile)) break block5;
                    object = (ParsingLayerCacheManager.MemFile)memFileOrFolder;
                    n += 4;
                    if (((ParsingLayerCacheManager.MemFile)object).ref == null) break block6;
                    n += BinaryCacheManager.computeSize(((ParsingLayerCacheManager.MemFile)object).ref.toString());
                    break block7;
                }
                if (((ParsingLayerCacheManager.MemFile)object).contents == null) break block7;
                n += ((ParsingLayerCacheManager.MemFile)object).contents.length;
                break block7;
            }
            object = (ParsingLayerCacheManager.MemFolder)memFileOrFolder;
            n += 4;
            if (((ParsingLayerCacheManager.MemFolder)object).children != null) {
                for (ParsingLayerCacheManager.MemFileOrFolder memFileOrFolder2 : ((ParsingLayerCacheManager.MemFolder)object).children) {
                    n += this.computeHeaderSize(memFileOrFolder2);
                    n += this.computeSize(memFileOrFolder2);
                }
            }
        }
        this.sizes.put(memFileOrFolder, n);
        return n;
    }

    private int computeHeaderSize(ParsingLayerCacheManager.MemFileOrFolder memFileOrFolder) {
        return BinaryCacheManager.computeSize(memFileOrFolder.name) + 1 + 4;
    }

    private static int computeSize(String string) {
        try {
            return 4 + string.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw (IllegalStateException)new IllegalStateException(unsupportedEncodingException.toString()).initCause(unsupportedEncodingException);
        }
    }

    private int computeSize(ParsingLayerCacheManager.MemAttr memAttr) {
        return BinaryCacheManager.computeSize(memAttr.name) + 1 + BinaryCacheManager.computeSize(memAttr.data);
    }

    private static final class BinaryWriter {
        private OutputStream os;
        private int position;
        private Map urls;

        BinaryWriter(OutputStream outputStream, ParsingLayerCacheManager.MemFolder memFolder, int n) throws IOException {
            this.os = outputStream;
            this.urls = this.writeBaseUrls(memFolder, n);
            this.position = 0;
        }

        int getPosition() {
            return this.position;
        }

        void writeByte(byte by) throws IOException {
            this.os.write(by);
            ++this.position;
        }

        void writeBytes(byte[] byArray) throws IOException {
            this.os.write(byArray);
            this.position += byArray.length;
        }

        void writeInt(int n) throws IOException {
            byte[] byArray = new byte[]{(byte)n, (byte)(n >> 8), (byte)(n >> 16), (byte)(n >> 24)};
            this.writeBytes(byArray);
        }

        void writeString(String string) throws IOException {
            byte[] byArray;
            try {
                byArray = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw (IllegalStateException)new IllegalStateException(unsupportedEncodingException.toString()).initCause(unsupportedEncodingException);
            }
            this.writeInt(byArray.length);
            this.writeBytes(byArray);
        }

        void writeBaseURL(URL uRL) throws IOException {
            this.writeBaseURL(uRL, false);
        }

        void writeBaseURL(URL uRL, boolean bl) throws IOException {
            int[] nArray = (int[])this.urls.get(uRL);
            assert (nArray != null) : "Should not be null, because it was collected: " + uRL + " map: " + this.urls;
            int n = nArray[0];
            if (bl) {
                n = -10 - n;
            }
            this.writeInt(n);
        }

        private Map writeBaseUrls(ParsingLayerCacheManager.MemFileOrFolder memFileOrFolder, int n) throws IOException {
            URL uRL;
            Map.Entry<URL, Object> entry;
            int n2;
            LinkedHashMap<URL, Object> linkedHashMap = new LinkedHashMap<URL, Object>();
            int[] nArray = new int[1];
            this.collectBaseUrls(memFileOrFolder, linkedHashMap, nArray);
            int n3 = 0;
            Iterator<Map.Entry<URL, Object>> iterator = linkedHashMap.entrySet().iterator();
            for (n2 = 0; n2 < nArray[0]; ++n2) {
                entry = iterator.next();
                uRL = entry.getKey();
                assert (((int[])entry.getValue())[0] == n2) : n2 + "th key should be it " + ((int[])entry.getValue())[0];
                n3 += BinaryCacheManager.computeSize(uRL.toExternalForm());
            }
            this.writeInt(BinaryFS.MAGIC.length + 4 + 4 + n3 + n);
            this.writeInt(n3);
            iterator = linkedHashMap.entrySet().iterator();
            for (n2 = 0; n2 < nArray[0]; ++n2) {
                entry = iterator.next();
                uRL = entry.getKey();
                this.writeString(uRL.toExternalForm());
            }
            return linkedHashMap;
        }

        private void collectBaseUrls(ParsingLayerCacheManager.MemFileOrFolder memFileOrFolder, Map<URL, Object> map, int[] nArray) {
            for (URL uRL : memFileOrFolder.getURLs()) {
                int[] nArray2 = (int[])map.get(uRL);
                if (nArray2 != null) continue;
                map.put(uRL, nArray.clone());
                nArray[0] = nArray[0] + 1;
            }
            if (memFileOrFolder instanceof ParsingLayerCacheManager.MemFolder && ((ParsingLayerCacheManager.MemFolder)memFileOrFolder).children != null) {
                Iterator<Object> iterator = ((ParsingLayerCacheManager.MemFolder)memFileOrFolder).children.iterator();
                while (iterator.hasNext()) {
                    this.collectBaseUrls((ParsingLayerCacheManager.MemFileOrFolder)iterator.next(), map, nArray);
                }
            }
        }
    }
}

