/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.Util;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

public final class InstalledFileLocatorImpl
extends InstalledFileLocator {
    private final File[] dirs;
    private static Map<String, Map<File, Set<String>>> fileCache = null;

    public InstalledFileLocatorImpl() {
        ArrayList<File> arrayList = new ArrayList<File>();
        InstalledFileLocatorImpl.addDir(arrayList, System.getProperty("netbeans.user"));
        String string = System.getProperty("netbeans.dirs");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                InstalledFileLocatorImpl.addDir(arrayList, stringTokenizer.nextToken());
            }
        }
        InstalledFileLocatorImpl.addDir(arrayList, System.getProperty("netbeans.home"));
        this.dirs = arrayList.toArray(new File[arrayList.size()]);
    }

    private static void addDir(List<File> list, String string) {
        File file;
        if (string != null && (file = new File(string).getAbsoluteFile()).isDirectory()) {
            list.add(FileUtil.normalizeFile((File)file));
        }
    }

    public static synchronized void prepareCache() {
        assert (fileCache == null);
        fileCache = new HashMap<String, Map<File, Set<String>>>();
    }

    public static synchronized void discardCache() {
        assert (fileCache != null);
        fileCache = null;
    }

    public File locate(String string, String string2, boolean bl) {
        Set<File> set = this.doLocate(string, bl, true);
        return set.isEmpty() ? null : set.iterator().next();
    }

    public Set<File> locateAll(String string, String string2, boolean bl) {
        return this.doLocate(string, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<File> doLocate(String string, boolean bl, boolean bl2) {
        String[] stringArray = InstalledFileLocatorImpl.prefixAndName(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        Class<InstalledFileLocatorImpl> clazz = InstalledFileLocatorImpl.class;
        synchronized (InstalledFileLocatorImpl.class) {
            if (bl) {
                String string4;
                String string5;
                int n = string3.lastIndexOf(46);
                if (n == -1) {
                    string5 = string3;
                    string4 = "";
                } else {
                    string5 = string3.substring(0, n);
                    string4 = string3.substring(n);
                }
                Set<File> set = null;
                for (String string6 : Util.getLocalizingSuffixesFast()) {
                    String string7 = string5 + string6 + string4;
                    Set<File> set2 = this.locateExactPath(string2, string7, bl2);
                    if (set2.isEmpty()) continue;
                    if (bl2) {
                        // ** MonitorExit[var7_7] (shouldn't be in output)
                        return set2;
                    }
                    if (set == null) {
                        set = set2;
                        continue;
                    }
                    set = new LinkedHashSet<File>(set);
                    set.addAll(set2);
                }
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return set != null ? set : Collections.emptySet();
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return this.locateExactPath(string2, string3, bl2);
        }
    }

    private Set<File> locateExactPath(String string, String string2, boolean bl) {
        assert (Thread.holdsLock(InstalledFileLocatorImpl.class));
        Set<File> set = null;
        if (fileCache != null) {
            Map<File, Set<String>> map = this.fileCachePerPrefix(string);
            for (int i = 0; i < this.dirs.length; ++i) {
                Set<String> set2 = map.get(this.dirs[i]);
                if (set2 == null || !set2.contains(string2)) continue;
                File file = InstalledFileLocatorImpl.makeFile(this.dirs[i], string, string2);
                if (bl) {
                    return Collections.singleton(file);
                }
                if (set == null) {
                    set = Collections.singleton(file);
                    continue;
                }
                set = new LinkedHashSet<File>(set);
                set.add(file);
            }
        } else {
            for (int i = 0; i < this.dirs.length; ++i) {
                File file = InstalledFileLocatorImpl.makeFile(this.dirs[i], string, string2);
                if (!file.exists()) continue;
                if (bl) {
                    return Collections.singleton(file);
                }
                if (set == null) {
                    set = Collections.singleton(file);
                    continue;
                }
                set = new LinkedHashSet<File>(set);
                set.add(file);
            }
        }
        return set != null ? set : Collections.emptySet();
    }

    private static String[] prefixAndName(String string) {
        String string2;
        String string3;
        if (string.length() == 0) {
            throw new IllegalArgumentException("Cannot look up \"\" in InstalledFileLocator.locate");
        }
        if (string.charAt(0) == '/') {
            throw new IllegalArgumentException("Paths passed to InstalledFileLocator.locate should not start with '/': " + string);
        }
        int n = string.lastIndexOf(47);
        if (n == string.length() - 1) {
            throw new IllegalArgumentException("Paths passed to InstalledFileLocator.locate should not end in '/': " + string);
        }
        if (n != -1) {
            string3 = string.substring(0, n + 1);
            string2 = string.substring(n + 1);
            assert (string2.length() > 0);
        } else {
            string3 = "";
            string2 = string;
        }
        return new String[]{string3, string2};
    }

    private Map<File, Set<String>> fileCachePerPrefix(String string) {
        assert (Thread.holdsLock(InstalledFileLocatorImpl.class));
        Map<File, Set<String>> map = fileCache.get(string);
        if (map == null) {
            map = new HashMap<File, Set<String>>(this.dirs.length * 2);
            for (int i = 0; i < this.dirs.length; ++i) {
                File file;
                File file2 = this.dirs[i];
                if (string.length() > 0) {
                    assert (string.charAt(string.length() - 1) == '/');
                    file = new File(file2, string.substring(0, string.length() - 1).replace('/', File.separatorChar));
                } else {
                    file = file2;
                }
                if (!file.isDirectory()) continue;
                String[] stringArray = file.list();
                if (stringArray != null) {
                    map.put(file2, new HashSet<String>(Arrays.asList(stringArray)));
                    continue;
                }
                Util.err.warning("could not read files in " + file);
            }
            fileCache.put(string, map);
        }
        return map;
    }

    private static File makeFile(File file, String string, String string2) {
        return new File(file, string.replace('/', File.separatorChar) + string2);
    }
}

