/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.GeomBuffer;

class Quadrics {
    Quadrics() {
    }

    GeomBuffer cylinder(double d, double d2, double d3, int n, int n2, boolean bl) {
        double d4 = bl ? 1.0 : -1.0;
        double d5 = Math.PI * 2 / (double)n;
        double d6 = (d2 - d) / (double)n2;
        double d7 = d3 / (double)n2;
        double d8 = (d - d2) / d3;
        double d9 = 1.0 / (double)n;
        double d10 = 1.0 / (double)n2;
        GeomBuffer geomBuffer = new GeomBuffer(n * n2 * 4);
        double d11 = 0.0;
        double d12 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d13 = Math.cos((double)i * d5 + 1.5707963267948966);
            double d14 = Math.sin((double)i * d5 + 1.5707963267948966);
            double d15 = Math.cos((double)(i + 1) * d5 + 1.5707963267948966);
            double d16 = Math.sin((double)(i + 1) * d5 + 1.5707963267948966);
            double d17 = -1.0 * d3 / 2.0;
            double d18 = d;
            d12 = 0.0;
            geomBuffer.begin(1);
            int n3 = 0;
            while (n3 <= n2) {
                if (n3 == n2 && d2 == 0.0) {
                    if (bl) {
                        geomBuffer.normal3d(0.0, 0.0, d8 * d4);
                        geomBuffer.texCoord2d(d11, d12);
                        geomBuffer.vertex3d(d13 * d18, d14 * d18, d17);
                        geomBuffer.normal3d(0.0, 0.0, d8 * d4);
                        geomBuffer.texCoord2d(d11 + d9, d12);
                        geomBuffer.vertex3d(d15 * d18, d16 * d18, d17);
                    } else {
                        geomBuffer.normal3d(0.0, 0.0, d8 * d4);
                        geomBuffer.texCoord2d(d11, d12);
                        geomBuffer.vertex3d(d15 * d18, d16 * d18, d17);
                        geomBuffer.normal3d(0.0, 0.0, d8 * d4);
                        geomBuffer.texCoord2d(d11 + d9, d12);
                        geomBuffer.vertex3d(d13 * d18, d14 * d18, d17);
                    }
                } else if (bl) {
                    geomBuffer.normal3d(d13 * d4, d14 * d4, d8 * d4);
                    geomBuffer.texCoord2d(d11, d12);
                    geomBuffer.vertex3d(d13 * d18, d14 * d18, d17);
                    geomBuffer.normal3d(d15 * d4, d16 * d4, d8 * d4);
                    geomBuffer.texCoord2d(d11 + d9, d12);
                    geomBuffer.vertex3d(d15 * d18, d16 * d18, d17);
                } else {
                    geomBuffer.normal3d(d15 * d4, d16 * d4, d8 * d4);
                    geomBuffer.texCoord2d(d11, d12);
                    geomBuffer.vertex3d(d15 * d18, d16 * d18, d17);
                    geomBuffer.normal3d(d13 * d4, d14 * d4, d8 * d4);
                    geomBuffer.texCoord2d(d11 + d9, d12);
                    geomBuffer.vertex3d(d13 * d18, d14 * d18, d17);
                }
                ++n3;
                d17 += d7;
                d18 += d6;
                d12 += d10;
            }
            geomBuffer.end();
            d11 += d9;
        }
        return geomBuffer;
    }

    GeomBuffer disk(double d, int n, boolean bl) {
        double d2 = bl ? 1.0 : -1.0;
        double d3 = Math.PI * 2 / (double)n;
        GeomBuffer geomBuffer = new GeomBuffer(n * 4);
        geomBuffer.begin(16);
        geomBuffer.normal3d(0.0, 0.0, 1.0 * d2);
        geomBuffer.texCoord2d(0.5, 0.5);
        geomBuffer.vertex3d(0.0, 0.0, 0.0);
        if (bl) {
            for (int i = 0; i <= n; ++i) {
                double d4 = (double)i * d3;
                double d5 = Math.sin(d4 + 1.5707963267948966);
                double d6 = Math.cos(d4 + 1.5707963267948966);
                geomBuffer.normal3d(0.0, 0.0, 1.0 * d2);
                geomBuffer.texCoord2d(0.5 + d6 * 0.5, 0.5 + d5 * 0.5);
                geomBuffer.vertex3d(d * d6, d * d5, 0.0);
            }
        } else {
            for (int i = n; i >= 0; --i) {
                double d7 = (double)i * d3;
                double d8 = Math.sin(d7 + 1.5707963267948966);
                double d9 = Math.cos(d7 + 1.5707963267948966);
                geomBuffer.normal3d(0.0, 0.0, 1.0 * d2);
                geomBuffer.texCoord2d(0.5 + d9 * 0.5, 0.5 - d8 * 0.5);
                geomBuffer.vertex3d(d * d9, d * d8, 0.0);
            }
        }
        geomBuffer.end();
        return geomBuffer;
    }

    GeomBuffer coneTop(double d, double d2, int n, int n2, boolean bl) {
        double d3 = d / (double)n2;
        double d4 = d2 / 2.0 - d2 / (double)n2;
        double d5 = d2 / 2.0;
        double d6 = bl ? 1.0 : -1.0;
        double d7 = Math.PI * 2 / (double)n;
        double d8 = d3 / (d5 - d4);
        double d9 = 1.0 / (double)n;
        GeomBuffer geomBuffer = new GeomBuffer(n + 2);
        geomBuffer.begin(16);
        geomBuffer.normal3d(0.0, 0.0, d8 * d6);
        geomBuffer.texCoord2d(0.5, 1.0);
        geomBuffer.vertex3d(0.0, 0.0, d5);
        double d10 = 0.0;
        double d11 = 1.0 - 1.0 / (double)n2;
        if (bl) {
            for (int i = 0; i <= n; ++i) {
                double d12 = Math.cos((double)i * d7 + 1.5707963267948966);
                double d13 = Math.sin((double)i * d7 + 1.5707963267948966);
                geomBuffer.normal3d(d12 * d6, d13 * d6, d8 * d6);
                geomBuffer.texCoord2d(d10, d11);
                geomBuffer.vertex3d(d12 * d3, d13 * d3, d4);
                d10 += d9;
            }
        } else {
            for (int i = n; i >= 0; --i) {
                double d14 = Math.cos((double)i * d7 + 1.5707963267948966);
                double d15 = Math.sin((double)i * d7 + 1.5707963267948966);
                geomBuffer.normal3d(d14 * d6, d15 * d6, d8 * d6);
                geomBuffer.texCoord2d(d10, d11);
                geomBuffer.vertex3d(d14 * d3, d15 * d3, d4);
                d10 += d9;
            }
        }
        geomBuffer.end();
        return geomBuffer;
    }

    GeomBuffer coneBody(double d, double d2, int n, int n2, boolean bl) {
        double d3 = -d2 / 2.0;
        double d4 = d / (double)n2;
        double d5 = bl ? 1.0 : -1.0;
        double d6 = Math.PI * 2 / (double)n;
        double d7 = -d / (double)n2;
        double d8 = d2 / (double)n2;
        double d9 = d / d2;
        double d10 = 1.0 / (double)n;
        double d11 = 1.0 / (double)n2;
        GeomBuffer geomBuffer = new GeomBuffer(n * n2 * 4);
        double d12 = 0.0;
        double d13 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d14 = Math.cos((double)i * d6 + 1.5707963267948966);
            double d15 = Math.sin((double)i * d6 + 1.5707963267948966);
            double d16 = Math.cos((double)(i + 1) * d6 + 1.5707963267948966);
            double d17 = Math.sin((double)(i + 1) * d6 + 1.5707963267948966);
            double d18 = d;
            d13 = 0.0;
            double d19 = d3;
            geomBuffer.begin(1);
            int n3 = 0;
            while (n3 <= n2 - 1) {
                if (bl) {
                    geomBuffer.normal3d(d14 * d5, d15 * d5, d9 * d5);
                    geomBuffer.texCoord2d(d12, d13);
                    geomBuffer.vertex3d(d14 * d18, d15 * d18, d19);
                    geomBuffer.normal3d(d16 * d5, d17 * d5, d9 * d5);
                    geomBuffer.texCoord2d(d12 + d10, d13);
                    geomBuffer.vertex3d(d16 * d18, d17 * d18, d19);
                } else {
                    geomBuffer.normal3d(d16 * d5, d17 * d5, d9 * d5);
                    geomBuffer.texCoord2d(d12, d13);
                    geomBuffer.vertex3d(d16 * d18, d17 * d18, d19);
                    geomBuffer.normal3d(d14 * d5, d15 * d5, d9 * d5);
                    geomBuffer.texCoord2d(d12 + d10, d13);
                    geomBuffer.vertex3d(d14 * d18, d15 * d18, d19);
                }
                ++n3;
                d19 += d8;
                d18 += d7;
                d13 += d11;
            }
            geomBuffer.end();
            d12 += d10;
        }
        return geomBuffer;
    }

    GeomBuffer disk(double d, int n, double d2, boolean bl) {
        double d3 = bl ? 1.0 : -1.0;
        double d4 = Math.PI * 2 / (double)n;
        GeomBuffer geomBuffer = new GeomBuffer(n + 2);
        geomBuffer.begin(16);
        geomBuffer.normal3d(0.0, 1.0 * d3, 0.0);
        geomBuffer.texCoord2d(0.5, 0.5);
        geomBuffer.vertex3d(0.0, d2, 0.0);
        if (!bl) {
            for (int i = 0; i <= n; ++i) {
                double d5 = (double)i * d4;
                double d6 = Math.sin(d5 - 1.5707963267948966);
                double d7 = Math.cos(d5 - 1.5707963267948966);
                geomBuffer.normal3d(0.0, 1.0 * d3, 0.0);
                geomBuffer.texCoord2d(0.5 + d7 * 0.5, 0.5 + d6 * 0.5);
                geomBuffer.vertex3d(d * d7, d2, d * d6);
            }
        } else {
            for (int i = n; i >= 0; --i) {
                double d8 = (double)i * d4;
                double d9 = Math.sin(d8 - 1.5707963267948966);
                double d10 = Math.cos(d8 - 1.5707963267948966);
                geomBuffer.normal3d(0.0, 1.0 * d3, 0.0);
                geomBuffer.texCoord2d(0.5 + d10 * 0.5, 0.5 - d9 * 0.5);
                geomBuffer.vertex3d(d10 * d, d2, d9 * d);
            }
        }
        geomBuffer.end();
        return geomBuffer;
    }

    GeomBuffer cylinder(double d, double d2, int n, int n2, boolean bl) {
        double d3 = bl ? 1.0 : -1.0;
        double d4 = Math.PI * 2 / (double)n;
        double d5 = d / (double)n2;
        double d6 = 1.0 / (double)n;
        double d7 = 1.0 / (double)n2;
        GeomBuffer geomBuffer = new GeomBuffer(n2 * 2 * (n + 1));
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = -d / 2.0;
        geomBuffer.begin(1);
        for (int i = 0; i < n2; ++i) {
            int n3;
            double d11;
            double d12;
            double d13;
            double d14;
            double d15 = d10 + d5;
            if (bl) {
                d14 = Math.cos((double)n * d4 - 1.5707963267948966);
                d13 = Math.sin((double)n * d4 - 1.5707963267948966);
                d12 = Math.cos((double)(n - 1) * d4 - 1.5707963267948966);
                d11 = Math.sin((double)(n - 1) * d4 - 1.5707963267948966);
                geomBuffer.normal3d(d14 * d3, 0.0, d13 * d3);
                geomBuffer.texCoord2d(d8, d9 + d7);
                geomBuffer.vertex3d(d14 * d2, d15, d13 * d2);
                geomBuffer.normal3d(d14 * d3, 0.0, d13 * d3);
                geomBuffer.texCoord2d(d8, d9);
                geomBuffer.vertex3d(d14 * d2, d10, d13 * d2);
                geomBuffer.normal3d(d12 * d3, 0.0, d11 * d3);
                geomBuffer.texCoord2d(d8 + d6, d9 + d7);
                geomBuffer.vertex3d(d12 * d2, d15, d11 * d2);
                geomBuffer.normal3d(d12 * d3, 0.0, d11 * d3);
                geomBuffer.texCoord2d(d8 + d6, d9);
                geomBuffer.vertex3d(d12 * d2, d10, d11 * d2);
                d8 += d6 * 2.0;
                for (n3 = n - 2; n3 >= 0; --n3) {
                    d14 = Math.cos((double)n3 * d4 - 1.5707963267948966);
                    d13 = Math.sin((double)n3 * d4 - 1.5707963267948966);
                    geomBuffer.normal3d(d14 * d3, 0.0, d13 * d3);
                    geomBuffer.texCoord2d(d8, d9 + d7);
                    geomBuffer.vertex3d(d14 * d2, d15, d13 * d2);
                    geomBuffer.normal3d(d14 * d3, 0.0, d13 * d3);
                    geomBuffer.texCoord2d(d8, d9);
                    geomBuffer.vertex3d(d14 * d2, d10, d13 * d2);
                    d8 += d6;
                }
            } else {
                d14 = Math.cos(-1.5707963267948966);
                d13 = Math.sin(-1.5707963267948966);
                d12 = Math.cos(d4 - 1.5707963267948966);
                d11 = Math.sin(d4 - 1.5707963267948966);
                geomBuffer.normal3d(d14 * d3, 0.0, d13 * d3);
                geomBuffer.texCoord2d(d8, d9 + d7);
                geomBuffer.vertex3d(d14 * d2, d15, d13 * d2);
                geomBuffer.normal3d(d14 * d3, 0.0, d13 * d3);
                geomBuffer.texCoord2d(d8, d9);
                geomBuffer.vertex3d(d14 * d2, d10, d13 * d2);
                geomBuffer.normal3d(d12 * d3, 0.0, d11 * d3);
                geomBuffer.texCoord2d(d8 + d6, d9 + d7);
                geomBuffer.vertex3d(d12 * d2, d15, d11 * d2);
                geomBuffer.normal3d(d12 * d3, 0.0, d11 * d3);
                geomBuffer.texCoord2d(d8 + d6, d9);
                geomBuffer.vertex3d(d12 * d2, d10, d11 * d2);
                d8 += d6 * 2.0;
                for (n3 = 2; n3 <= n; ++n3) {
                    d14 = Math.cos((double)n3 * d4 - 1.5707963267948966);
                    d13 = Math.sin((double)n3 * d4 - 1.5707963267948966);
                    geomBuffer.normal3d(d14 * d3, 0.0, d13 * d3);
                    geomBuffer.texCoord2d(d8, d9 + d7);
                    geomBuffer.vertex3d(d14 * d2, d15, d13 * d2);
                    geomBuffer.normal3d(d14 * d3, 0.0, d13 * d3);
                    geomBuffer.texCoord2d(d8, d9);
                    geomBuffer.vertex3d(d14 * d2, d10, d13 * d2);
                    d8 += d6;
                }
            }
            d8 = 0.0;
            d9 += d7;
            d10 += d5;
        }
        geomBuffer.end();
        return geomBuffer;
    }

    GeomBuffer coneBody(double d, double d2, double d3, double d4, int n, int n2, double d5, boolean bl) {
        double d6 = bl ? 1.0 : -1.0;
        double d7 = Math.PI * 2 / (double)n;
        double d8 = (d4 - d3) / (double)n2;
        double d9 = d2 - d;
        double d10 = d9 / (double)n2;
        double d11 = (d3 - d4) / d9;
        double d12 = 1.0 / (double)n;
        GeomBuffer geomBuffer = new GeomBuffer(n2 * 2 * (n + 1));
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = d;
        double d16 = d3;
        geomBuffer.begin(1);
        for (int i = 0; i < n2; ++i) {
            int n3;
            double d17;
            double d18;
            double d19;
            double d20;
            double d21 = d15 + d10;
            if (bl) {
                d20 = Math.cos((double)n * d7 - 1.5707963267948966);
                d19 = Math.sin((double)n * d7 - 1.5707963267948966);
                d18 = Math.cos((double)(n - 1) * d7 - 1.5707963267948966);
                d17 = Math.sin((double)(n - 1) * d7 - 1.5707963267948966);
                geomBuffer.normal3d(d20 * d6, d11 * d6, d19 * d6);
                geomBuffer.texCoord2d(d13, d14 + d5);
                geomBuffer.vertex3d(d20 * (d16 + d8), d21, d19 * (d16 + d8));
                geomBuffer.normal3d(d20 * d6, d11 * d6, d19 * d6);
                geomBuffer.texCoord2d(d13, d14);
                geomBuffer.vertex3d(d20 * d16, d15, d19 * d16);
                geomBuffer.normal3d(d18 * d6, d11 * d6, d17 * d6);
                geomBuffer.texCoord2d(d13 + d12, d14 + d5);
                geomBuffer.vertex3d(d18 * (d16 + d8), d21, d17 * (d16 + d8));
                geomBuffer.normal3d(d18 * d6, d11 * d6, d17 * d6);
                geomBuffer.texCoord2d(d13 + d12, d14);
                geomBuffer.vertex3d(d18 * d16, d15, d17 * d16);
                d13 += d12 * 2.0;
                for (n3 = n - 2; n3 >= 0; --n3) {
                    d20 = Math.cos((double)n3 * d7 - 1.5707963267948966);
                    d19 = Math.sin((double)n3 * d7 - 1.5707963267948966);
                    geomBuffer.normal3d(d20 * d6, d11 * d6, d19 * d6);
                    geomBuffer.texCoord2d(d13, d14 + d5);
                    geomBuffer.vertex3d(d20 * (d16 + d8), d21, d19 * (d16 + d8));
                    geomBuffer.normal3d(d20 * d6, d11 * d6, d19 * d6);
                    geomBuffer.texCoord2d(d13, d14);
                    geomBuffer.vertex3d(d20 * d16, d15, d19 * d16);
                    d13 += d12;
                }
            } else {
                d20 = Math.cos(-1.5707963267948966);
                d19 = Math.sin(-1.5707963267948966);
                d18 = Math.cos(d7 - 1.5707963267948966);
                d17 = Math.sin(d7 - 1.5707963267948966);
                geomBuffer.normal3d(d20 * d6, d11 * d6, d19 * d6);
                geomBuffer.texCoord2d(d13, d14 + d5);
                geomBuffer.vertex3d(d20 * (d16 + d8), d21, d19 * (d16 + d8));
                geomBuffer.normal3d(d20 * d6, d11 * d6, d19 * d6);
                geomBuffer.texCoord2d(d13, d14);
                geomBuffer.vertex3d(d20 * d16, d15, d19 * d16);
                geomBuffer.normal3d(d18 * d6, d11 * d6, d17 * d6);
                geomBuffer.texCoord2d(d13 + d12, d14 + d5);
                geomBuffer.vertex3d(d18 * (d16 + d8), d21, d17 * (d16 + d8));
                geomBuffer.normal3d(d18 * d6, d11 * d6, d17 * d6);
                geomBuffer.texCoord2d(d13 + d12, d14);
                geomBuffer.vertex3d(d18 * d16, d15, d17 * d16);
                d13 += d12 * 2.0;
                for (n3 = 2; n3 <= n; ++n3) {
                    d20 = Math.cos((double)n3 * d7 - 1.5707963267948966);
                    d19 = Math.sin((double)n3 * d7 - 1.5707963267948966);
                    geomBuffer.normal3d(d20 * d6, d11 * d6, d19 * d6);
                    geomBuffer.texCoord2d(d13, d14 + d5);
                    geomBuffer.vertex3d(d20 * (d16 + d8), d21, d19 * (d16 + d8));
                    geomBuffer.normal3d(d20 * d6, d11 * d6, d19 * d6);
                    geomBuffer.texCoord2d(d13, d14);
                    geomBuffer.vertex3d(d20 * d16, d15, d19 * d16);
                    d13 += d12;
                }
            }
            d13 = 0.0;
            d14 += d5;
            d15 += d10;
            d16 += d8;
        }
        geomBuffer.end();
        return geomBuffer;
    }

    GeomBuffer coneTop(double d, double d2, double d3, int n, double d4, boolean bl) {
        double d5 = bl ? 1.0 : -1.0;
        double d6 = Math.PI * 2 / (double)n;
        double d7 = d2 / d3;
        double d8 = 1.0 / (double)n;
        double d9 = d + d3;
        GeomBuffer geomBuffer = new GeomBuffer(n + 2);
        geomBuffer.begin(16);
        geomBuffer.normal3d(0.0, d7 * d5, 0.0);
        geomBuffer.texCoord2d(0.5, 1.0);
        geomBuffer.vertex3d(0.0, d9, 0.0);
        double d10 = 0.0;
        if (bl) {
            for (int i = n; i >= 0; --i) {
                double d11 = Math.cos((double)i * d6 - 1.5707963267948966);
                double d12 = Math.sin((double)i * d6 - 1.5707963267948966);
                geomBuffer.normal3d(d11 * d5, d7 * d5, d12 * d5);
                geomBuffer.texCoord2d(d10, d4);
                geomBuffer.vertex3d(d11 * d2, d, d12 * d2);
                d10 += d8;
            }
        } else {
            for (int i = 0; i <= n; ++i) {
                double d13 = Math.cos((double)i * d6 - 1.5707963267948966);
                double d14 = Math.sin((double)i * d6 - 1.5707963267948966);
                geomBuffer.normal3d(d13 * d5, d7 * d5, d14 * d5);
                geomBuffer.texCoord2d(d10, d4);
                geomBuffer.vertex3d(d13 * d2, d, d14 * d2);
                d10 += d8;
            }
        }
        geomBuffer.end();
        return geomBuffer;
    }
}

