/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.awt.EventQueue;
import java.util.Collections;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

final class AsynchChildren<T>
extends Children.Keys<Object>
implements ChildFactory.Observer,
Runnable {
    private final ChildFactory<T> factory;
    private final RequestProcessor.Task task;
    private static final RequestProcessor PROC = new RequestProcessor("Asynch children creator ", 4, true);
    private static final Logger logger = Logger.getLogger(AsynchChildren.class.getName());
    volatile boolean initialized = false;
    volatile boolean cancelled = false;
    volatile boolean notified;
    private final Object notifyLock = new Object();

    AsynchChildren(ChildFactory<T> childFactory) {
        childFactory.setObserver(this);
        this.factory = childFactory;
        this.task = PROC.create((Runnable)this, true);
    }

    @Override
    protected void addNotify() {
        logger.log(Level.FINER, "addNotify on {0}", new Object[]{this});
        if (!this.initialized && this.task.isFinished() || this.cancelled) {
            this.cancelled = false;
            Node node = this.factory.getWaitNode();
            if (node != null) {
                this.setKeys(new Object[]{node});
            }
            this.task.schedule(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeNotify() {
        logger.log(Level.FINER, "removeNotify on {0}", new Object[]{this});
        try {
            this.cancelled = true;
            this.task.cancel();
            this.initialized = false;
            this.setKeys(Collections.emptyList());
        }
        finally {
            Object object = this.notifyLock;
            synchronized (object) {
                if (this.notified) {
                    this.factory.removeNotify();
                }
            }
        }
    }

    @Override
    public void refresh(boolean bl) {
        logger.log(Level.FINE, "Refresh on {0} immediate {1}", new Object[]{this, bl &= !EventQueue.isDispatchThread()});
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Refresh: ", new Exception());
        }
        if (bl) {
            boolean bl2;
            LinkedList linkedList = new LinkedList();
            while (!(bl2 = this.factory.createKeys(linkedList))) {
            }
            this.setKeys(linkedList);
        } else {
            this.task.schedule(0);
        }
    }

    @Override
    public Node[] getNodes(boolean bl) {
        Node[] nodeArray = super.getNodes();
        if (bl) {
            this.task.waitFinished();
            nodeArray = super.getNodes();
        }
        return nodeArray;
    }

    @Override
    public Node findChild(String string) {
        Node[] nodeArray = this.getNodes(true);
        return super.findChild(string);
    }

    @Override
    protected Node[] createNodes(Object object) {
        if (ChildFactory.isWaitNode(object)) {
            return new Node[]{(Node)object};
        }
        return this.factory.createNodesForKey(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl;
        boolean bl2 = this.cancelled || Thread.interrupted();
        logger.log(Level.FINE, "Running background children creation on {0} fail = {1}", new Object[]{this, bl2});
        if (bl2) {
            this.setKeys(Collections.emptyList());
            return;
        }
        LinkedList linkedList = new LinkedList();
        do {
            Object object = this.notifyLock;
            synchronized (object) {
                if (!this.notified) {
                    this.notified = true;
                    this.factory.addNotify();
                }
            }
            if (this.cancelled || Thread.interrupted()) {
                this.setKeys(Collections.emptyList());
                return;
            }
            bl = this.factory.createKeys(linkedList);
            if (this.cancelled || Thread.interrupted()) {
                this.setKeys(Collections.emptyList());
                return;
            }
            this.setKeys(new LinkedList(linkedList));
        } while (!bl && !Thread.interrupted() && !this.cancelled);
        this.initialized = bl;
    }

    public String toString() {
        return super.toString() + "[" + this.factory + "]";
    }
}

