/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.NetworkProblemPanel;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.SettingsTableModel;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategory;
import org.netbeans.modules.autoupdate.ui.actions.ShowNotifications;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class Utilities {
    private static Logger logger = Logger.getLogger(Utilities.class.getName());
    private static Boolean isModulesOnly;
    private static String PLUGIN_MANAGER_MODULES_ONLY;
    private static String PLUGIN_MANAGER_SHARED_INSTALLATION;
    public static String PLUGIN_MANAGER_CHECK_INTERVAL;
    public static final SimpleDateFormat DATE_FORMAT;
    public static final String TIME_OF_MODEL_INITIALIZATION = "time_of_model_initialization";
    public static final String TIME_OF_REFRESH_UPDATE_CENTERS = "time_of_refresh_update_centers";
    static final String UNSORTED_CATEGORY;
    static final String LIBRARIES_CATEGORY;
    static final String BRIDGES_CATEGORY;
    private static final String FIRST_CLASS_MODULES = "org.netbeans.modules.autoupdate.services, org.netbeans.modules.autoupdate.ui";
    private static final String PLUGIN_MANAGER_FIRST_CLASS_MODULES = "plugin.manager.first.class.modules";
    private static final String ALLOW_SHOWING_BALLOON = "plugin.manager.allow.showing.balloon";
    private static final String SHOWING_BALLOON_TIMEOUT = "plugin.manager.showing.balloon.timeout";
    private static final RequestProcessor WORKER_THREADS_PROCESSOR;
    private static Collection<String> first_class_modules;

    public static List<UnitCategory> makeInstalledCategories(List<UpdateUnit> list) {
        ArrayList<UnitCategory> arrayList = new ArrayList<UnitCategory>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (UpdateUnit updateUnit : list) {
            UnitCategory unitCategory;
            UpdateElement updateElement = updateUnit.getInstalled();
            if (updateElement == null && !updateUnit.isPending()) continue;
            String string = updateElement == null && updateUnit.isPending() ? ((UpdateElement)updateUnit.getAvailableUpdates().get(0)).getCategory() : updateElement.getCategory();
            Unit.Installed installed = new Unit.Installed(updateUnit, string);
            if (arrayList2.contains(string)) {
                unitCategory = (UnitCategory)arrayList.get(arrayList2.indexOf(string));
                unitCategory.addUnit(installed);
                continue;
            }
            unitCategory = new UnitCategory(string);
            unitCategory.addUnit(installed);
            arrayList.add(unitCategory);
            arrayList2.add(string);
        }
        logger.log(Level.FINER, "makeInstalledCategories (" + list.size() + ") returns " + arrayList.size());
        return arrayList;
    }

    public static List<UnitCategory> makeUpdateCategories(List<UpdateUnit> list, boolean bl) {
        Object object;
        Object object2;
        Object object32;
        Object object4;
        Object object52;
        Object object6;
        Collection<OperationContainer> collection;
        Object object7;
        List<Object> list2;
        long l = System.currentTimeMillis();
        if (!bl && !list.isEmpty()) {
            list2 = Utilities.makeFirstClassUpdateCategories();
            if (!list2.isEmpty()) {
                return list2;
            }
            if (Utilities.hasPendingFirstClassModules()) {
                return new ArrayList<UnitCategory>();
            }
        }
        list2 = new ArrayList();
        if (list.isEmpty()) {
            return list2;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashSet<UpdateUnit> hashSet = new HashSet<UpdateUnit>();
        HashMap<UpdateUnit, List<UpdateElement>> hashMap = new HashMap<UpdateUnit, List<UpdateElement>>();
        for (UpdateUnit object82 : list) {
            object7 = object82.getInstalled();
            if (object82.isPending() || object7 == null || (collection = object82.getAvailableUpdates()).isEmpty()) continue;
            hashSet.add(object82);
            object6 = new ArrayList();
            object52 = OperationContainer.createForUpdate();
            object4 = object52.add((UpdateElement)collection.get(0));
            Set bl2 = object4.getRequiredElements();
            for (Object object32 : bl2) {
                if (object32.getUpdateUnit().isPending()) continue;
                hashSet.add(object32.getUpdateUnit());
                object6.add(object32);
            }
            for (Object object32 : object52.listAll()) {
                if (object32.getUpdateUnit().isPending()) continue;
                hashSet.add(object32.getUpdateUnit());
                if (object82.equals((Object)object32.getUpdateUnit())) continue;
                object6.add(object32.getUpdateElement());
            }
            object2 = object7.getCategory();
            if (arrayList.contains(object2)) {
                object32 = (UnitCategory)list2.get(arrayList.indexOf(object2));
                ((UnitCategory)object32).addUnit(new Unit.Update(object82, bl, (String)object2));
                continue;
            }
            object32 = new UnitCategory((String)object2);
            ((UnitCategory)object32).addUnit(new Unit.Update(object82, bl, (String)object2));
            list2.add(object32);
            arrayList.add(object2);
        }
        List list3 = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
        HashSet<Collection<OperationContainer>> hashSet2 = new HashSet<Collection<OperationContainer>>();
        object7 = list3.iterator();
        while (object7.hasNext()) {
            collection = (UpdateUnit)object7.next();
            if (hashSet.contains(collection) || collection.getAvailableUpdates().size() <= 0 || collection.getInstalled() == null || collection.isPending() || !collection.getInstalled().isEnabled() && !OperationContainer.createForEnable().canBeAdded((UpdateUnit)collection, collection.getInstalled())) continue;
            hashSet2.add(collection);
        }
        object7 = new ArrayList();
        Utilities.createVisibleModulesDependecyMap(list, hashMap);
        collection = new HashSet();
        if (hashSet2.size() > 0 && !bl) {
            for (Object object52 : hashSet2) {
                object4 = Utilities.getVisibleUnitForInvisibleModule((UpdateUnit)object52, hashMap);
                if (object4 != null) {
                    boolean updateUnit = false;
                    object2 = object7.iterator();
                    while (object2.hasNext()) {
                        object32 = (Unit.InternalUpdate)object2.next();
                        if (((Unit.InternalUpdate)object32).getVisibleUnit() != object4) continue;
                        ((Unit.InternalUpdate)object32).getUpdateUnits().add((UpdateUnit)object52);
                        updateUnit = true;
                    }
                    if (updateUnit) continue;
                    object2 = object4.getInstalled().getCategory();
                    object32 = new Unit.InternalUpdate((UpdateUnit)object4, (String)object2, false);
                    ((Unit.InternalUpdate)object32).getUpdateUnits().add((UpdateUnit)object52);
                    object7.add(object32);
                    object = new UnitCategory((String)object2);
                    list2.add(object);
                    arrayList.add(object2);
                    ((UnitCategory)object).addUnit((Unit)object32);
                    continue;
                }
                collection.add((OperationContainer)object52);
            }
        }
        object6 = new HashMap();
        Utilities.createVisibleModulesDependecyMap((Collection<UpdateUnit>)collection, (Map<UpdateUnit, List<UpdateElement>>)object6);
        object52 = new HashSet();
        for (UpdateUnit internalUpdate : collection) {
            boolean bl2 = true;
            object32 = (UpdateElement)internalUpdate.getAvailableUpdates().get(0);
            for (Object object8 : object6.keySet()) {
                if (object8.equals((Object)internalUpdate) || !((List)object6.get(object8)).contains(object32) || object52.contains(object8)) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                Object object8;
                object = object32.getCategory();
                object8 = null;
                if (arrayList.contains(object)) {
                    object8 = (UnitCategory)list2.get(arrayList.indexOf(object));
                } else {
                    object8 = new UnitCategory((String)object);
                    list2.add(object8);
                    arrayList.add(object);
                }
                ((UnitCategory)object8).addUnit(new Unit.Update(internalUpdate, bl, ((UnitCategory)object8).getCategoryName()));
                continue;
            }
            object52.add(internalUpdate);
        }
        object4 = object7.iterator();
        while (object4.hasNext()) {
            Unit.InternalUpdate internalUpdate = (Unit.InternalUpdate)object4.next();
            internalUpdate.initState();
        }
        logger.log(Level.FINE, "makeUpdateCategories (" + list.size() + ") returns " + list2.size() + ", took " + (System.currentTimeMillis() - l) + " ms");
        return list2;
    }

    public static HashMap<UpdateUnit, List<UpdateElement>> getVisibleModulesDependecyMap(Collection<UpdateUnit> collection) {
        HashMap<UpdateUnit, List<UpdateElement>> hashMap = new HashMap<UpdateUnit, List<UpdateElement>>();
        Utilities.createVisibleModulesDependecyMap(collection, hashMap);
        return hashMap;
    }

    private static void createVisibleModulesDependecyMap(Collection<UpdateUnit> collection, Map<UpdateUnit, List<UpdateElement>> map) {
        for (UpdateUnit updateUnit : collection) {
            if (updateUnit.getInstalled() == null || updateUnit.isPending() || map.containsKey(updateUnit)) continue;
            OperationContainer operationContainer = updateUnit.getAvailableUpdates().isEmpty() ? OperationContainer.createForInternalUpdate() : OperationContainer.createForUpdate();
            OperationContainer.OperationInfo operationInfo = operationContainer.add(updateUnit, updateUnit.getAvailableUpdates().isEmpty() ? updateUnit.getInstalled() : (UpdateElement)updateUnit.getAvailableUpdates().get(0));
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (UpdateElement updateElement : operationInfo.getRequiredElements()) {
                if (updateElement.getUpdateUnit().isPending()) continue;
                arrayList.add(updateElement);
            }
            for (UpdateElement updateElement : operationContainer.listAll()) {
                List list;
                UpdateUnit updateUnit2 = updateElement.getUpdateUnit();
                if (updateUnit2 == updateUnit || (list = updateUnit2.getAvailableUpdates()).size() <= 0 || arrayList.contains(list.get(0))) continue;
                arrayList.add(list.get(0));
            }
            if (arrayList.isEmpty()) continue;
            map.put(updateUnit, arrayList);
        }
    }

    public static UpdateUnit getVisibleUnitForInvisibleModule(UpdateUnit updateUnit, Map<UpdateUnit, List<UpdateElement>> map) {
        ArrayList<UpdateUnit> arrayList = new ArrayList<UpdateUnit>();
        for (UpdateUnit updateUnit2 : map.keySet()) {
            for (UpdateElement object : map.get(updateUnit2)) {
                if (!object.getUpdateUnit().equals((Object)updateUnit)) continue;
                logger.log(Level.FINE, "... found candidate visible module " + updateUnit2.getCodeName() + " for invisible " + updateUnit.getCodeName());
                arrayList.add(updateUnit2);
            }
        }
        UpdateUnit updateUnit3 = null;
        if (arrayList.size() == 0) {
            logger.log(Level.FINE, "Have not found visible module for invisible " + updateUnit.getCodeName());
        } else {
            int n = 0;
            UpdateUnit updateUnit4 = null;
            for (UpdateUnit updateUnit2 : arrayList) {
                int n2 = Utilities.getNameOverlapping(updateUnit2.getCodeName(), updateUnit.getCodeName());
                if (n2 <= n) continue;
                updateUnit4 = updateUnit2;
                n = n2;
            }
            if (updateUnit4 != null) {
                updateUnit3 = updateUnit4;
            } else {
                updateUnit3 = (UpdateUnit)arrayList.get(0);
                for (UpdateUnit updateUnit2 : arrayList) {
                    if (!updateUnit2.getCodeName().endsWith(".kit")) continue;
                    updateUnit3 = updateUnit2;
                    break;
                }
            }
            logger.log(Level.FINE, "Found visible module " + ((UpdateUnit)arrayList.get(0)).getCodeName() + " for invisible " + updateUnit.getCodeName());
        }
        return updateUnit3;
    }

    private static int getNameOverlapping(String string, String string2) {
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        int n = stringArray.length;
        int n2 = stringArray2.length;
        int n3 = Math.min(n, n2);
        int n4 = 0;
        for (n4 = 0; n4 < n3 && stringArray[n4].equals(stringArray2[n4]); ++n4) {
        }
        return 2 * n4 > n3 ? n4 : 0;
    }

    public static long getTimeOfInitialization() {
        return Utilities.getPreferences().getLong(TIME_OF_MODEL_INITIALIZATION, 0L);
    }

    public static void putTimeOfInitialization(long l) {
        Utilities.getPreferences().putLong(TIME_OF_MODEL_INITIALIZATION, l);
    }

    public static long getTimeOfRefreshUpdateCenters() {
        return Utilities.getPreferences().getLong(TIME_OF_REFRESH_UPDATE_CENTERS, 0L);
    }

    public static void putTimeOfRefreshUpdateCenters(long l) {
        Utilities.getPreferences().putLong(TIME_OF_REFRESH_UPDATE_CENTERS, l);
    }

    private static List<UnitCategory> makeFirstClassUpdateCategories() {
        List list = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
        ArrayList<UnitCategory> arrayList = new ArrayList<UnitCategory>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Collection<String> collection = Utilities.getFirstClassModules();
        for (UpdateUnit updateUnit : list) {
            UnitCategory unitCategory;
            List list2;
            UpdateElement updateElement = updateUnit.getInstalled();
            if (updateUnit.isPending() || updateElement == null || (list2 = updateUnit.getAvailableUpdates()).isEmpty() || !collection.contains(updateElement.getCodeName())) continue;
            String string = updateElement.getCategory();
            if (arrayList2.contains(string)) {
                unitCategory = (UnitCategory)arrayList.get(arrayList2.indexOf(string));
                unitCategory.addUnit(new Unit.Update(updateUnit, false, string));
                continue;
            }
            unitCategory = new UnitCategory(string);
            unitCategory.addUnit(new Unit.Update(updateUnit, false, string));
            arrayList.add(unitCategory);
            arrayList2.add(string);
        }
        logger.log(Level.FINER, "makeFirstClassUpdateCategories (" + list.size() + ") returns " + arrayList.size());
        return arrayList;
    }

    private static boolean hasPendingFirstClassModules() {
        List list = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
        Collection<String> collection = Utilities.getFirstClassModules();
        for (UpdateUnit updateUnit : list) {
            List list2;
            UpdateElement updateElement = updateUnit.getInstalled();
            if (!updateUnit.isPending() || updateElement == null || (list2 = updateUnit.getAvailableUpdates()).isEmpty() || !collection.contains(updateElement.getCodeName())) continue;
            return true;
        }
        return false;
    }

    public static List<UnitCategory> makeAvailableCategories(List<UpdateUnit> list, boolean bl) {
        ArrayList<UnitCategory> arrayList = new ArrayList<UnitCategory>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (UpdateUnit updateUnit : list) {
            UnitCategory unitCategory;
            List list2;
            UpdateElement updateElement = updateUnit.getInstalled();
            if (updateUnit.isPending() || updateElement != null || (list2 = updateUnit.getAvailableUpdates()) == null || list2.size() == 0) continue;
            UpdateElement updateElement2 = (UpdateElement)list2.get(0);
            String string = updateElement2.getCategory();
            if (arrayList2.contains(string)) {
                unitCategory = (UnitCategory)arrayList.get(arrayList2.indexOf(string));
                unitCategory.addUnit(new Unit.Available(updateUnit, bl, string));
                continue;
            }
            unitCategory = new UnitCategory(string);
            unitCategory.addUnit(new Unit.Available(updateUnit, bl, string));
            arrayList.add(unitCategory);
            arrayList2.add(string);
        }
        logger.log(Level.FINER, "makeAvailableCategories (" + list.size() + ") returns " + arrayList.size());
        return arrayList;
    }

    public static void showURL(URL uRL) {
        HtmlBrowser.URLDisplayer uRLDisplayer = HtmlBrowser.URLDisplayer.getDefault();
        assert (uRLDisplayer != null) : "HtmlBrowser.URLDisplayer found.";
        if (uRLDisplayer != null) {
            uRLDisplayer.showURL(uRL);
        } else {
            logger.log(Level.INFO, "No URLDisplayer found.");
        }
    }

    public static String getDownloadSizeAsString(int n) {
        int n2 = n / 0x40000000;
        if (n2 > 0) {
            return n2 + Utilities.getBundle("Utilities_DownloadSize_GB", new Object[0]);
        }
        int n3 = n / 0x100000;
        if (n3 > 0) {
            return n3 + Utilities.getBundle("Utilities_DownloadSize_MB", new Object[0]);
        }
        int n4 = n / 1024;
        if (n4 > 0) {
            return n4 + Utilities.getBundle("Utilities_DownloadSize_kB", new Object[0]);
        }
        return n + Utilities.getBundle("Utilities_DownloadSize_B", new Object[0]);
    }

    private static String getBundle(String string, Object ... objectArray) {
        return NbBundle.getMessage(Utilities.class, (String)string, (Object[])objectArray);
    }

    public static void presentRefreshProvider(UpdateUnitProvider updateUnitProvider, PluginManagerUI pluginManagerUI, boolean bl) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Don't presentRefreshProvider() call in EQ!";
        Utilities.doRefreshProviders(Collections.singleton(updateUnitProvider), pluginManagerUI, bl);
    }

    public static void presentRefreshProviders(Collection<UpdateUnitProvider> collection, PluginManagerUI pluginManagerUI, boolean bl) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Don't presentRefreshProvider() call in EQ!";
        Utilities.doRefreshProviders(collection, pluginManagerUI, bl);
    }

    public static void presentRefreshProviders(PluginManagerUI pluginManagerUI, boolean bl) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Don't presentRefreshProviders() call in EQ!";
        Utilities.doRefreshProviders(null, pluginManagerUI, bl);
    }

    private static void doRefreshProviders(Collection<UpdateUnitProvider> collection, PluginManagerUI pluginManagerUI, boolean bl) {
        boolean bl2 = false;
        while (!bl2) {
            bl2 = Utilities.tryRefreshProviders(collection, pluginManagerUI, bl);
        }
    }

    public static void showProviderNotification(UpdateUnitProvider updateUnitProvider) {
        ShowNotifications.checkNotification(updateUnitProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean tryRefreshProviders(Collection<UpdateUnitProvider> list, PluginManagerUI pluginManagerUI, boolean bl) {
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(SettingsTableModel.class, (String)"Utilities_CheckingForUpdates"));
        JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
        JLabel jLabel = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)progressHandle);
        jLabel.setHorizontalAlignment(2);
        try {
            pluginManagerUI.setProgressComponent(jLabel, jComponent);
            progressHandle.setInitialDelay(0);
            progressHandle.start();
            if (list == null) {
                list = UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(true);
            }
            for (UpdateUnitProvider updateUnitProvider : list) {
                try {
                    updateUnitProvider.refresh(progressHandle, bl);
                    Utilities.showProviderNotification(updateUnitProvider);
                }
                catch (IOException iOException) {
                    boolean bl2;
                    block12: {
                        logger.log(Level.INFO, iOException.getMessage(), iOException);
                        JButton jButton = new JButton();
                        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)Utilities.getBundle("Utilities_NetworkProblem_Cancel", new Object[0]));
                        JButton jButton2 = new JButton();
                        Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)Utilities.getBundle("Utilities_NetworkProblem_Skip", new Object[0]));
                        jButton2.setEnabled(list.size() > 1);
                        JButton jButton3 = new JButton();
                        Mnemonics.setLocalizedText((AbstractButton)jButton3, (String)Utilities.getBundle("Utilities_NetworkProblem_Continue", new Object[0]));
                        NetworkProblemPanel networkProblemPanel = new NetworkProblemPanel(Utilities.getBundle("Utilities_NetworkProblem_Text", updateUnitProvider.getDisplayName(), iOException.getLocalizedMessage()), jButton3, jButton2, jButton);
                        Object object = networkProblemPanel.showNetworkProblemDialog();
                        if (jButton2.equals(object)) continue;
                        if (jButton3.equals(object)) {
                            boolean bl3 = false;
                            if (progressHandle != null) {
                                progressHandle.finish();
                            }
                            Containers.initNotify();
                            pluginManagerUI.unsetProgressComponent(jLabel, jComponent);
                            return bl3;
                        }
                        try {
                            bl2 = true;
                            if (progressHandle == null) break block12;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            return true;
                        }
                        progressHandle.finish();
                    }
                    Containers.initNotify();
                    pluginManagerUI.unsetProgressComponent(jLabel, jComponent);
                    return bl2;
                }
            }
        }
        finally {
            if (progressHandle != null) {
                progressHandle.finish();
            }
            Containers.initNotify();
            pluginManagerUI.unsetProgressComponent(jLabel, jComponent);
        }
    }

    public static void startAsWorkerThread(PluginManagerUI pluginManagerUI, Runnable runnable, String string) {
        Utilities.startAsWorkerThread(pluginManagerUI, runnable, string, 0L);
    }

    public static void startAsWorkerThread(final PluginManagerUI pluginManagerUI, final Runnable runnable, final String string, final long l) {
        Utilities.startAsWorkerThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string);
                JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
                JLabel jLabel = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)progressHandle);
                try {
                    jLabel.setHorizontalAlignment(2);
                    pluginManagerUI.setProgressComponent(jLabel, jComponent);
                    progressHandle.setInitialDelay(0);
                    if (l == 0L) {
                        progressHandle.start();
                        progressHandle.progress(string);
                        runnable.run();
                    } else {
                        assert (l > 0L) : "Estimated time " + l;
                        final long l2 = l + 2L;
                        progressHandle.start((int)l2 * 10, l2);
                        progressHandle.progress(string, 0);
                        final RequestProcessor.Task task = RequestProcessor.getDefault().post(runnable);
                        RequestProcessor.getDefault().post(new Runnable(){

                            @Override
                            public void run() {
                                int n = 0;
                                while (!task.isFinished()) {
                                    try {
                                        if (l2 * 10L <= (long)n++) {
                                            progressHandle.switchToIndeterminate();
                                            progressHandle.progress(string);
                                            return;
                                        }
                                        progressHandle.progress(string, n);
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                            }
                        });
                        task.addTaskListener(new TaskListener(){

                            public void taskFinished(Task task) {
                                task.removeTaskListener((TaskListener)this);
                                progressHandle.finish();
                            }
                        });
                        task.waitFinished();
                    }
                }
                finally {
                    if (progressHandle != null) {
                        progressHandle.finish();
                    }
                    pluginManagerUI.unsetProgressComponent(jLabel, jComponent);
                }
            }
        });
    }

    public static RequestProcessor.Task startAsWorkerThread(Runnable runnable) {
        return Utilities.startAsWorkerThread(runnable, 0);
    }

    public static RequestProcessor.Task startAsWorkerThread(Runnable runnable, int n) {
        RequestProcessor.Task task = WORKER_THREADS_PROCESSOR.create(runnable);
        if (SwingUtilities.isEventDispatchThread()) {
            task.schedule(n);
        } else {
            if (n > 0) {
                try {
                    Thread.sleep(n);
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
            }
            task.run();
        }
        return task;
    }

    public static UpdateManager.TYPE[] getUnitTypes() {
        if (Utilities.modulesOnly()) {
            return new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE};
        }
        return new UpdateManager.TYPE[]{UpdateManager.TYPE.KIT_MODULE, UpdateManager.TYPE.CUSTOM_HANDLED_COMPONENT};
    }

    public static boolean isGlobalInstallation() {
        return Utilities.getPreferences().getBoolean(PLUGIN_MANAGER_SHARED_INSTALLATION, Boolean.valueOf(System.getProperty("plugin.manager.install.global")));
    }

    public static void setGlobalInstallation(boolean bl) {
        Utilities.getPreferences().putBoolean(PLUGIN_MANAGER_SHARED_INSTALLATION, bl);
    }

    public static boolean modulesOnly() {
        return isModulesOnly == null ? Utilities.modulesOnlyDefault() : isModulesOnly;
    }

    public static boolean showExtendedDescription() {
        return Boolean.valueOf(System.getProperty("plugin.manager.extended.description"));
    }

    public static String getCustomCheckIntervalInMinutes() {
        return System.getProperty(PLUGIN_MANAGER_CHECK_INTERVAL);
    }

    private static String getCustomFirstClassModules() {
        return System.getProperty(PLUGIN_MANAGER_FIRST_CLASS_MODULES);
    }

    public static Collection<String> getFirstClassModules() {
        if (first_class_modules != null) {
            return first_class_modules;
        }
        String string = Utilities.getCustomFirstClassModules();
        if (string == null || string.length() == 0) {
            string = FIRST_CLASS_MODULES;
        }
        first_class_modules = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            first_class_modules.add(stringTokenizer.nextToken().trim());
        }
        return first_class_modules;
    }

    public static Boolean allowShowingBalloon() {
        String string = System.getProperty(ALLOW_SHOWING_BALLOON);
        return string == null ? null : Boolean.valueOf(string);
    }

    public static int getShowingBalloonTimeout() {
        String string = System.getProperty(SHOWING_BALLOON_TIMEOUT);
        int n = 30000;
        try {
            if (string != null) {
                n = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.log(Level.INFO, numberFormatException + " while parsing " + string + " for " + SHOWING_BALLOON_TIMEOUT);
        }
        return n;
    }

    public static boolean shouldCheckAvailableNewPlugins() {
        String string = System.getProperty("plugin.manager.check.new.plugins");
        return string == null ? false : Boolean.valueOf(string);
    }

    public static boolean shouldCheckAvailableUpdates() {
        String string = System.getProperty("plugin.manager.check.updates");
        return string == null ? true : Boolean.valueOf(string);
    }

    public static void setModulesOnly(boolean bl) {
        isModulesOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        Utilities.getPreferences().putBoolean(PLUGIN_MANAGER_MODULES_ONLY, isModulesOnly);
    }

    private static boolean modulesOnlyDefault() {
        return Utilities.getPreferences().getBoolean(PLUGIN_MANAGER_MODULES_ONLY, Boolean.valueOf(System.getProperty("plugin.manager.modules.only")));
    }

    public static Comparator<String> getCategoryComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                if (LIBRARIES_CATEGORY.equals(string)) {
                    if (LIBRARIES_CATEGORY.equals(string2)) {
                        return 0;
                    }
                    return 1;
                }
                if (LIBRARIES_CATEGORY.equals(string2)) {
                    return -1;
                }
                if (BRIDGES_CATEGORY.equals(string)) {
                    if (BRIDGES_CATEGORY.equals(string2)) {
                        return 0;
                    }
                    return 1;
                }
                if (BRIDGES_CATEGORY.equals(string2)) {
                    return -1;
                }
                if (UNSORTED_CATEGORY.equals(string)) {
                    if (UNSORTED_CATEGORY.equals(string2)) {
                        return 0;
                    }
                    return 1;
                }
                if (UNSORTED_CATEGORY.equals(string2)) {
                    return -1;
                }
                return Collator.getInstance().compare(string, string2);
            }
        };
    }

    public static List<File> sharedDirs() {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = System.getProperty("netbeans.dirs");
        if (string != null) {
            object = new StringTokenizer(string, File.pathSeparator);
            while (object.hasMoreElements()) {
                File file = new File((String)object.nextElement());
                arrayList.add(file);
            }
        }
        if ((object = Utilities.getPlatformDir()) != null) {
            arrayList.add(object);
        }
        return Collections.unmodifiableList(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWriteInCluster(File file) {
        File file2;
        assert (file != null) : "dir cannot be null";
        assert (file.exists()) : file + " must exists";
        assert (file.isDirectory()) : file + " is directory";
        if (file == null || !file.exists() || !file.isDirectory()) {
            logger.log(Level.INFO, "Invalid cluster " + file);
            return false;
        }
        if (file.canWrite() && file.canRead() && org.openide.util.Utilities.isWindows() && (file2 = new File(file, "update_tracking")).exists() && file2.isDirectory()) {
            for (File file3 : file2.listFiles()) {
                if (!file3.exists() || !file3.isFile()) continue;
                FileWriter fileWriter = null;
                try {
                    fileWriter = new FileWriter(file3, true);
                }
                catch (IOException iOException) {
                    logger.log(Level.FINE, file3 + " has no write permission", iOException);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        if (fileWriter != null) {
                            fileWriter.close();
                        }
                    }
                    catch (IOException iOException) {
                        logger.log(Level.INFO, iOException.getLocalizedMessage(), iOException);
                    }
                }
                logger.log(Level.FINE, file3 + " has write permission");
                return true;
            }
        }
        logger.log(Level.FINE, "Can write into " + file + "? " + file.canWrite());
        return file.canWrite();
    }

    private static File getPlatformDir() {
        String string = System.getProperty("netbeans.home");
        return string == null ? null : new File(string);
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(Utilities.class);
    }

    static String getCategoryName(UpdateUnitProvider.CATEGORY cATEGORY) {
        String string = null;
        switch (cATEGORY) {
            case STANDARD: {
                string = "AvailableTab_SourceCategory_Tooltip_STANDARD";
                break;
            }
            case BETA: {
                string = "AvailableTab_SourceCategory_Tooltip_BETA";
                break;
            }
            case COMMUNITY: {
                string = "AvailableTab_SourceCategory_Tooltip_COMMUNITY";
            }
        }
        return string != null ? Utilities.getBundle(string, new Object[0]) : null;
    }

    static URL getCategoryIcon(UpdateUnitProvider.CATEGORY cATEGORY) {
        URL uRL = null;
        if (UpdateUnitProvider.CATEGORY.BETA.equals((Object)cATEGORY)) {
            uRL = Utilities.class.getResource("/org/netbeans/modules/autoupdate/ui/resources/icon-beta.png");
        } else if (UpdateUnitProvider.CATEGORY.COMMUNITY.equals((Object)cATEGORY)) {
            uRL = Utilities.class.getResource("/org/netbeans/modules/autoupdate/ui/resources/icon-community.png");
        } else if (UpdateUnitProvider.CATEGORY.STANDARD.equals((Object)cATEGORY)) {
            uRL = Utilities.class.getResource("/org/netbeans/modules/autoupdate/ui/resources/icon-standard.png");
        }
        return uRL;
    }

    static {
        PLUGIN_MANAGER_MODULES_ONLY = "plugin_manager_modules_only";
        PLUGIN_MANAGER_SHARED_INSTALLATION = "plugin_manager_shared_installation";
        PLUGIN_MANAGER_CHECK_INTERVAL = "plugin.manager.check.interval";
        DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");
        UNSORTED_CATEGORY = NbBundle.getMessage(Utilities.class, (String)"Utilities_Unsorted_Category");
        LIBRARIES_CATEGORY = NbBundle.getMessage(Utilities.class, (String)"Utilities_Libraries_Category");
        BRIDGES_CATEGORY = NbBundle.getMessage(Utilities.class, (String)"Utilities_Bridges_Category");
        WORKER_THREADS_PROCESSOR = new RequestProcessor("autoupdate-ui-worker", 10, false);
        first_class_modules = null;
    }
}

