/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.modules.appui.about;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private static MediaTracker mTracker = new MediaTracker(new JPanel());
    private Image image;
    private static final Color BACKGROUND_COLOR = Color.WHITE;
    private static final Color STRIPE_COLOR = new Color(237, 28, 36);

    public ImagePanel(Image image) {
        this.setImage(image);
    }

    public void setImage(Image image) {
        this.image = ImagePanel.loadImage(image);
        if (this.image == null) {
            throw new RuntimeException("Failed to load image");
        }
        this.setPreferredSize(new Dimension(this.image.getWidth(null), this.image.getHeight(null)));
    }

    protected static Image loadImage(Image image) {
        mTracker.addImage(image, 0);
        try {
            mTracker.waitForID(0);
        }
        catch (InterruptedException e) {
            return null;
        }
        mTracker.removeImage(image, 0);
        return image;
    }

    protected void paintComponent(Graphics g) {
        int panelWidth = this.getWidth();
        int imageWidth = this.image.getWidth(null);
        if (imageWidth >= panelWidth) {
            g.drawImage(this.image, panelWidth - imageWidth, 0, this);
        } else {
            g.setColor(BACKGROUND_COLOR);
            g.fillRect(0, 0, panelWidth, this.getHeight());
            g.setColor(STRIPE_COLOR);
            g.fillRect(0, 196, panelWidth, 26);
            g.drawImage(this.image, (panelWidth - imageWidth) / 2, 0, this);
        }
    }
}

