/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.AllThreadsMergedCPUCCTContainer;
import org.netbeans.lib.profiler.results.cpu.CPUCCTClassContainer;
import org.netbeans.lib.profiler.results.cpu.CPUCCTContainer;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.MethodIdMap;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNodeBacked;

public class CPUResultsSnapshot
extends ResultsSnapshot {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.cpu.Bundle");
    private static final String CPU_MSG = messages.getString("CPUResultsSnapshot_CpuMsg");
    public static final int METHOD_LEVEL_VIEW = 0;
    public static final int CLASS_LEVEL_VIEW = 1;
    public static final int PACKAGE_LEVEL_VIEW = 2;
    protected Map threadIdMap;
    protected CPUCCTContainer[] allThreadsMergedCCTContainers;
    protected String[][] instrMethodClassesViews;
    protected String[] instrMethodNames;
    protected String[] instrMethodSignatures;
    protected PrestimeCPUCCTNode[] rootNode;
    protected CPUCCTContainer[][] threadCCTContainers;
    protected boolean collectingTwoTimeStamps;
    protected boolean sortNodesOrder;
    protected int nInstrMethods;
    private int sortNodesBy;

    public CPUResultsSnapshot() {
        this.threadIdMap = new HashMap();
    }

    public CPUResultsSnapshot(long l, long l2, CPUCCTProvider cPUCCTProvider, boolean bl, String[] stringArray, String[] stringArray2, String[] stringArray3, int n) throws NoDataAvailableException {
        super(l, l2);
        this.collectingTwoTimeStamps = bl;
        this.instrMethodClassesViews = new String[3][];
        this.instrMethodClassesViews[0] = stringArray;
        this.instrMethodNames = stringArray2;
        this.instrMethodSignatures = stringArray3;
        this.nInstrMethods = n;
        CPUCCTContainer[] cPUCCTContainerArray = cPUCCTProvider.createPresentationCCTs(this);
        if (cPUCCTContainerArray == null) {
            throw new NoDataAvailableException();
        }
        int n2 = cPUCCTContainerArray.length;
        if (n2 == 0) {
            throw new NoDataAvailableException();
        }
        this.threadIdMap = new HashMap(cPUCCTContainerArray.length);
        for (int i = 0; i < cPUCCTContainerArray.length; ++i) {
            this.threadIdMap.put(cPUCCTContainerArray[i].threadId, i);
        }
        this.threadCCTContainers = new CPUCCTContainer[3][];
        this.threadCCTContainers[0] = cPUCCTContainerArray;
        this.allThreadsMergedCCTContainers = new CPUCCTContainer[3];
        this.rootNode = new PrestimeCPUCCTNode[3];
        this.rootNode[0] = this.createRootNodeForAllThreads(0);
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    public boolean isCollectingTwoTimeStamps() {
        return this.collectingTwoTimeStamps;
    }

    public CPUCCTContainer getContainerForThread(int n, int n2) {
        if (this.threadCCTContainers[n2] == null) {
            this.generateDataForView(n2);
        }
        return this.threadCCTContainers[n2][this.getContainerIdForThreadId(n)];
    }

    public FlatProfileContainer getFlatProfile(int n, int n2) {
        if (this.threadCCTContainers[n2] == null) {
            this.generateDataForView(n2);
        }
        if (n != -1) {
            return this.threadCCTContainers[n2][this.getContainerIdForThreadId(n)].getFlatProfile();
        }
        return this.allThreadsMergedCCTContainers[n2].getFlatProfile();
    }

    public String[] getInstrMethodClasses(int n) {
        return this.instrMethodClassesViews[n];
    }

    public String[] getInstrMethodNames() {
        return this.instrMethodNames;
    }

    public String[] getInstrMethodSignatures() {
        return this.instrMethodSignatures;
    }

    public String[] getMethodClassNameAndSig(int n, int n2) {
        if (n2 == 0) {
            return new String[]{this.instrMethodClassesViews[0][n], this.instrMethodNames[n], this.instrMethodSignatures[n]};
        }
        return new String[]{this.instrMethodClassesViews[n2][n], null, null};
    }

    public int getNInstrMethods() {
        return this.nInstrMethods;
    }

    public int getNThreads() {
        return this.threadCCTContainers[0].length;
    }

    public PrestimeCPUCCTNode getReverseCCT(int n, int n2, int n3) {
        if (this.threadCCTContainers[n3] == null) {
            this.generateDataForView(n3);
        }
        if (n >= 0) {
            return this.threadCCTContainers[n3][this.getContainerIdForThreadId(n)].getReverseCCT(n2);
        }
        if (n == -1) {
            return this.allThreadsMergedCCTContainers[n3].getReverseCCT(n2);
        }
        throw new IllegalArgumentException("!!! Cannot generate reverse CCT for threadId = " + n);
    }

    public PrestimeCPUCCTNode getRootNode(int n) {
        if (this.threadCCTContainers[n] == null) {
            this.generateDataForView(n);
        }
        return this.rootNode[n];
    }

    public int getSortBy() {
        return this.sortNodesBy;
    }

    public boolean getSortOrder() {
        return this.sortNodesOrder;
    }

    public int[] getThreadIds() {
        int[] nArray = new int[this.threadCCTContainers[0].length];
        for (int i = 0; i < this.threadCCTContainers[0].length; ++i) {
            nArray[i] = this.threadCCTContainers[0][i].threadId;
        }
        return nArray;
    }

    public String getThreadNameForId(int n) {
        return this.getThreadNames()[this.getContainerIdForThreadId(n)];
    }

    public String[] getThreadNames() {
        String[] stringArray = new String[this.threadCCTContainers[0].length];
        for (int i = 0; i < this.threadCCTContainers[0].length; ++i) {
            stringArray[i] = this.threadCCTContainers[0][i].threadName;
        }
        return stringArray;
    }

    @Override
    public void readFromStream(DataInputStream dataInputStream) throws IOException {
        int n;
        super.readFromStream(dataInputStream);
        this.collectingTwoTimeStamps = dataInputStream.readBoolean();
        this.nInstrMethods = dataInputStream.readInt();
        this.instrMethodClassesViews = new String[3][];
        String[] stringArray = new String[this.nInstrMethods];
        this.instrMethodClassesViews[0] = stringArray;
        this.instrMethodNames = new String[this.nInstrMethods];
        this.instrMethodSignatures = new String[this.nInstrMethods];
        for (n = 0; n < this.nInstrMethods; ++n) {
            stringArray[n] = dataInputStream.readUTF();
            this.instrMethodNames[n] = dataInputStream.readUTF();
            this.instrMethodSignatures[n] = dataInputStream.readUTF();
        }
        n = dataInputStream.readInt();
        this.threadCCTContainers = new CPUCCTContainer[3][];
        CPUCCTContainer[] cPUCCTContainerArray = new CPUCCTContainer[n];
        this.threadCCTContainers[0] = cPUCCTContainerArray;
        for (int i = 0; i < n; ++i) {
            cPUCCTContainerArray[i] = new CPUCCTContainer(this);
            cPUCCTContainerArray[i].readFromStream(dataInputStream);
            this.threadIdMap.put(cPUCCTContainerArray[i].threadId, i);
        }
        this.allThreadsMergedCCTContainers = new CPUCCTContainer[3];
        this.rootNode = new PrestimeCPUCCTNode[3];
        this.rootNode[0] = this.createRootNodeForAllThreads(0);
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    public void saveSortParams(int n, boolean bl) {
        this.sortNodesBy = n;
        this.sortNodesOrder = bl;
    }

    @Override
    public String toString() {
        return MessageFormat.format(CPU_MSG, super.toString());
    }

    @Override
    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        super.writeToStream(dataOutputStream);
        dataOutputStream.writeBoolean(this.collectingTwoTimeStamps);
        dataOutputStream.writeInt(this.nInstrMethods);
        String[] stringArray = this.instrMethodClassesViews[0];
        for (int i = 0; i < this.nInstrMethods; ++i) {
            dataOutputStream.writeUTF(stringArray[i]);
            dataOutputStream.writeUTF(this.instrMethodNames[i]);
            dataOutputStream.writeUTF(this.instrMethodSignatures[i]);
        }
        CPUCCTContainer[] cPUCCTContainerArray = this.threadCCTContainers[0];
        int n = cPUCCTContainerArray.length;
        dataOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            cPUCCTContainerArray[i].writeToStream(dataOutputStream);
        }
    }

    private int getContainerIdForThreadId(int n) {
        Integer n2 = n;
        Integer n3 = null;
        if (this.threadIdMap.containsKey(n2)) {
            n3 = (Integer)this.threadIdMap.get(n2);
        }
        return n3 != null ? n3 : 0;
    }

    protected PrestimeCPUCCTNode createRootNodeForAllThreads(int n) {
        CPUCCTContainer[] cPUCCTContainerArray = this.threadCCTContainers[n];
        int n2 = cPUCCTContainerArray.length;
        PrestimeCPUCCTNode[] prestimeCPUCCTNodeArray = new PrestimeCPUCCTNode[n2];
        for (int i = 0; i < n2; ++i) {
            PrestimeCPUCCTNode prestimeCPUCCTNode = cPUCCTContainerArray[i].getRootNode();
            prestimeCPUCCTNodeArray[i] = !prestimeCPUCCTNode.isThreadNode() ? new PrestimeCPUCCTNodeBacked(cPUCCTContainerArray[i], new PrestimeCPUCCTNode[]{prestimeCPUCCTNode}) : prestimeCPUCCTNode;
        }
        this.allThreadsMergedCCTContainers[n] = new AllThreadsMergedCPUCCTContainer(this, prestimeCPUCCTNodeArray, n);
        return this.allThreadsMergedCCTContainers[n].getRootNode();
    }

    private void debugValues() {
        LOGGER.finest("collectingTwoTimeStamps: " + this.collectingTwoTimeStamps);
        LOGGER.finest("threadCCTContainers.length: " + this.debugLength(this.threadCCTContainers));
        LOGGER.finest("allThreadsMergedCCTContainers.length: " + this.debugLength(this.allThreadsMergedCCTContainers));
        LOGGER.finest("rootNode.length: " + this.debugLength(this.rootNode));
        LOGGER.finest("instrMethodClassesViews.length: " + this.debugLength(this.instrMethodClassesViews));
        LOGGER.finest("instrMethodNames.length: " + this.debugLength(this.instrMethodNames));
        LOGGER.finest("instrMethodSignatures.length: " + this.debugLength(this.instrMethodSignatures));
        LOGGER.finest("nInstrMethods: " + this.nInstrMethods);
        LOGGER.finest("sortNodesBy: " + this.sortNodesBy);
        LOGGER.finest("sortNodesOrder: " + this.sortNodesOrder);
    }

    private void generateDataForView(int n) {
        if (this.threadCCTContainers[n] == null) {
            MethodIdMap methodIdMap = new MethodIdMap(this.instrMethodClassesViews[0], this.nInstrMethods, n);
            int n2 = this.threadCCTContainers[0].length;
            this.threadCCTContainers[n] = new CPUCCTContainer[n2];
            for (int i = 0; i < n2; ++i) {
                this.threadCCTContainers[n][i] = new CPUCCTClassContainer(this.threadCCTContainers[0][i], methodIdMap, n);
            }
            this.rootNode[n] = this.createRootNodeForAllThreads(n);
            this.instrMethodClassesViews[n] = methodIdMap.getInstrClassesOrPackages();
        }
    }

    public static class NoDataAvailableException
    extends Exception {
    }
}

