/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

class LongBuffer {
    private DataInputStream readStream;
    private DataOutputStream writeStream;
    private File backingFile;
    private long[] buffer;
    private boolean useBackingFile;
    private int bufferSize;
    private int readOffset;
    private int longs;

    LongBuffer(int n) {
        this.buffer = new long[n];
    }

    void delete() {
        if (this.backingFile != null) {
            this.backingFile.delete();
        }
    }

    boolean hasData() {
        return this.longs > 0;
    }

    long readLong() throws IOException {
        if (!this.useBackingFile) {
            if (this.readOffset < this.bufferSize) {
                return this.buffer[this.readOffset++];
            }
            return 0L;
        }
        try {
            return this.readStream.readLong();
        }
        catch (EOFException eOFException) {
            return 0L;
        }
    }

    void reset() {
        this.bufferSize = 0;
        this.writeStream = null;
        this.readStream = null;
        this.longs = 0;
        this.useBackingFile = false;
        this.readOffset = 0;
    }

    void startReading() {
        if (this.useBackingFile) {
            try {
                this.writeStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.writeStream = null;
        this.rewind();
    }

    void rewind() {
        this.readOffset = 0;
        if (this.useBackingFile) {
            try {
                if (this.readStream != null) {
                    this.readStream.close();
                }
                this.readStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.backingFile), this.buffer.length * 8));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    void writeLong(long l) throws IOException {
        ++this.longs;
        if (this.bufferSize < this.buffer.length) {
            this.buffer[this.bufferSize++] = l;
            return;
        }
        if (this.backingFile == null) {
            this.backingFile = File.createTempFile("NBProfiler", ".gc");
            this.backingFile.deleteOnExit();
        }
        if (this.writeStream == null) {
            this.writeStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.backingFile), this.buffer.length * 8));
            for (int i = 0; i < this.buffer.length; ++i) {
                this.writeStream.writeLong(this.buffer[i]);
            }
            this.useBackingFile = true;
        }
        this.writeStream.writeLong(l);
    }

    LongBuffer revertBuffer() throws IOException {
        LongBuffer longBuffer = new LongBuffer(this.buffer.length);
        if (this.bufferSize < this.buffer.length) {
            for (int i = 0; i < this.bufferSize; ++i) {
                longBuffer.writeLong(this.buffer[this.bufferSize - 1 - i]);
            }
        } else {
            this.writeStream.flush();
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.backingFile, "r");
            long l = randomAccessFile.length();
            while (l > 0L) {
                randomAccessFile.seek(l -= 8L);
                longBuffer.writeLong(randomAccessFile.readLong());
            }
        }
        longBuffer.startReading();
        return longBuffer;
    }

    int getSize() {
        return this.longs;
    }
}

