/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities.soql;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Mark;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.ObjectMonitor;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.tools.JMap;
import sun.jvm.hotspot.tools.jcore.ClassWriter;
import sun.jvm.hotspot.utilities.ObjectReader;
import sun.jvm.hotspot.utilities.SystemDictionaryHelper;
import sun.jvm.hotspot.utilities.soql.JSJavaArray;
import sun.jvm.hotspot.utilities.soql.JSJavaClass;
import sun.jvm.hotspot.utilities.soql.JSJavaFactory;
import sun.jvm.hotspot.utilities.soql.JSJavaInstance;
import sun.jvm.hotspot.utilities.soql.JSJavaInstanceKlass;
import sun.jvm.hotspot.utilities.soql.JSJavaKlass;
import sun.jvm.hotspot.utilities.soql.JSJavaObject;
import sun.jvm.hotspot.utilities.soql.JSJavaThread;
import sun.jvm.hotspot.utilities.soql.JSJavaVM;
import sun.jvm.hotspot.utilities.soql.MapScriptObject;

public abstract class JSJavaScriptEngine
extends MapScriptObject {
    private BufferedReader inReader;
    protected final boolean debug;
    private boolean quitting;
    private ScriptEngine engine;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public void startConsole() {
        this.start(true);
    }

    public void start() {
        this.start(false);
    }

    public void defineFunction(Object target, Method method) {
        this.putFunction(target, method, false);
    }

    public Object call(String name, Object[] args) {
        Invocable invocable = (Invocable)((Object)this.engine);
        try {
            return invocable.invokeFunction(name, args);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    public Object address(Object[] args) {
        if (args.length != 1) {
            return UNDEFINED;
        }
        Object o = args[0];
        if (o != null && o instanceof JSJavaObject) {
            return ((JSJavaObject)o).getOop().getHandle().toString();
        }
        return UNDEFINED;
    }

    public Object classof(Object[] args) {
        if (args.length != 1) {
            return UNDEFINED;
        }
        Object o = args[0];
        if (o != null) {
            if (o instanceof JSJavaObject) {
                if (o instanceof JSJavaInstance) {
                    return ((JSJavaInstance)o).getJSJavaClass();
                }
                if (o instanceof JSJavaArray) {
                    return ((JSJavaArray)o).getJSJavaClass();
                }
                return UNDEFINED;
            }
            if (o instanceof String) {
                InstanceKlass ik = SystemDictionaryHelper.findInstanceKlass((String)o);
                return this.getJSJavaFactory().newJSJavaKlass(ik).getJSJavaClass();
            }
            return UNDEFINED;
        }
        return UNDEFINED;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object dumpClass(Object[] args) {
        if (args.length == 0) {
            return Boolean.FALSE;
        }
        Object clazz = args[0];
        if (clazz == null) {
            return Boolean.FALSE;
        }
        InstanceKlass ik = null;
        if (clazz instanceof String) {
            String name = (String)clazz;
            if (name.startsWith("0x")) {
                VM vm = VM.getVM();
                Address addr = vm.getDebugger().parseAddress(name);
                Oop oop = vm.getObjectHeap().newOop(addr.addOffsetToAsOopHandle(0L));
                if (!(oop instanceof InstanceKlass)) return Boolean.FALSE;
                ik = (InstanceKlass)oop;
            } else {
                ik = SystemDictionaryHelper.findInstanceKlass((String)clazz);
            }
        } else {
            if (!(clazz instanceof JSJavaClass)) return Boolean.FALSE;
            JSJavaKlass jk = ((JSJavaClass)clazz).getJSJavaKlass();
            if (jk != null && jk instanceof JSJavaInstanceKlass) {
                ik = ((JSJavaInstanceKlass)jk).getInstanceKlass();
            }
        }
        if (ik == null) {
            return Boolean.FALSE;
        }
        StringBuffer buf = new StringBuffer();
        if (args.length > 1) {
            buf.append(args[1].toString());
        } else {
            buf.append('.');
        }
        buf.append(File.separatorChar);
        buf.append(ik.getName().asString().replace('/', File.separatorChar));
        buf.append(".class");
        String fileName = buf.toString();
        File file = new File(fileName);
        try {
            int index = fileName.lastIndexOf(File.separatorChar);
            File dir = new File(fileName.substring(0, index));
            dir.mkdirs();
            FileOutputStream fos = new FileOutputStream(file);
            ClassWriter cw = new ClassWriter(ik, fos);
            cw.write();
            fos.close();
            return Boolean.TRUE;
        }
        catch (IOException exp) {
            this.printError(exp.toString(), exp);
            return Boolean.FALSE;
        }
    }

    public Object dumpHeap(Object[] args) {
        String fileName = "heap.bin";
        if (args.length > 0) {
            fileName = args[0].toString();
        }
        return new JMap().writeHeapHprofBin(fileName) ? Boolean.TRUE : Boolean.FALSE;
    }

    public void help(Object[] args) {
        this.println("Function/Variable        Description");
        this.println("=================        ===========");
        this.println("address(jobject)         returns the address of the Java object");
        this.println("classof(jobject)         returns the class object of the Java object");
        this.println("dumpClass(jclass,[dir])  writes .class for the given Java Class");
        this.println("dumpHeap([file])         writes heap in hprof binary format");
        this.println("help()                   prints this help message");
        this.println("identityHash(jobject)    returns the hashCode of the Java object");
        this.println("mirror(jobject)          returns a local mirror of the Java object");
        this.println("load([file1, file2,...]) loads JavaScript file(s). With no files, reads <stdin>");
        this.println("object(string)           converts a string address into Java object");
        this.println("owner(jobject)           returns the owner thread of this monitor or null");
        this.println("sizeof(jobject)          returns the size of Java object in bytes");
        this.println("staticof(jclass, field)  returns a static field of the given Java class");
        this.println("read([prompt])           reads a single line from standard input");
        this.println("quit()                   quits the interactive load call");
        this.println("jvm                      the target jvm that is being debugged");
    }

    public Object identityHash(Object[] args) {
        if (args.length != 1) {
            return UNDEFINED;
        }
        Object o = args[0];
        if (o != null && o instanceof JSJavaObject) {
            return new Long(((JSJavaObject)o).getOop().identityHash());
        }
        return UNDEFINED;
    }

    public void load(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            this.processSource(args[i].toString());
        }
    }

    public Object mirror(Object[] args) {
        Object o = args[0];
        if (o != null && o instanceof JSJavaObject) {
            Object res;
            block3: {
                Oop oop = ((JSJavaObject)o).getOop();
                res = null;
                try {
                    res = oop instanceof InstanceKlass ? this.getObjectReader().readClass((InstanceKlass)oop) : this.getObjectReader().readObject(oop);
                }
                catch (Exception e) {
                    if (!this.debug) break block3;
                    e.printStackTrace(this.getErrorStream());
                }
            }
            return res != null ? res : UNDEFINED;
        }
        return UNDEFINED;
    }

    public Object owner(Object[] args) {
        Object o = args[0];
        if (o != null && o instanceof JSJavaObject) {
            return this.getOwningThread((JSJavaObject)o);
        }
        return UNDEFINED;
    }

    public Object object(Object[] args) {
        Object o = args[0];
        if (o != null && o instanceof String) {
            VM vm = VM.getVM();
            Address addr = vm.getDebugger().parseAddress((String)o);
            Oop oop = vm.getObjectHeap().newOop(addr.addOffsetToAsOopHandle(0L));
            return this.getJSJavaFactory().newJSJavaObject(oop);
        }
        return UNDEFINED;
    }

    public Object sizeof(Object[] args) {
        if (args.length != 1) {
            return UNDEFINED;
        }
        Object o = args[0];
        if (o != null && o instanceof JSJavaObject) {
            return new Long(((JSJavaObject)o).getOop().getObjectSize());
        }
        return UNDEFINED;
    }

    public Object staticof(Object[] args) {
        Object classname = args[0];
        Object fieldname = args[1];
        if (fieldname == null || classname == null || !(fieldname instanceof String)) {
            return UNDEFINED;
        }
        InstanceKlass ik = null;
        if (classname instanceof JSJavaClass) {
            JSJavaClass jclass = (JSJavaClass)classname;
            JSJavaKlass jk = jclass.getJSJavaKlass();
            if (jk != null && jk instanceof JSJavaInstanceKlass) {
                ik = ((JSJavaInstanceKlass)jk).getInstanceKlass();
            }
        } else if (classname instanceof String) {
            ik = SystemDictionaryHelper.findInstanceKlass((String)classname);
        } else {
            return UNDEFINED;
        }
        if (ik == null) {
            return UNDEFINED;
        }
        JSJavaFactory factory = this.getJSJavaFactory();
        try {
            return ((JSJavaInstanceKlass)factory.newJSJavaKlass(ik)).getStaticFieldValue((String)fieldname);
        }
        catch (NoSuchFieldException e) {
            return UNDEFINED;
        }
    }

    public Object read(Object[] args) {
        BufferedReader in = this.getInputReader();
        if (in == null) {
            return null;
        }
        if (args.length > 0) {
            this.print(args[0].toString());
            this.print(":");
        }
        try {
            return in.readLine();
        }
        catch (IOException exp) {
            exp.printStackTrace();
            throw new RuntimeException(exp);
        }
    }

    public void quit(Object[] args) {
        this.quit();
    }

    public void writeln(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            this.print(args[i].toString());
            this.print(" ");
        }
        this.println("");
    }

    public void write(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            this.print(args[i].toString());
            this.print(" ");
        }
    }

    protected void start(boolean console) {
        PrintStream err;
        ScriptContext context = this.engine.getContext();
        PrintStream out = this.getOutputStream();
        if (out != null) {
            context.setWriter(new PrintWriter(out));
        }
        if ((err = this.getErrorStream()) != null) {
            context.setErrorWriter(new PrintWriter(err));
        }
        this.loadInitFile();
        this.loadUserInitFile();
        JSJavaFactory fac = this.getJSJavaFactory();
        JSJavaVM jvm = fac != null ? fac.newJSJavaVM() : null;
        this.call("main", new Object[]{this, jvm});
        if (console) {
            this.processSource(null);
        }
    }

    protected JSJavaScriptEngine(boolean debug) {
        this.debug = debug;
        ScriptEngineManager manager = new ScriptEngineManager();
        this.engine = manager.getEngineByName("javascript");
        if (this.engine == null) {
            throw new RuntimeException("can't load JavaScript engine");
        }
        Method[] methods = this.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] argTypes;
            Method m = methods[i];
            if (!Modifier.isPublic(m.getModifiers()) || (argTypes = m.getParameterTypes()).length != 1 || argTypes[0] != (array$Ljava$lang$Object == null ? JSJavaScriptEngine.class$("[Ljava.lang.Object;") : array$Ljava$lang$Object)) continue;
            this.putFunction(this, m);
        }
    }

    protected JSJavaScriptEngine() {
        this(false);
    }

    protected abstract ObjectReader getObjectReader();

    protected abstract JSJavaFactory getJSJavaFactory();

    protected void printPrompt(String str) {
        System.err.print(str);
        System.err.flush();
    }

    protected void loadInitFile() {
        InputStream is = JSJavaScriptEngine.class.getResourceAsStream("sa.js");
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        this.evalReader(reader, "sa.js");
    }

    protected void loadUserInitFile() {
        File initFile = new File(this.getUserInitFileDir(), this.getUserInitFileName());
        if (initFile.exists() && initFile.isFile()) {
            this.processSource(initFile.getAbsolutePath());
        }
    }

    protected String getUserInitFileDir() {
        return System.getProperty("user.home");
    }

    protected String getUserInitFileName() {
        return "jsdb.js";
    }

    protected BufferedReader getInputReader() {
        if (this.inReader == null) {
            this.inReader = new BufferedReader(new InputStreamReader(System.in));
        }
        return this.inReader;
    }

    protected PrintStream getOutputStream() {
        return System.out;
    }

    protected PrintStream getErrorStream() {
        return System.err;
    }

    protected void print(String name) {
        this.getOutputStream().print(name);
    }

    protected void println(String name) {
        this.getOutputStream().println(name);
    }

    protected void printError(String message) {
        this.printError(message, null);
    }

    protected void printError(String message, Exception exp) {
        this.getErrorStream().println(message);
        if (exp != null && this.debug) {
            exp.printStackTrace(this.getErrorStream());
        }
    }

    protected boolean isQuitting() {
        return this.quitting;
    }

    protected void quit() {
        this.quitting = true;
    }

    protected ScriptEngine getScriptEngine() {
        return this.engine;
    }

    private JSJavaThread getOwningThread(JSJavaObject jo) {
        Oop oop = jo.getOop();
        Mark mark = oop.getMark();
        ObjectMonitor mon = null;
        Address owner = null;
        JSJavaThread owningThread = null;
        if (!mark.hasMonitor()) {
            if (mark.hasLocker()) {
                owner = mark.locker().getAddress();
            }
        } else {
            mon = mark.monitor();
            owner = mon.owner();
        }
        if (owner != null) {
            JSJavaFactory factory = this.getJSJavaFactory();
            owningThread = factory.newJSJavaThread(VM.getVM().getThreads().owningThreadFromMonitor(owner));
        }
        return owningThread;
    }

    private void processSource(String filename) {
        if (filename == null) {
            BufferedReader in = this.getInputReader();
            String sourceName = "<stdin>";
            int lineno = 0;
            boolean hitEOF = false;
            do {
                int startline = lineno++;
                this.printPrompt("jsdb> ");
                Object source = this.read(EMPTY_ARRAY);
                if (source == null) {
                    hitEOF = true;
                    break;
                }
                Object result = this.evalString(source.toString(), sourceName, startline);
                if (result == null) continue;
                this.printError(result.toString());
            } while (!this.isQuitting() && !hitEOF);
        } else {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new FileReader(filename));
                this.evalReader(in, filename);
            }
            catch (FileNotFoundException ex) {
                this.println("File '" + filename + "' not found");
                throw new RuntimeException(ex);
            }
        }
    }

    protected Object evalString(String source, String filename, int lineNum) {
        try {
            this.engine.put("javax.script.filename", filename);
            return this.engine.eval(source);
        }
        catch (ScriptException sexp) {
            this.printError(sexp.toString(), sexp);
        }
        catch (Exception exp) {
            this.printError(exp.toString(), exp);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object evalReader(Reader in, String filename) {
        try {
            this.engine.put("javax.script.filename", filename);
            Object object = this.engine.eval(in);
            return object;
        }
        catch (ScriptException sexp) {
            System.err.println(sexp);
            this.printError(sexp.toString(), sexp);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ioe) {
                this.printError(ioe.toString(), ioe);
            }
        }
        return null;
    }
}

