/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.BytecodeStream;
import sun.jvm.hotspot.interpreter.BytecodeWideable;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.utilities.Assert;

public class BytecodeIinc
extends BytecodeWideable {
    BytecodeIinc(Method method, int bci) {
        super(method, bci);
    }

    public int getIncrement() {
        return this.isWide() ? this.javaShortAt(3) : (short)this.javaByteAt(2);
    }

    public void verify() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isValid(), "check iinc");
        }
    }

    public boolean isValid() {
        return this.javaCode() == 132;
    }

    public static BytecodeIinc at(Method method, int bci) {
        BytecodeIinc b = new BytecodeIinc(method, bci);
        if (Assert.ASSERTS_ENABLED) {
            b.verify();
        }
        return b;
    }

    public static BytecodeIinc atCheck(Method method, int bci) {
        BytecodeIinc b = new BytecodeIinc(method, bci);
        return b.isValid() ? b : null;
    }

    public static BytecodeIinc at(BytecodeStream bcs) {
        return new BytecodeIinc(bcs.method(), bcs.bci());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("iinc");
        buf.append(" ");
        buf.append('#');
        buf.append(Integer.toString(this.getLocalVarIndex()));
        buf.append(" by ");
        buf.append(Integer.toString(this.getIncrement()));
        return buf.toString();
    }
}

