/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.remote;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.ThreadContext;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.remote.RemoteDebuggerClient;

public abstract class RemoteThread
implements ThreadProxy {
    protected RemoteDebuggerClient debugger;
    protected Address addr;
    protected long id;

    public RemoteThread(RemoteDebuggerClient debugger, Address addr) {
        this.debugger = debugger;
        this.addr = addr;
        this.id = -1L;
    }

    public RemoteThread(RemoteDebuggerClient debugger, long id) {
        this.debugger = debugger;
        this.addr = null;
        this.id = id;
    }

    public boolean canSetContext() throws DebuggerException {
        return false;
    }

    public void setContext(ThreadContext context) throws IllegalThreadStateException, DebuggerException {
        throw new DebuggerException("Unimplemented");
    }

    public boolean equals(Object o) {
        boolean isAddress;
        if (o == null) {
            return false;
        }
        if (!(o instanceof RemoteThread)) {
            return false;
        }
        RemoteThread other = (RemoteThread)o;
        boolean isOtherAddress = other.addr != null;
        boolean bl = isAddress = this.addr != null;
        if (isAddress) {
            return isOtherAddress ? this.debugger.areThreadsEqual(this.addr, other.addr) : this.debugger.areThreadsEqual(this.addr, other.id);
        }
        return isOtherAddress ? this.debugger.areThreadsEqual(this.id, other.addr) : this.debugger.areThreadsEqual(this.id, other.id);
    }

    public int hashCode() {
        return this.addr != null ? this.debugger.getThreadHashCode(this.addr) : this.debugger.getThreadHashCode(this.id);
    }

    public String toString() {
        return "t@ " + this.hashCode();
    }
}

