/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.x86;

import sun.jvm.hotspot.asm.Immediate;
import sun.jvm.hotspot.asm.ImmediateOrRegister;
import sun.jvm.hotspot.asm.MoveInstruction;
import sun.jvm.hotspot.asm.RTLOperations;
import sun.jvm.hotspot.asm.Register;
import sun.jvm.hotspot.asm.SymbolFinder;
import sun.jvm.hotspot.asm.x86.X86Instruction;
import sun.jvm.hotspot.asm.x86.X86Register;

public class X86MoveInstruction
extends X86Instruction
implements MoveInstruction,
RTLOperations {
    private ImmediateOrRegister source;
    private X86Register destination;

    public X86MoveInstruction(String name, X86Register rd, ImmediateOrRegister oSrc, int size, int prefixes) {
        super(name, size, prefixes);
        this.source = oSrc;
        this.destination = rd;
    }

    public String asString(long currentPc, SymbolFinder symFinder) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getPrefixString());
        buf.append(this.getName());
        buf.append(spaces);
        buf.append(this.destination.toString());
        buf.append(comma);
        buf.append(this.getSourceString());
        return buf.toString();
    }

    protected String getSourceString() {
        StringBuffer buf = new StringBuffer();
        if (this.source instanceof Register) {
            buf.append(this.source.toString());
        } else {
            Number number = ((Immediate)this.source).getNumber();
            buf.append("0x");
            buf.append(Integer.toHexString(number.intValue()));
        }
        return buf.toString();
    }

    public ImmediateOrRegister getMoveSource() {
        return this.source;
    }

    public Register getMoveDestination() {
        return this.destination;
    }

    public boolean isConditional() {
        return false;
    }

    public boolean isMove() {
        return true;
    }
}

