/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.x86;

import sun.jvm.hotspot.asm.ArithmeticInstruction;
import sun.jvm.hotspot.asm.Operand;
import sun.jvm.hotspot.asm.SymbolFinder;
import sun.jvm.hotspot.asm.x86.X86Instruction;

public class X86ArithmeticInstruction
extends X86Instruction
implements ArithmeticInstruction {
    private final int operation;
    private final Operand operand1;
    private final Operand operand2;
    private final Operand operand3;
    private final String description;

    public X86ArithmeticInstruction(String name, int operation, Operand op1, Operand op2, int size, int prefixes) {
        super(name, size, prefixes);
        this.operation = operation;
        this.operand1 = op1;
        this.operand2 = op2;
        this.operand3 = null;
        this.description = this.initDescription();
    }

    public X86ArithmeticInstruction(String name, int operation, Operand op1, Operand op2, Operand op3, int size, int prefixes) {
        super(name, size, prefixes);
        this.operation = operation;
        this.operand1 = op1;
        this.operand2 = op2;
        this.operand3 = op3;
        this.description = this.initDescription();
    }

    protected String initDescription() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getPrefixString());
        buf.append(this.getName());
        buf.append(spaces);
        if (this.operand1 != null) {
            buf.append(this.getOperandAsString(this.operand1));
        }
        if (this.operand2 != null) {
            buf.append(comma);
            buf.append(this.getOperandAsString(this.operand2));
        }
        if (this.operand3 != null) {
            buf.append(comma);
            buf.append(this.getOperandAsString(this.operand3));
        }
        return buf.toString();
    }

    public String asString(long currentPc, SymbolFinder symFinder) {
        return this.description;
    }

    public Operand getArithmeticDestination() {
        return this.operand1;
    }

    public Operand getOperand1() {
        return this.operand1;
    }

    public Operand getOperand2() {
        return this.operand2;
    }

    public Operand getOperand3() {
        return this.operand3;
    }

    public Operand[] getArithmeticSources() {
        return new Operand[]{this.operand1, this.operand2, this.operand3};
    }

    public int getOperation() {
        return this.operation;
    }

    public boolean isArithmetic() {
        return true;
    }
}

