/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Immediate;
import sun.jvm.hotspot.asm.ImmediateOrRegister;
import sun.jvm.hotspot.asm.SymbolFinder;
import sun.jvm.hotspot.asm.sparc.SPARCInstruction;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;

public abstract class SPARCFormat3AInstruction
extends SPARCInstruction {
    protected final int opcode;
    protected final SPARCRegister rs1;
    protected final ImmediateOrRegister operand2;
    protected final SPARCRegister rd;

    public SPARCFormat3AInstruction(String name, int opcode, SPARCRegister rs1, ImmediateOrRegister operand2, SPARCRegister rd) {
        super(name);
        this.opcode = opcode;
        this.rs1 = rs1;
        this.operand2 = operand2;
        this.rd = rd;
    }

    protected String getOperand2String() {
        StringBuffer buf = new StringBuffer();
        if (this.operand2.isRegister()) {
            buf.append(this.operand2.toString());
        } else {
            Number number = ((Immediate)this.operand2).getNumber();
            buf.append("0x");
            buf.append(Integer.toHexString(number.intValue()));
        }
        return buf.toString();
    }

    protected String getDescription() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName());
        buf.append(spaces);
        buf.append(this.rs1.toString());
        buf.append(comma);
        buf.append(this.getOperand2String());
        buf.append(comma);
        buf.append(this.rd.toString());
        return buf.toString();
    }

    public String asString(long currentPc, SymbolFinder symFinder) {
        return this.getDescription();
    }

    public int getOpcode() {
        return this.opcode;
    }

    public SPARCRegister getDestinationRegister() {
        return this.rd;
    }

    public ImmediateOrRegister getOperand2() {
        return this.operand2;
    }

    public SPARCRegister getSourceRegister1() {
        return this.rs1;
    }
}

