/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDevice;
import com.sun.media.sound.AutoConnectSequencer;
import com.sun.media.sound.EventDispatcher;
import com.sun.media.sound.FastShortMessage;
import com.sun.media.sound.JSSecurityManager;
import com.sun.media.sound.MidiUtils;
import com.sun.media.sound.MixerSequencer;
import com.sun.media.sound.ReferenceCountingDevice;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.ControllerEventListener;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Track;
import javax.sound.midi.Transmitter;

class RealTimeSequencer
extends AbstractMidiDevice
implements Sequencer,
AutoConnectSequencer {
    private static final boolean DEBUG_PUMP = false;
    private static final boolean DEBUG_PUMP_ALL = false;
    private static final boolean RMF = !JSSecurityManager.useNewAudioEngine();
    private static final EventDispatcher eventDispatcher;
    static final RealTimeSequencerInfo info;
    private static Sequencer.SyncMode[] masterSyncModes;
    private static Sequencer.SyncMode[] slaveSyncModes;
    private static Sequencer.SyncMode masterSyncMode;
    private static Sequencer.SyncMode slaveSyncMode;
    private Sequence sequence = null;
    private double cacheTempoMPQ = -1.0;
    private float cacheTempoFactor = -1.0f;
    private boolean[] trackMuted = null;
    private boolean[] trackSolo = null;
    private MidiUtils.TempoCache tempoCache = new MidiUtils.TempoCache();
    private boolean running = false;
    private PlayThread playThread;
    private boolean recording = false;
    private List recordingTracks = new ArrayList();
    private long loopStart = 0L;
    private long loopEnd = -1L;
    private int loopCount = 0;
    private ArrayList metaEventListeners = new ArrayList();
    private ArrayList controllerEventListeners = new ArrayList();
    private MixerSequencer seqBridge = null;
    private boolean autoConnect = false;
    private boolean doAutoConnectAtNextOpen = false;
    Receiver autoConnectedReceiver = null;

    protected RealTimeSequencer() throws MidiUnavailableException {
        super(info);
    }

    public synchronized void setSequence(Sequence sequence) throws InvalidMidiDataException {
        if (sequence != this.sequence) {
            if (this.sequence != null && sequence == null) {
                this.setCaches();
                this.stop();
                this.trackMuted = null;
                this.trackSolo = null;
                this.loopStart = 0L;
                this.loopEnd = -1L;
                this.loopCount = 0;
                if (this.getDataPump() != null) {
                    this.getDataPump().setTickPos(0L);
                    this.getDataPump().resetLoopCount();
                }
            }
            if (this.playThread != null) {
                this.playThread.setSequence(sequence);
            }
            this.sequence = sequence;
            if (sequence != null) {
                this.tempoCache.refresh(sequence);
                this.setTickPosition(0L);
                this.propagateCaches();
            }
        } else if (sequence != null) {
            this.tempoCache.refresh(sequence);
            if (this.playThread != null) {
                this.playThread.setSequence(sequence);
            }
        }
        if (RMF) {
            if (this.seqBridge != null) {
                this.seqBridge.close();
                this.seqBridge = null;
            }
            if (this.isOpen() && sequence != null && this.playThread == null) {
                try {
                    this.implOpen();
                }
                catch (MidiUnavailableException midiUnavailableException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setSequence(InputStream inputStream) throws IOException, InvalidMidiDataException {
        Object object;
        if (inputStream == null) {
            this.setSequence((Sequence)null);
            return;
        }
        if (RMF) {
            object = MidiSystem.getMidiFileFormat(inputStream);
            int n = ((MidiFileFormat)object).getType();
            int n2 = ((MidiFileFormat)object).getResolution();
            if (n2 == -1) {
                int n3;
                if (this.seqBridge == null) {
                    try {
                        this.seqBridge = new MixerSequencer();
                        if (this.isOpen()) {
                            this.seqBridge.open();
                        }
                    }
                    catch (MidiUnavailableException midiUnavailableException) {
                        throw new InvalidMidiDataException(midiUnavailableException.getMessage());
                    }
                }
                this.seqBridge.setSequence(inputStream);
                this.seqBridge.setTempoFactor(this.getTempoFactor());
                ArrayList arrayList = this.metaEventListeners;
                synchronized (arrayList) {
                    for (n3 = 0; n3 < this.metaEventListeners.size(); ++n3) {
                        this.seqBridge.addMetaEventListener((MetaEventListener)this.metaEventListeners.get(n3));
                    }
                }
                arrayList = this.controllerEventListeners;
                synchronized (arrayList) {
                    for (n3 = 0; n3 < this.controllerEventListeners.size(); ++n3) {
                        ControllerListElement controllerListElement = (ControllerListElement)this.controllerEventListeners.get(n3);
                        this.seqBridge.addControllerEventListener(controllerListElement.listener, controllerListElement.controllers);
                    }
                }
                this.sequence = null;
                return;
            }
            if (this.seqBridge != null) {
                this.seqBridge.close();
                this.seqBridge = null;
            }
        }
        object = MidiSystem.getSequence(inputStream);
        this.setSequence((Sequence)object);
    }

    public Sequence getSequence() {
        if (RMF && this.seqBridge != null) {
            return this.seqBridge.getSequence();
        }
        return this.sequence;
    }

    public synchronized void start() {
        if (RMF && this.seqBridge != null) {
            this.seqBridge.start();
            return;
        }
        if (!this.isOpen()) {
            throw new IllegalStateException("sequencer not open");
        }
        if (this.sequence == null) {
            throw new IllegalStateException("sequence not set");
        }
        if (this.running) {
            return;
        }
        this.implStart();
    }

    public synchronized void stop() {
        if (RMF && this.seqBridge != null) {
            this.seqBridge.stop();
            return;
        }
        if (!this.isOpen()) {
            throw new IllegalStateException("sequencer not open");
        }
        this.stopRecording();
        if (!this.running) {
            return;
        }
        this.implStop();
    }

    public boolean isRunning() {
        if (RMF && this.seqBridge != null) {
            return this.seqBridge.isRunning();
        }
        return this.running;
    }

    public void startRecording() {
        if (RMF && this.seqBridge != null) {
            this.seqBridge.startRecording();
            return;
        }
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
        this.start();
        this.recording = true;
    }

    public void stopRecording() {
        if (RMF && this.seqBridge != null) {
            this.seqBridge.stopRecording();
            return;
        }
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
        this.recording = false;
    }

    public boolean isRecording() {
        if (RMF && this.seqBridge != null) {
            return this.seqBridge.isRecording();
        }
        return this.recording;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordEnable(Track track, int n) {
        if (RMF && this.seqBridge != null) {
            this.seqBridge.recordEnable(track, n);
            return;
        }
        if (!this.findTrack(track)) {
            throw new IllegalArgumentException("Track does not exist in the current sequence");
        }
        List list = this.recordingTracks;
        synchronized (list) {
            RecordingTrack recordingTrack = RecordingTrack.get(this.recordingTracks, track);
            if (recordingTrack != null) {
                recordingTrack.channel = n;
            } else {
                this.recordingTracks.add(new RecordingTrack(track, n));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordDisable(Track track) {
        if (RMF && this.seqBridge != null) {
            this.seqBridge.recordDisable(track);
            return;
        }
        List list = this.recordingTracks;
        synchronized (list) {
            RecordingTrack recordingTrack = RecordingTrack.get(this.recordingTracks, track);
            if (recordingTrack != null) {
                this.recordingTracks.remove(recordingTrack);
            }
        }
    }

    private boolean findTrack(Track track) {
        boolean bl = false;
        if (this.sequence != null) {
            Track[] trackArray = this.sequence.getTracks();
            for (int i = 0; i < trackArray.length; ++i) {
                if (track != trackArray[i]) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public float getTempoInBPM() {
        if (RMF && this.seqBridge != null) {
            return this.seqBridge.getTempoInBPM();
        }
        return (float)MidiUtils.convertTempo(this.getTempoInMPQ());
    }

    public void setTempoInBPM(float f) {
        if (RMF && this.seqBridge != null) {
            this.seqBridge.setTempoInBPM(f);
            return;
        }
        if (f <= 0.0f) {
            f = 1.0f;
        }
        this.setTempoInMPQ((float)MidiUtils.convertTempo(f));
    }

    public float getTempoInMPQ() {
        if (RMF && this.seqBridge != null) {
            return this.seqBridge.getTempoInMPQ();
        }
        if (this.needCaching()) {
            if (this.cacheTempoMPQ != -1.0) {
                return (float)this.cacheTempoMPQ;
            }
            if (this.sequence != null) {
                return this.tempoCache.getTempoMPQAt(this.getTickPosition());
            }
            return 500000.0f;
        }
        return this.getDataPump().getTempoMPQ();
    }

    public void setTempoInMPQ(float f) {
        if (RMF && this.seqBridge != null) {
            this.seqBridge.setTempoInMPQ(f);
            return;
        }
        if (f <= 0.0f) {
            f = 1.0f;
        }
        if (this.needCaching()) {
            this.cacheTempoMPQ = f;
        } else {
            this.getDataPump().setTempoMPQ(f);
            this.cacheTempoMPQ = -1.0;
        }
    }

    public void setTempoFactor(float f) {
        if (RMF && this.seqBridge != null) {
            this.seqBridge.setTempoFactor(f);
            return;
        }
        if (f <= 0.0f) {
            return;
        }
        if (this.needCaching()) {
            this.cacheTempoFactor = f;
        } else {
            this.getDataPump().setTempoFactor(f);
            this.cacheTempoFactor = -1.0f;
        }
    }

    public float getTempoFactor() {
        if (RMF && this.seqBridge != null) {
            return this.seqBridge.getTempoFactor();
        }
        if (this.needCaching()) {
            if (this.cacheTempoFactor != -1.0f) {
                return this.cacheTempoFactor;
            }
            return 1.0f;
        }
        return this.getDataPump().getTempoFactor();
    }

    public long getTickLength() {
        if (RMF && this.seqBridge != null) {
            return this.seqBridge.getTickLength();
        }
        if (this.sequence == null) {
            return 0L;
        }
        return this.sequence.getTickLength();
    }

    public synchronized long getTickPosition() {
        if (RMF && this.seqBridge != null) {
            return this.seqBridge.getTickPosition();
        }
        if (this.getDataPump() == null || this.sequence == null) {
            return 0L;
        }
        return this.getDataPump().getTickPos();
    }

    public synchronized void setTickPosition(long l) {
        if (RMF && this.seqBridge != null) {
            this.seqBridge.setTickPosition(l);
            return;
        }
        if (l < 0L) {
            return;
        }
        if (this.getDataPump() == null) {
            if (l != 0L) {
                // empty if block
            }
        } else if (this.sequence == null) {
            if (l != 0L) {
                // empty if block
            }
        } else {
            this.getDataPump().setTickPos(l);
        }
    }

    public long getMicrosecondLength() {
        if (RMF && this.seqBridge != null) {
            return this.seqBridge.getMicrosecondLength();
        }
        if (this.sequence == null) {
            return 0L;
        }
        return this.sequence.getMicrosecondLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMicrosecondPosition() {
        if (RMF && this.seqBridge != null) {
            return this.seqBridge.getMicrosecondPosition();
        }
        if (this.getDataPump() == null || this.sequence == null) {
            return 0L;
        }
        MidiUtils.TempoCache tempoCache = this.tempoCache;
        synchronized (tempoCache) {
            return MidiUtils.tick2microsecond(this.sequence, this.getDataPump().getTickPos(), this.tempoCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMicrosecondPosition(long l) {
        if (RMF && this.seqBridge != null) {
            this.seqBridge.setMicrosecondPosition(l);
            return;
        }
        if (l < 0L) {
            return;
        }
        if (this.getDataPump() == null) {
            if (l != 0L) {
                // empty if block
            }
        } else if (this.sequence == null) {
            if (l != 0L) {
                // empty if block
            }
        } else {
            MidiUtils.TempoCache tempoCache = this.tempoCache;
            synchronized (tempoCache) {
                this.setTickPosition(MidiUtils.microsecond2tick(this.sequence, l, this.tempoCache));
            }
        }
    }

    public void setMasterSyncMode(Sequencer.SyncMode syncMode) {
        if (RMF && this.seqBridge != null) {
            this.seqBridge.setMasterSyncMode(syncMode);
            return;
        }
    }

    public Sequencer.SyncMode getMasterSyncMode() {
        if (RMF && this.seqBridge != null) {
            return this.seqBridge.getMasterSyncMode();
        }
        return masterSyncMode;
    }

    public Sequencer.SyncMode[] getMasterSyncModes() {
        if (RMF && this.seqBridge != null) {
            return this.seqBridge.getMasterSyncModes();
        }
        Sequencer.SyncMode[] syncModeArray = new Sequencer.SyncMode[masterSyncModes.length];
        System.arraycopy(masterSyncModes, 0, syncModeArray, 0, masterSyncModes.length);
        return syncModeArray;
    }

    public void setSlaveSyncMode(Sequencer.SyncMode syncMode) {
        if (RMF && this.seqBridge != null) {
            this.seqBridge.setSlaveSyncMode(syncMode);
            return;
        }
    }

    public Sequencer.SyncMode getSlaveSyncMode() {
        if (RMF && this.seqBridge != null) {
            return this.seqBridge.getSlaveSyncMode();
        }
        return slaveSyncMode;
    }

    public Sequencer.SyncMode[] getSlaveSyncModes() {
        if (RMF && this.seqBridge != null) {
            return this.seqBridge.getSlaveSyncModes();
        }
        Sequencer.SyncMode[] syncModeArray = new Sequencer.SyncMode[slaveSyncModes.length];
        System.arraycopy(slaveSyncModes, 0, syncModeArray, 0, slaveSyncModes.length);
        return syncModeArray;
    }

    protected int getTrackCount() {
        Sequence sequence = this.getSequence();
        if (sequence != null) {
            return this.sequence.getTracks().length;
        }
        return 0;
    }

    public synchronized void setTrackMute(int n, boolean bl) {
        if (RMF && this.seqBridge != null) {
            this.seqBridge.setTrackMute(n, bl);
            return;
        }
        int n2 = this.getTrackCount();
        if (n < 0 || n >= this.getTrackCount()) {
            return;
        }
        this.trackMuted = RealTimeSequencer.ensureBoolArraySize(this.trackMuted, n2);
        this.trackMuted[n] = bl;
        if (this.getDataPump() != null) {
            this.getDataPump().muteSoloChanged();
        }
    }

    public synchronized boolean getTrackMute(int n) {
        if (RMF && this.seqBridge != null) {
            return this.seqBridge.getTrackMute(n);
        }
        if (n < 0 || n >= this.getTrackCount()) {
            return false;
        }
        if (this.trackMuted == null || this.trackMuted.length <= n) {
            return false;
        }
        return this.trackMuted[n];
    }

    public synchronized void setTrackSolo(int n, boolean bl) {
        if (RMF && this.seqBridge != null) {
            this.seqBridge.setTrackSolo(n, bl);
            return;
        }
        int n2 = this.getTrackCount();
        if (n < 0 || n >= this.getTrackCount()) {
            return;
        }
        this.trackSolo = RealTimeSequencer.ensureBoolArraySize(this.trackSolo, n2);
        this.trackSolo[n] = bl;
        if (this.getDataPump() != null) {
            this.getDataPump().muteSoloChanged();
        }
    }

    public synchronized boolean getTrackSolo(int n) {
        if (RMF && this.seqBridge != null) {
            return this.seqBridge.getTrackSolo(n);
        }
        if (n < 0 || n >= this.getTrackCount()) {
            return false;
        }
        if (this.trackSolo == null || this.trackSolo.length <= n) {
            return false;
        }
        return this.trackSolo[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMetaEventListener(MetaEventListener metaEventListener) {
        if (RMF && this.seqBridge != null) {
            this.seqBridge.addMetaEventListener(metaEventListener);
        }
        ArrayList arrayList = this.metaEventListeners;
        synchronized (arrayList) {
            if (!this.metaEventListeners.contains(metaEventListener)) {
                this.metaEventListeners.add(metaEventListener);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetaEventListener(MetaEventListener metaEventListener) {
        if (RMF && this.seqBridge != null) {
            this.seqBridge.removeMetaEventListener(metaEventListener);
        }
        ArrayList arrayList = this.metaEventListeners;
        synchronized (arrayList) {
            int n = this.metaEventListeners.indexOf(metaEventListener);
            if (n >= 0) {
                this.metaEventListeners.remove(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] addControllerEventListener(ControllerEventListener controllerEventListener, int[] nArray) {
        if (RMF && this.seqBridge != null) {
            this.seqBridge.addControllerEventListener(controllerEventListener, nArray);
        }
        ArrayList arrayList = this.controllerEventListeners;
        synchronized (arrayList) {
            ControllerListElement controllerListElement = null;
            boolean bl = false;
            for (int i = 0; i < this.controllerEventListeners.size(); ++i) {
                controllerListElement = (ControllerListElement)this.controllerEventListeners.get(i);
                if (!controllerListElement.listener.equals(controllerEventListener)) continue;
                controllerListElement.addControllers(nArray);
                bl = true;
                break;
            }
            if (!bl) {
                controllerListElement = new ControllerListElement(controllerEventListener, nArray);
                this.controllerEventListeners.add(controllerListElement);
            }
            return controllerListElement.getControllers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] removeControllerEventListener(ControllerEventListener controllerEventListener, int[] nArray) {
        if (RMF && this.seqBridge != null) {
            this.seqBridge.removeControllerEventListener(controllerEventListener, nArray);
        }
        ArrayList arrayList = this.controllerEventListeners;
        synchronized (arrayList) {
            int n;
            ControllerListElement controllerListElement = null;
            boolean bl = false;
            for (n = 0; n < this.controllerEventListeners.size(); ++n) {
                controllerListElement = (ControllerListElement)this.controllerEventListeners.get(n);
                if (!controllerListElement.listener.equals(controllerEventListener)) continue;
                controllerListElement.removeControllers(nArray);
                bl = true;
                break;
            }
            if (!bl) {
                return new int[0];
            }
            if (nArray == null) {
                n = this.controllerEventListeners.indexOf(controllerListElement);
                if (n >= 0) {
                    this.controllerEventListeners.remove(n);
                }
                return new int[0];
            }
            return controllerListElement.getControllers();
        }
    }

    public void setLoopStartPoint(long l) {
        if (RMF && this.seqBridge != null) {
            this.seqBridge.setLoopStartPoint(l);
            return;
        }
        if (l > this.getTickLength() || this.loopEnd != -1L && l > this.loopEnd || l < 0L) {
            throw new IllegalArgumentException("invalid loop start point: " + l);
        }
        this.loopStart = l;
    }

    public long getLoopStartPoint() {
        if (RMF && this.seqBridge != null) {
            return this.seqBridge.getLoopStartPoint();
        }
        return this.loopStart;
    }

    public void setLoopEndPoint(long l) {
        if (RMF && this.seqBridge != null) {
            this.seqBridge.setLoopEndPoint(l);
            return;
        }
        if (l > this.getTickLength() || this.loopStart > l && l != -1L || l < -1L) {
            throw new IllegalArgumentException("invalid loop end point: " + l);
        }
        this.loopEnd = l;
    }

    public long getLoopEndPoint() {
        if (RMF && this.seqBridge != null) {
            return this.seqBridge.getLoopEndPoint();
        }
        return this.loopEnd;
    }

    public void setLoopCount(int n) {
        if (RMF && this.seqBridge != null) {
            this.seqBridge.setLoopCount(n);
            return;
        }
        if (n != -1 && n < 0) {
            throw new IllegalArgumentException("illegal value for loop count: " + n);
        }
        this.loopCount = n;
        if (this.getDataPump() != null) {
            this.getDataPump().resetLoopCount();
        }
    }

    public int getLoopCount() {
        if (RMF && this.seqBridge != null) {
            return this.seqBridge.getLoopCount();
        }
        return this.loopCount;
    }

    protected void implOpen() throws MidiUnavailableException {
        if (RMF && this.seqBridge != null) {
            this.seqBridge.open();
            return;
        }
        this.playThread = new PlayThread();
        if (this.sequence != null) {
            this.playThread.setSequence(this.sequence);
        }
        this.propagateCaches();
        if (this.doAutoConnectAtNextOpen) {
            this.doAutoConnect();
        }
    }

    private void doAutoConnect() {
        Receiver receiver = null;
        try {
            Synthesizer synthesizer = MidiSystem.getSynthesizer();
            synthesizer.open();
            if (synthesizer instanceof ReferenceCountingDevice) {
                receiver = ((ReferenceCountingDevice)((Object)synthesizer)).getReceiverReferenceCounting();
                if (synthesizer.getClass().toString().contains("com.sun.media.sound.MixerSynth") && synthesizer.getDefaultSoundbank() == null) {
                    receiver = null;
                    synthesizer.close();
                }
            } else {
                receiver = synthesizer.getReceiver();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (receiver == null) {
            try {
                receiver = MidiSystem.getReceiver();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (receiver != null) {
            this.autoConnectedReceiver = receiver;
            try {
                this.getTransmitter().setReceiver(receiver);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private synchronized void propagateCaches() {
        if (this.sequence != null && this.isOpen()) {
            if (this.cacheTempoFactor != -1.0f) {
                this.setTempoFactor(this.cacheTempoFactor);
            }
            if (this.cacheTempoMPQ == -1.0) {
                this.setTempoInMPQ(new MidiUtils.TempoCache(this.sequence).getTempoMPQAt(this.getTickPosition()));
            } else {
                this.setTempoInMPQ((float)this.cacheTempoMPQ);
            }
        }
    }

    private synchronized void setCaches() {
        this.cacheTempoFactor = this.getTempoFactor();
        this.cacheTempoMPQ = this.getTempoInMPQ();
    }

    protected synchronized void implClose() {
        if (RMF && this.seqBridge != null) {
            this.seqBridge.close();
        }
        if (this.playThread != null) {
            this.playThread.close();
            this.playThread = null;
        }
        super.implClose();
        this.sequence = null;
        this.running = false;
        this.cacheTempoMPQ = -1.0;
        this.cacheTempoFactor = -1.0f;
        this.trackMuted = null;
        this.trackSolo = null;
        this.loopStart = 0L;
        this.loopEnd = -1L;
        this.loopCount = 0;
        this.doAutoConnectAtNextOpen = this.autoConnect;
        if (this.autoConnectedReceiver != null) {
            try {
                this.autoConnectedReceiver.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.autoConnectedReceiver = null;
        }
    }

    protected void implStart() {
        if (this.playThread == null) {
            return;
        }
        this.tempoCache.refresh(this.sequence);
        if (!this.running) {
            this.running = true;
            this.playThread.start();
        }
    }

    protected void implStop() {
        if (this.playThread == null) {
            return;
        }
        this.recording = false;
        if (this.running) {
            this.running = false;
            this.playThread.stop();
        }
    }

    protected void sendMetaEvents(MidiMessage midiMessage) {
        if (this.metaEventListeners.size() == 0) {
            return;
        }
        eventDispatcher.sendAudioEvents(midiMessage, this.metaEventListeners);
    }

    protected void sendControllerEvents(MidiMessage midiMessage) {
        int n = this.controllerEventListeners.size();
        if (n == 0) {
            return;
        }
        if (!(midiMessage instanceof ShortMessage)) {
            return;
        }
        ShortMessage shortMessage = (ShortMessage)midiMessage;
        int n2 = shortMessage.getData1();
        ArrayList<ControllerEventListener> arrayList = new ArrayList<ControllerEventListener>();
        block0: for (int i = 0; i < n; ++i) {
            ControllerListElement controllerListElement = (ControllerListElement)this.controllerEventListeners.get(i);
            for (int j = 0; j < controllerListElement.controllers.length; ++j) {
                if (controllerListElement.controllers[j] != n2) continue;
                arrayList.add(controllerListElement.listener);
                continue block0;
            }
        }
        eventDispatcher.sendAudioEvents(midiMessage, arrayList);
    }

    private boolean needCaching() {
        return !this.isOpen() || this.sequence == null || this.playThread == null;
    }

    private DataPump getDataPump() {
        if (this.playThread != null) {
            return this.playThread.getDataPump();
        }
        return null;
    }

    private MidiUtils.TempoCache getTempoCache() {
        return this.tempoCache;
    }

    private static boolean[] ensureBoolArraySize(boolean[] blArray, int n) {
        if (blArray == null) {
            return new boolean[n];
        }
        if (blArray.length < n) {
            boolean[] blArray2 = new boolean[n];
            System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
            return blArray2;
        }
        return blArray;
    }

    protected boolean hasReceivers() {
        return !RMF || this.seqBridge == null;
    }

    protected Receiver createReceiver() throws MidiUnavailableException {
        return new SequencerReceiver();
    }

    protected boolean hasTransmitters() {
        return !RMF || this.seqBridge == null;
    }

    protected Transmitter createTransmitter() throws MidiUnavailableException {
        return new SequencerTransmitter();
    }

    public void setAutoConnect(Receiver receiver) {
        this.autoConnect = receiver != null;
        this.autoConnectedReceiver = receiver;
    }

    static {
        info = new RealTimeSequencerInfo();
        masterSyncModes = new Sequencer.SyncMode[]{Sequencer.SyncMode.INTERNAL_CLOCK};
        slaveSyncModes = new Sequencer.SyncMode[]{Sequencer.SyncMode.NO_SYNC};
        masterSyncMode = Sequencer.SyncMode.INTERNAL_CLOCK;
        slaveSyncMode = Sequencer.SyncMode.NO_SYNC;
        eventDispatcher = new EventDispatcher();
        eventDispatcher.start();
    }

    private class ControllerListElement {
        int[] controllers;
        ControllerEventListener listener;

        private ControllerListElement(ControllerEventListener controllerEventListener, int[] nArray) {
            this.listener = controllerEventListener;
            if (nArray == null) {
                nArray = new int[128];
                for (int i = 0; i < 128; ++i) {
                    nArray[i] = i;
                }
            }
            this.controllers = nArray;
        }

        private void addControllers(int[] nArray) {
            int n;
            int n2;
            if (nArray == null) {
                this.controllers = new int[128];
                for (int i = 0; i < 128; ++i) {
                    this.controllers[i] = i;
                }
                return;
            }
            int[] nArray2 = new int[this.controllers.length + nArray.length];
            for (n2 = 0; n2 < this.controllers.length; ++n2) {
                nArray2[n2] = this.controllers[n2];
            }
            int n3 = this.controllers.length;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                n = 0;
                for (int i = 0; i < this.controllers.length; ++i) {
                    if (nArray[n2] != this.controllers[i]) continue;
                    n = 1;
                    break;
                }
                if (n != 0) continue;
                nArray2[n3++] = nArray[n2];
            }
            int[] nArray3 = new int[n3];
            for (n = 0; n < n3; ++n) {
                nArray3[n] = nArray2[n];
            }
            this.controllers = nArray3;
        }

        private void removeControllers(int[] nArray) {
            if (nArray == null) {
                this.controllers = new int[0];
            } else {
                int n;
                int[] nArray2 = new int[this.controllers.length];
                int n2 = 0;
                for (int i = 0; i < this.controllers.length; ++i) {
                    n = 0;
                    for (int j = 0; j < nArray.length; ++j) {
                        if (this.controllers[i] != nArray[j]) continue;
                        n = 1;
                        break;
                    }
                    if (n != 0) continue;
                    nArray2[n2++] = this.controllers[i];
                }
                int[] nArray3 = new int[n2];
                for (n = 0; n < n2; ++n) {
                    nArray3[n] = nArray2[n];
                }
                this.controllers = nArray3;
            }
        }

        private int[] getControllers() {
            if (this.controllers == null) {
                return null;
            }
            int[] nArray = new int[this.controllers.length];
            for (int i = 0; i < this.controllers.length; ++i) {
                nArray[i] = this.controllers[i];
            }
            return nArray;
        }
    }

    private class DataPump {
        private float currTempo;
        private float tempoFactor;
        private float inverseTempoFactor;
        private long ignoreTempoEventAt;
        private int resolution;
        private float divisionType;
        private long checkPointMillis;
        private long checkPointTick;
        private int[] noteOnCache;
        private Track[] tracks;
        private boolean[] trackDisabled;
        private int[] trackReadPos;
        private long lastTick;
        private boolean needReindex = false;
        private int currLoopCounter = 0;

        DataPump() {
            this.init();
        }

        synchronized void init() {
            this.ignoreTempoEventAt = -1L;
            this.tempoFactor = 1.0f;
            this.inverseTempoFactor = 1.0f;
            this.noteOnCache = new int[128];
            this.tracks = null;
            this.trackDisabled = null;
        }

        synchronized void setTickPos(long l) {
            long l2 = l;
            this.lastTick = l;
            if (RealTimeSequencer.this.running) {
                this.notesOff(false);
            }
            if (RealTimeSequencer.this.running || l > 0L) {
                this.chaseEvents(l2, l);
            } else {
                this.needReindex = true;
            }
            if (!this.hasCachedTempo()) {
                this.setTempoMPQ(RealTimeSequencer.this.getTempoCache().getTempoMPQAt(this.lastTick, this.currTempo));
                this.ignoreTempoEventAt = -1L;
            }
            this.checkPointMillis = 0L;
        }

        long getTickPos() {
            return this.lastTick;
        }

        boolean hasCachedTempo() {
            if (this.ignoreTempoEventAt != this.lastTick) {
                this.ignoreTempoEventAt = -1L;
            }
            return this.ignoreTempoEventAt >= 0L;
        }

        synchronized void setTempoMPQ(float f) {
            if (f > 0.0f && f != this.currTempo) {
                this.ignoreTempoEventAt = this.lastTick;
                this.currTempo = f;
                this.checkPointMillis = 0L;
            }
        }

        float getTempoMPQ() {
            return this.currTempo;
        }

        synchronized void setTempoFactor(float f) {
            if (f > 0.0f && f != this.tempoFactor) {
                this.tempoFactor = f;
                this.inverseTempoFactor = 1.0f / f;
                this.checkPointMillis = 0L;
            }
        }

        float getTempoFactor() {
            return this.tempoFactor;
        }

        synchronized void muteSoloChanged() {
            boolean[] blArray = this.makeDisabledArray();
            if (RealTimeSequencer.this.running) {
                this.applyDisabledTracks(this.trackDisabled, blArray);
            }
            this.trackDisabled = blArray;
        }

        synchronized void setSequence(Sequence sequence) {
            if (sequence == null) {
                this.init();
                return;
            }
            this.tracks = sequence.getTracks();
            this.muteSoloChanged();
            this.resolution = sequence.getResolution();
            this.divisionType = sequence.getDivisionType();
            this.trackReadPos = new int[this.tracks.length];
            this.checkPointMillis = 0L;
            this.needReindex = true;
        }

        synchronized void resetLoopCount() {
            this.currLoopCounter = RealTimeSequencer.this.loopCount;
        }

        void clearNoteOnCache() {
            for (int i = 0; i < 128; ++i) {
                this.noteOnCache[i] = 0;
            }
        }

        void notesOff(boolean bl) {
            int n = 0;
            for (int i = 0; i < 16; ++i) {
                int n2 = 1 << i;
                for (int j = 0; j < 128; ++j) {
                    if ((this.noteOnCache[j] & n2) == 0) continue;
                    int n3 = j;
                    this.noteOnCache[n3] = this.noteOnCache[n3] ^ n2;
                    RealTimeSequencer.this.getTransmitterList().sendMessage(0x90 | i | j << 8, -1L);
                    ++n;
                }
                RealTimeSequencer.this.getTransmitterList().sendMessage(0xB0 | i | 0x7B00, -1L);
                RealTimeSequencer.this.getTransmitterList().sendMessage(0xB0 | i | 0x4000, -1L);
                if (!bl) continue;
                RealTimeSequencer.this.getTransmitterList().sendMessage(0xB0 | i | 0x7900, -1L);
                ++n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean[] makeDisabledArray() {
            int n;
            boolean[] blArray;
            boolean[] blArray2;
            if (this.tracks == null) {
                return null;
            }
            boolean[] blArray3 = new boolean[this.tracks.length];
            RealTimeSequencer realTimeSequencer = RealTimeSequencer.this;
            synchronized (realTimeSequencer) {
                blArray2 = RealTimeSequencer.this.trackMuted;
                blArray = RealTimeSequencer.this.trackSolo;
            }
            boolean bl = false;
            if (blArray != null) {
                for (n = 0; n < blArray.length; ++n) {
                    if (!blArray[n]) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                for (n = 0; n < blArray3.length; ++n) {
                    blArray3[n] = n >= blArray.length || !blArray[n];
                }
            } else {
                for (n = 0; n < blArray3.length; ++n) {
                    blArray3[n] = blArray2 != null && n < blArray2.length && blArray2[n];
                }
            }
            return blArray3;
        }

        private void sendNoteOffIfOn(Track track, long l) {
            int n = track.size();
            int n2 = 0;
            try {
                MidiEvent midiEvent;
                for (int i = 0; i < n && (midiEvent = track.get(i)).getTick() <= l; ++i) {
                    int n3;
                    Object object;
                    MidiMessage midiMessage = midiEvent.getMessage();
                    int n4 = midiMessage.getStatus();
                    int n5 = midiMessage.getLength();
                    if (n5 != 3 || (n4 & 0xF0) != 144) continue;
                    int n6 = -1;
                    if (midiMessage instanceof ShortMessage) {
                        object = (ShortMessage)midiMessage;
                        if (((ShortMessage)object).getData2() > 0) {
                            n6 = ((ShortMessage)object).getData1();
                        }
                    } else {
                        object = midiMessage.getMessage();
                        if ((object[2] & 0x7F) > 0) {
                            n6 = object[1] & 0x7F;
                        }
                    }
                    if (n6 < 0 || (this.noteOnCache[n6] & (n3 = 1 << (n4 & 0xF))) == 0) continue;
                    RealTimeSequencer.this.getTransmitterList().sendMessage(n4 | n6 << 8, -1L);
                    int n7 = n6;
                    this.noteOnCache[n7] = this.noteOnCache[n7] & (0xFFFF ^ n3);
                    ++n2;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void applyDisabledTracks(boolean[] blArray, boolean[] blArray2) {
            byte[][] byArray = null;
            RealTimeSequencer realTimeSequencer = RealTimeSequencer.this;
            synchronized (realTimeSequencer) {
                for (int i = 0; i < blArray2.length; ++i) {
                    if ((blArray == null || i >= blArray.length || !blArray[i]) && blArray2[i]) {
                        if (this.tracks.length <= i) continue;
                        this.sendNoteOffIfOn(this.tracks[i], this.lastTick);
                        continue;
                    }
                    if (blArray == null || i >= blArray.length || !blArray[i] || blArray2[i]) continue;
                    if (byArray == null) {
                        byArray = new byte[128][16];
                    }
                    this.chaseTrackEvents(i, 0L, this.lastTick, true, byArray);
                }
            }
        }

        private void chaseTrackEvents(int n, long l, long l2, boolean bl, byte[][] byArray) {
            int n2;
            int n3;
            int n4;
            int n5;
            if (l > l2) {
                l = 0L;
            }
            byte[] byArray2 = new byte[16];
            for (int i = 0; i < 16; ++i) {
                byArray2[i] = -1;
                for (n5 = 0; n5 < 128; ++n5) {
                    byArray[n5][i] = -1;
                }
            }
            Track track = this.tracks[n];
            n5 = track.size();
            try {
                for (n4 = 0; n4 < n5; ++n4) {
                    Object object;
                    MidiEvent midiEvent = track.get(n4);
                    if (midiEvent.getTick() >= l2) {
                        if (bl && n < this.trackReadPos.length) {
                            this.trackReadPos[n] = n4 > 0 ? n4 - 1 : 0;
                        }
                        break;
                    }
                    MidiMessage midiMessage = midiEvent.getMessage();
                    n3 = midiMessage.getStatus();
                    n2 = midiMessage.getLength();
                    if (n2 == 3 && (n3 & 0xF0) == 176) {
                        if (midiMessage instanceof ShortMessage) {
                            object = (ShortMessage)midiMessage;
                            byArray[((ShortMessage)object).getData1() & 0x7F][n3 & 0xF] = (byte)((ShortMessage)object).getData2();
                        } else {
                            object = midiMessage.getMessage();
                            byArray[object[1] & 0x7F][n3 & 0xF] = (byte)object[2];
                        }
                    }
                    if (n2 != 2 || (n3 & 0xF0) != 192) continue;
                    if (midiMessage instanceof ShortMessage) {
                        object = (ShortMessage)midiMessage;
                        byArray2[n3 & 0xF] = (byte)((ShortMessage)object).getData1();
                        continue;
                    }
                    object = midiMessage.getMessage();
                    byArray2[n3 & 0xF] = (byte)object[1];
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            n4 = 0;
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 128; ++j) {
                    n3 = byArray[j][i];
                    if (n3 < 0) continue;
                    n2 = 0xB0 | i | j << 8 | n3 << 16;
                    RealTimeSequencer.this.getTransmitterList().sendMessage(n2, -1L);
                    ++n4;
                }
                if (byArray2[i] >= 0) {
                    RealTimeSequencer.this.getTransmitterList().sendMessage(0xC0 | i | byArray2[i] << 8, -1L);
                }
                if (byArray2[i] < 0 && l != 0L && l2 != 0L) continue;
                RealTimeSequencer.this.getTransmitterList().sendMessage(0xE0 | i | 0x400000, -1L);
                RealTimeSequencer.this.getTransmitterList().sendMessage(0xB0 | i | 0x4000, -1L);
            }
        }

        synchronized void chaseEvents(long l, long l2) {
            byte[][] byArray = new byte[128][16];
            for (int i = 0; i < this.tracks.length; ++i) {
                if (this.trackDisabled != null && this.trackDisabled.length > i && this.trackDisabled[i]) continue;
                this.chaseTrackEvents(i, l, l2, true, byArray);
            }
        }

        private long getCurrentTimeMillis() {
            return System.nanoTime() / 1000000L;
        }

        private long millis2tick(long l) {
            if (this.divisionType != 0.0f) {
                double d = (double)l * (double)this.tempoFactor * (double)this.divisionType * (double)this.resolution / 1000.0;
                return (long)d;
            }
            return MidiUtils.microsec2ticks(l * 1000L, this.currTempo * this.inverseTempoFactor, this.resolution);
        }

        private long tick2millis(long l) {
            if (this.divisionType != 0.0f) {
                double d = (double)l * 1000.0 / ((double)this.tempoFactor * (double)this.divisionType * (double)this.resolution);
                return (long)d;
            }
            return MidiUtils.ticks2microsec(l, this.currTempo * this.inverseTempoFactor, this.resolution) / 1000L;
        }

        private void ReindexTrack(int n, long l) {
            if (n < this.trackReadPos.length && n < this.tracks.length) {
                this.trackReadPos[n] = MidiUtils.tick2index(this.tracks[n], l);
            }
        }

        private boolean dispatchMessage(int n, MidiEvent midiEvent) {
            boolean bl = false;
            MidiMessage midiMessage = midiEvent.getMessage();
            int n2 = midiMessage.getStatus();
            int n3 = midiMessage.getLength();
            if (n2 == 255 && n3 >= 2) {
                int n4;
                if (n == 0 && (n4 = MidiUtils.getTempoMPQ(midiMessage)) > 0) {
                    if (midiEvent.getTick() != this.ignoreTempoEventAt) {
                        this.setTempoMPQ(n4);
                        bl = true;
                    }
                    this.ignoreTempoEventAt = -1L;
                }
                RealTimeSequencer.this.sendMetaEvents(midiMessage);
            } else {
                RealTimeSequencer.this.getTransmitterList().sendMessage(midiMessage, -1L);
                switch (n2 & 0xF0) {
                    case 128: {
                        int n5;
                        int n6 = n5 = ((ShortMessage)midiMessage).getData1() & 0x7F;
                        this.noteOnCache[n6] = this.noteOnCache[n6] & (0xFFFF ^ 1 << (n2 & 0xF));
                        break;
                    }
                    case 144: {
                        ShortMessage shortMessage = (ShortMessage)midiMessage;
                        int n7 = shortMessage.getData1() & 0x7F;
                        int n8 = shortMessage.getData2() & 0x7F;
                        if (n8 > 0) {
                            int n9 = n7;
                            this.noteOnCache[n9] = this.noteOnCache[n9] | 1 << (n2 & 0xF);
                            break;
                        }
                        int n10 = n7;
                        this.noteOnCache[n10] = this.noteOnCache[n10] & (0xFFFF ^ 1 << (n2 & 0xF));
                        break;
                    }
                    case 176: {
                        RealTimeSequencer.this.sendControllerEvents(midiMessage);
                    }
                }
            }
            return bl;
        }

        synchronized boolean pump() {
            long l = this.lastTick;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            long l2 = this.getCurrentTimeMillis();
            int n = 0;
            do {
                int n2;
                bl = false;
                if (this.needReindex) {
                    if (this.trackReadPos.length < this.tracks.length) {
                        this.trackReadPos = new int[this.tracks.length];
                    }
                    for (n2 = 0; n2 < this.tracks.length; ++n2) {
                        this.ReindexTrack(n2, l);
                    }
                    this.needReindex = false;
                    this.checkPointMillis = 0L;
                }
                if (this.checkPointMillis == 0L) {
                    this.checkPointMillis = l2 = this.getCurrentTimeMillis();
                    this.checkPointTick = l = this.lastTick;
                } else {
                    l = this.checkPointTick + this.millis2tick(l2 - this.checkPointMillis);
                    if (RealTimeSequencer.this.loopEnd != -1L && (RealTimeSequencer.this.loopCount > 0 && this.currLoopCounter > 0 || RealTimeSequencer.this.loopCount == -1) && this.lastTick <= RealTimeSequencer.this.loopEnd && l >= RealTimeSequencer.this.loopEnd) {
                        l = RealTimeSequencer.this.loopEnd - 1L;
                        bl2 = true;
                    }
                    this.lastTick = l;
                }
                n = 0;
                for (n2 = 0; n2 < this.tracks.length; ++n2) {
                    block14: {
                        try {
                            MidiEvent midiEvent;
                            int n3;
                            boolean bl4 = this.trackDisabled[n2];
                            Track track = this.tracks[n2];
                            int n4 = track.size();
                            for (n3 = this.trackReadPos[n2]; !bl && n3 < n4 && (midiEvent = track.get(n3)).getTick() <= l; ++n3) {
                                if (n3 != n4 - 1 || !MidiUtils.isMetaEndOfTrack(midiEvent.getMessage())) continue;
                                n3 = n4;
                                break;
                            }
                            if (n3 >= n4) {
                                ++n;
                            }
                            this.trackReadPos[n2] = n3;
                        }
                        catch (Exception exception) {
                            if (!(exception instanceof ArrayIndexOutOfBoundsException)) break block14;
                            this.needReindex = true;
                            bl = true;
                        }
                    }
                    if (bl) break;
                }
                boolean bl5 = bl3 = n == this.tracks.length;
                if (!bl2 && ((RealTimeSequencer.this.loopCount <= 0 || this.currLoopCounter <= 0) && RealTimeSequencer.this.loopCount != -1 || bl || RealTimeSequencer.this.loopEnd != -1L || !bl3)) continue;
                long l3 = this.checkPointMillis;
                long l4 = RealTimeSequencer.this.loopEnd;
                if (l4 == -1L) {
                    l4 = this.lastTick;
                }
                if (RealTimeSequencer.this.loopCount != -1) {
                    --this.currLoopCounter;
                }
                this.setTickPos(RealTimeSequencer.this.loopStart);
                this.checkPointMillis = l3 + this.tick2millis(l4 - this.checkPointTick);
                this.checkPointTick = RealTimeSequencer.this.loopStart;
                this.needReindex = false;
                bl = false;
                bl2 = false;
                bl3 = false;
            } while (bl);
            return bl3;
        }
    }

    class PlayThread
    implements Runnable {
        private Thread thread;
        private Object lock = new Object();
        boolean interrupted = false;
        boolean isPumping = false;
        private DataPump dataPump = new DataPump();

        PlayThread() {
            int n = 8;
            this.thread = JSSecurityManager.createThread(this, "Java Sound Sequencer", false, n, true);
        }

        DataPump getDataPump() {
            return this.dataPump;
        }

        synchronized void setSequence(Sequence sequence) {
            this.dataPump.setSequence(sequence);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void start() {
            RealTimeSequencer.this.running = true;
            if (!this.dataPump.hasCachedTempo()) {
                long l = RealTimeSequencer.this.getTickPosition();
                this.dataPump.setTempoMPQ(RealTimeSequencer.this.tempoCache.getTempoMPQAt(l));
            }
            this.dataPump.checkPointMillis = 0L;
            this.dataPump.clearNoteOnCache();
            this.dataPump.needReindex = true;
            this.dataPump.resetLoopCount();
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void stop() {
            this.playThreadImplStop();
            long l = System.nanoTime() / 1000000L;
            while (this.isPumping) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (System.nanoTime() / 1000000L - l <= 1900L) continue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void playThreadImplStop() {
            RealTimeSequencer.this.running = false;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            Thread thread = null;
            Object object = this;
            synchronized (object) {
                this.interrupted = true;
                thread = this.thread;
                this.thread = null;
            }
            if (thread != null) {
                object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
            }
            if (thread != null) {
                try {
                    thread.join(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.interrupted) {
                Object object;
                boolean bl = false;
                boolean bl2 = RealTimeSequencer.this.running;
                boolean bl3 = this.isPumping = !this.interrupted && RealTimeSequencer.this.running;
                while (!bl && !this.interrupted && RealTimeSequencer.this.running) {
                    bl = this.dataPump.pump();
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.playThreadImplStop();
                if (bl2) {
                    this.dataPump.notesOff(true);
                }
                if (bl) {
                    this.dataPump.setTickPos(RealTimeSequencer.this.sequence.getTickLength());
                    object = new MetaMessage();
                    try {
                        ((MetaMessage)object).setMessage(47, new byte[0], 0);
                    }
                    catch (InvalidMidiDataException invalidMidiDataException) {
                        // empty catch block
                    }
                    RealTimeSequencer.this.sendMetaEvents((MidiMessage)object);
                }
                object = this.lock;
                synchronized (object) {
                    this.isPumping = false;
                    this.lock.notifyAll();
                    while (!RealTimeSequencer.this.running && !this.interrupted) {
                        try {
                            this.lock.wait();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    private static class RealTimeSequencerInfo
    extends MidiDevice.Info {
        private static final String name = "Real Time Sequencer";
        private static final String vendor = "Sun Microsystems";
        private static final String description = "Software sequencer";
        private static final String version = "Version 1.0";

        private RealTimeSequencerInfo() {
            super(name, vendor, description, version);
        }
    }

    static class RecordingTrack {
        private Track track;
        private int channel;

        RecordingTrack(Track track, int n) {
            this.track = track;
            this.channel = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static RecordingTrack get(List list, Track track) {
            List list2 = list;
            synchronized (list2) {
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    RecordingTrack recordingTrack = (RecordingTrack)list.get(i);
                    if (recordingTrack.track != track) continue;
                    return recordingTrack;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Track get(List list, int n) {
            List list2 = list;
            synchronized (list2) {
                int n2 = list.size();
                for (int i = 0; i < n2; ++i) {
                    RecordingTrack recordingTrack = (RecordingTrack)list.get(i);
                    if (recordingTrack.channel != n && recordingTrack.channel != -1) continue;
                    return recordingTrack.track;
                }
            }
            return null;
        }
    }

    class SequencerReceiver
    extends AbstractMidiDevice.AbstractReceiver {
        SequencerReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void implSend(MidiMessage midiMessage, long l) {
            if (RealTimeSequencer.this.recording) {
                Object object;
                long l2 = 0L;
                if (l < 0L) {
                    l2 = RealTimeSequencer.this.getTickPosition();
                } else {
                    object = RealTimeSequencer.this.tempoCache;
                    synchronized (object) {
                        l2 = MidiUtils.microsecond2tick(RealTimeSequencer.this.sequence, l, RealTimeSequencer.this.tempoCache);
                    }
                }
                object = null;
                if (midiMessage.getLength() > 1) {
                    Object object2;
                    if (midiMessage instanceof ShortMessage) {
                        object2 = (ShortMessage)midiMessage;
                        if ((((MidiMessage)object2).getStatus() & 0xF0) != 240) {
                            object = RecordingTrack.get(RealTimeSequencer.this.recordingTracks, ((ShortMessage)object2).getChannel());
                        }
                    } else {
                        object = RecordingTrack.get(RealTimeSequencer.this.recordingTracks, -1);
                    }
                    if (object != null) {
                        midiMessage = midiMessage instanceof ShortMessage ? new FastShortMessage((ShortMessage)midiMessage) : (MidiMessage)midiMessage.clone();
                        object2 = new MidiEvent(midiMessage, l2);
                        ((Track)object).add((MidiEvent)object2);
                    }
                }
            }
        }
    }

    private class SequencerTransmitter
    extends AbstractMidiDevice.BasicTransmitter {
        private SequencerTransmitter() {
        }
    }
}

