/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup.implspi;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.openide.util.lookup.implspi.ServiceLoaderLine;

public abstract class AbstractServiceProviderProcessor
extends AbstractProcessor {
    private final Map<ProcessingEnvironment, Map<String, SortedSet<ServiceLoaderLine>>> outputFilesByProcessor = new WeakHashMap<ProcessingEnvironment, Map<String, SortedSet<ServiceLoaderLine>>>();
    private final Map<ProcessingEnvironment, Map<String, List<Element>>> originatingElementsByProcessor = new WeakHashMap<ProcessingEnvironment, Map<String, List<Element>>>();
    private final Map<TypeElement, Boolean> verifiedClasses = new WeakHashMap<TypeElement, Boolean>();

    protected AbstractServiceProviderProcessor() {
        if (this.getClass().getName().equals("org.netbeans.modules.openide.util.ServiceProviderProcessor")) {
            return;
        }
        if (this.getClass().getName().equals("org.netbeans.modules.openide.util.URLStreamHandlerRegistrationProcessor")) {
            return;
        }
        throw new IllegalStateException();
    }

    @Override
    public final boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        if (roundEnvironment.errorRaised()) {
            return false;
        }
        if (roundEnvironment.processingOver()) {
            this.writeServices();
            this.outputFilesByProcessor.clear();
            this.originatingElementsByProcessor.clear();
            return true;
        }
        return this.handleProcess(set, roundEnvironment);
    }

    protected abstract boolean handleProcess(Set<? extends TypeElement> var1, RoundEnvironment var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void register(TypeElement typeElement, Class<? extends Annotation> clazz, TypeMirror typeMirror, String string, int n, String[] stringArray) {
        SequencedCollection<Element> sequencedCollection;
        Boolean bl = this.verifiedClasses.get(typeElement);
        if (bl == null) {
            bl = this.verifyServiceProviderSignature(typeElement, clazz);
            this.verifiedClasses.put(typeElement, bl);
        }
        if (!bl.booleanValue()) {
            return;
        }
        String string2 = this.processingEnv.getElementUtils().getBinaryName(typeElement).toString();
        String string3 = this.processingEnv.getElementUtils().getBinaryName((TypeElement)this.processingEnv.getTypeUtils().asElement(typeMirror)).toString();
        if (!this.processingEnv.getTypeUtils().isAssignable(typeElement.asType(), typeMirror)) {
            AnnotationMirror annotationMirror = this.findAnnotationMirror(typeElement, clazz);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, string2 + " is not assignable to " + string3, typeElement, annotationMirror, this.findAnnotationValue(annotationMirror, "service"));
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, string2 + " to be registered as a " + string3 + (string.length() > 0 ? " under " + string : ""));
        String string4 = (string.length() > 0 ? "META-INF/namedservices/" + string + "/" : "META-INF/services/") + string3;
        Map<String, SequencedCollection<Object>> map = this.originatingElementsByProcessor.get(this.processingEnv);
        if (map == null) {
            map = new HashMap<String, List<Element>>();
            this.originatingElementsByProcessor.put(this.processingEnv, map);
        }
        if ((sequencedCollection = map.get(string4)) == null) {
            sequencedCollection = new ArrayList<Element>();
            map.put(string4, sequencedCollection);
        }
        sequencedCollection.add(typeElement);
        map = this.outputFilesByProcessor.get(this.processingEnv);
        if (map == null) {
            map = new HashMap();
            this.outputFilesByProcessor.put(this.processingEnv, map);
        }
        if ((sequencedCollection = (SortedSet)map.get(string4)) == null) {
            sequencedCollection = new TreeSet();
            try {
                try {
                    FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, "", string4);
                    fileObject.openInputStream().close();
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Cannot generate " + string4 + " because it already exists in sources: " + fileObject.toUri());
                    return;
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                try {
                    FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", string4);
                    InputStream inputStream = fileObject.openInputStream();
                    try {
                        ServiceLoaderLine.parse(new InputStreamReader(inputStream, "UTF-8"), sequencedCollection);
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
            catch (IOException iOException) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, iOException.toString());
                return;
            }
            map.put(string4, sequencedCollection);
        }
        sequencedCollection.add((Element)((Object)new ServiceLoaderLine(string2, n, stringArray)));
    }

    private AnnotationMirror findAnnotationMirror(Element element, Class<? extends Annotation> clazz) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.processingEnv.getElementUtils().getBinaryName((TypeElement)annotationMirror.getAnnotationType().asElement()).contentEquals(clazz.getName())) continue;
            return annotationMirror;
        }
        return null;
    }

    private AnnotationValue findAnnotationValue(AnnotationMirror annotationMirror, String string) {
        if (annotationMirror != null) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!entry.getKey().getSimpleName().contentEquals(string)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    private boolean verifyServiceProviderSignature(TypeElement typeElement, Class<? extends Annotation> clazz) {
        AnnotationMirror annotationMirror = this.findAnnotationMirror(typeElement, clazz);
        if (!typeElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, typeElement + " must be public", typeElement, annotationMirror);
            return false;
        }
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, typeElement + " must not be abstract", typeElement, annotationMirror);
            return false;
        }
        boolean bl = false;
        for (ExecutableElement executableElement : ElementFilter.constructorsIn(typeElement.getEnclosedElements())) {
            if (!executableElement.getModifiers().contains((Object)Modifier.PUBLIC) || !executableElement.getParameters().isEmpty()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, typeElement + " must have a public no-argument constructor", typeElement, annotationMirror);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeServices() {
        for (Map.Entry<ProcessingEnvironment, Map<String, SortedSet<ServiceLoaderLine>>> entry : this.outputFilesByProcessor.entrySet()) {
            for (Map.Entry<String, SortedSet<ServiceLoaderLine>> entry2 : entry.getValue().entrySet()) {
                try {
                    FileObject fileObject = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", entry2.getKey(), this.originatingElementsByProcessor.get(entry.getKey()).get(entry2.getKey()).toArray(new Element[0]));
                    OutputStream outputStream = fileObject.openOutputStream();
                    try {
                        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
                        for (ServiceLoaderLine serviceLoaderLine : entry2.getValue()) {
                            serviceLoaderLine.write(printWriter);
                        }
                        printWriter.flush();
                        printWriter.close();
                    }
                    finally {
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write to " + entry2.getKey() + ": " + iOException.toString());
                }
            }
        }
    }
}

