/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public abstract class Lookup {
    public static final Lookup EMPTY = new Empty();
    private static Lookup defaultLookup;

    public static synchronized Lookup getDefault() {
        if (defaultLookup != null) {
            return defaultLookup;
        }
        String string = System.getProperty("org.openide.util.Lookup");
        if ("-".equals(string)) {
            return EMPTY;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (string != null) {
                defaultLookup = (Lookup)Class.forName(string, true, classLoader).newInstance();
                return defaultLookup;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Lookup lookup = Lookups.metaInfServices(classLoader);
        defaultLookup = lookup.lookup(Lookup.class);
        if (defaultLookup != null) {
            return defaultLookup;
        }
        Provider provider = lookup.lookup(Provider.class);
        if (provider != null) {
            defaultLookup = Lookups.proxy(provider);
            return defaultLookup;
        }
        DefLookup defLookup = new DefLookup();
        defLookup.init(classLoader, lookup, false);
        defaultLookup = defLookup;
        defLookup.init(classLoader, lookup, true);
        return defaultLookup;
    }

    private static void resetDefaultLookup() {
        if (defaultLookup instanceof DefLookup) {
            DefLookup defLookup = (DefLookup)defaultLookup;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            defLookup.init(classLoader, Lookups.metaInfServices(classLoader), true);
        }
    }

    public abstract <T> T lookup(Class<T> var1);

    public abstract <T> Result<T> lookup(Template<T> var1);

    public <T> Item<T> lookupItem(Template<T> template) {
        Result<T> result = this.lookup(template);
        Iterator<Item<T>> iterator = result.allItems().iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    public <T> Result<T> lookupResult(Class<T> clazz) {
        return this.lookup(new Template<T>(clazz));
    }

    public <T> Collection<? extends T> lookupAll(Class<T> clazz) {
        return this.lookupResult(clazz).allInstances();
    }

    private static final class Empty
    extends Lookup {
        private static final Result NO_RESULT = new Result(){

            @Override
            public void addLookupListener(LookupListener lookupListener) {
            }

            @Override
            public void removeLookupListener(LookupListener lookupListener) {
            }

            public Collection allInstances() {
                return Collections.EMPTY_SET;
            }
        };

        Empty() {
        }

        @Override
        public <T> T lookup(Class<T> clazz) {
            return null;
        }

        @Override
        public <T> Result<T> lookup(Template<T> template) {
            return NO_RESULT;
        }
    }

    public static abstract class Item<T> {
        public abstract T getInstance();

        public abstract Class<? extends T> getType();

        public abstract String getId();

        public abstract String getDisplayName();

        public String toString() {
            return this.getId();
        }
    }

    public static abstract class Result<T> {
        public abstract void addLookupListener(LookupListener var1);

        public abstract void removeLookupListener(LookupListener var1);

        public abstract Collection<? extends T> allInstances();

        public Set<Class<? extends T>> allClasses() {
            return Collections.emptySet();
        }

        public Collection<? extends Item<T>> allItems() {
            return Collections.emptyList();
        }
    }

    public static final class Template<T> {
        private int hashCode;
        private Class<T> type;
        private String id;
        private T instance;

        @Deprecated
        public Template() {
            this(null);
        }

        public Template(Class<T> clazz) {
            this(clazz, null, null);
        }

        public Template(Class<T> clazz, String string, T t) {
            this.type = this.extractType(clazz);
            this.id = string;
            this.instance = t;
        }

        private Class<T> extractType(Class<T> clazz) {
            return clazz == null ? Object.class : clazz;
        }

        public Class<T> getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public T getInstance() {
            return this.instance;
        }

        public int hashCode() {
            if (this.hashCode != 0) {
                return this.hashCode;
            }
            this.hashCode = (this.type == null ? 1 : this.type.hashCode()) + (this.id == null ? 2 : this.id.hashCode()) + (this.instance == null ? 3 : 0);
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Template)) {
                return false;
            }
            Template template = (Template)object;
            if (this.hashCode() != template.hashCode()) {
                return false;
            }
            if (this.type != template.type) {
                return false;
            }
            if (this.id == null ? template.id != null : !this.id.equals(template.id)) {
                return false;
            }
            if (this.instance == null) {
                return template.instance == null;
            }
            return this.instance.equals(template.instance);
        }

        public String toString() {
            return "Lookup.Template[type=" + this.type + ",id=" + this.id + ",instance=" + this.instance + "]";
        }
    }

    public static interface Provider {
        public Lookup getLookup();
    }

    private static final class DefLookup
    extends ProxyLookup {
        public DefLookup() {
            super(new Lookup[0]);
        }

        public void init(ClassLoader classLoader, Lookup lookup, boolean bl) {
            Lookup lookup2 = Lookups.singleton(classLoader);
            ArrayList<Lookup> arrayList = new ArrayList<Lookup>();
            arrayList.add(lookup);
            arrayList.add(lookup2);
            String string = System.getProperty("org.openide.util.Lookup.paths");
            if (bl && string != null) {
                for (String string2 : string.split(":")) {
                    arrayList.add(Lookups.forPath(string2));
                }
            }
            this.setLookups(arrayList.toArray(new Lookup[0]));
        }
    }
}

