/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.graphs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.LineBorder;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ItemPainter;
import org.netbeans.lib.profiler.charts.PaintersModel;
import org.netbeans.lib.profiler.charts.axis.AxisComponent;
import org.netbeans.lib.profiler.charts.axis.AxisMarksComputer;
import org.netbeans.lib.profiler.charts.axis.AxisMarksPainter;
import org.netbeans.lib.profiler.charts.axis.PercentLongMarksPainter;
import org.netbeans.lib.profiler.charts.axis.SimpleLongMarksPainter;
import org.netbeans.lib.profiler.charts.axis.TimeMarksPainter;
import org.netbeans.lib.profiler.charts.axis.TimelineMarksComputer;
import org.netbeans.lib.profiler.charts.swing.CrossBorderLayout;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.xy.CompoundXYItemPainter;
import org.netbeans.lib.profiler.charts.xy.DecimalXYItemMarksComputer;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemPainter;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemMarker;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemPainter;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;
import org.netbeans.lib.profiler.results.DataManagerListener;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerGCXYItemPainter;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYChart;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipModel;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipOverlay;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipPainter;
import org.netbeans.lib.profiler.ui.components.ColorIcon;
import org.netbeans.lib.profiler.ui.graphs.GraphPanel;
import org.netbeans.lib.profiler.ui.graphs.GraphsUI;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryModels;

public final class SurvivingGenerationsGraphPanel
extends GraphPanel {
    private ProfilerXYChart chart;
    private Action[] chartActions;
    private final VMTelemetryModels models;
    private final boolean smallPanel;

    public static SurvivingGenerationsGraphPanel createBigPanel(VMTelemetryModels vMTelemetryModels) {
        return new SurvivingGenerationsGraphPanel(vMTelemetryModels, false, null);
    }

    public static SurvivingGenerationsGraphPanel createSmallPanel(VMTelemetryModels vMTelemetryModels, Action action) {
        return new SurvivingGenerationsGraphPanel(vMTelemetryModels, true, action);
    }

    private SurvivingGenerationsGraphPanel(VMTelemetryModels vMTelemetryModels, boolean bl, Action action) {
        this.models = vMTelemetryModels;
        this.smallPanel = bl;
        this.initComponents(action);
        vMTelemetryModels.getDataManager().addDataListener(new DataManagerListener(){

            public void dataChanged() {
                SurvivingGenerationsGraphPanel.this.updateData();
            }

            public void dataReset() {
                SurvivingGenerationsGraphPanel.this.resetData();
            }
        });
        this.resetData();
    }

    @Override
    public Action[] getActions() {
        return this.chartActions;
    }

    private void updateData() {
        VMTelemetryDataManager vMTelemetryDataManager;
        long[] lArray;
        if (this.smallPanel && this.chart.fitsWidth() && (lArray = vMTelemetryDataManager.timeStamps)[(vMTelemetryDataManager = this.models.getDataManager()).getItemCount() - 1] - lArray[0] >= 180000L) {
            this.chart.setFitsWidth(false);
        }
    }

    private void resetData() {
        if (this.smallPanel) {
            this.chart.setScale(0.02, 1.0);
            this.chart.setOffset(0L, 0L);
            this.chart.setFitsWidth(true);
        } else {
            this.chart.setScale(0.02, 1.0);
            this.chart.setOffset(0L, 0L);
            this.chart.setFitsWidth(false);
        }
        this.chart.setInitialDataBounds(new LongRect(System.currentTimeMillis(), 0L, 2500L, 2L));
    }

    private void initComponents(final Action action) {
        PaintersModel paintersModel = this.createGenerationsPaintersModel();
        this.chart = this.createChart(this.models.generationsItemsModel(), paintersModel, this.smallPanel);
        this.chart.setBackground(GraphsUI.CHART_BACKGROUND_COLOR);
        this.chart.setViewInsets(new Insets(10, 0, 0, 0));
        AxisComponent axisComponent = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new TimelineMarksComputer(this.models.generationsItemsModel().getTimeline(), this.chart.getChartContext(), 0), (AxisMarksPainter)new TimeMarksPainter(), 5, 2);
        SynchronousXYItem synchronousXYItem = this.models.generationsItemsModel().getItem(1);
        XYItemPainter xYItemPainter = (XYItemPainter)paintersModel.getPainter((ChartItem)synchronousXYItem);
        SimpleLongMarksPainter simpleLongMarksPainter = new SimpleLongMarksPainter();
        simpleLongMarksPainter.setForeground(GraphsUI.SURVGEN_PAINTER_LINE_COLOR);
        AxisComponent axisComponent2 = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new DecimalXYItemMarksComputer((XYItem)synchronousXYItem, xYItemPainter, this.chart.getChartContext(), 1), (AxisMarksPainter)simpleLongMarksPainter, 7, 2);
        SynchronousXYItem synchronousXYItem2 = this.models.generationsItemsModel().getItem(2);
        XYItemPainter xYItemPainter2 = (XYItemPainter)paintersModel.getPainter((ChartItem)synchronousXYItem2);
        PercentLongMarksPainter percentLongMarksPainter = new PercentLongMarksPainter(0L, 1000L);
        percentLongMarksPainter.setForeground(GraphsUI.GC_TIME_PAINTER_LINE_COLOR);
        AxisComponent axisComponent3 = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new DecimalXYItemMarksComputer((XYItem)synchronousXYItem2, xYItemPainter2, this.chart.getChartContext(), 1), (AxisMarksPainter)percentLongMarksPainter, 3, 0);
        JPanel jPanel = new JPanel((LayoutManager)new CrossBorderLayout());
        jPanel.setBackground(GraphsUI.CHART_BACKGROUND_COLOR);
        jPanel.setBorder(BorderFactory.createMatteBorder(10, 10, 10, 10, GraphsUI.CHART_BACKGROUND_COLOR));
        jPanel.add((Component)((Object)this.chart), new Integer[]{0});
        jPanel.add((Component)axisComponent, new Integer[]{5, 4, 6});
        jPanel.add((Component)axisComponent2, new Integer[]{7, 6});
        jPanel.add((Component)axisComponent3, new Integer[]{3, 4});
        if (this.smallPanel) {
            this.chart.setMouseZoomingEnabled(false);
            this.chart.getSelectionModel().setHoverMode(100);
            JLabel jLabel = new JLabel(GraphsUI.SURVGEN_NAME, new ColorIcon(GraphsUI.SURVGEN_PAINTER_LINE_COLOR, null, 8, 8), 10);
            jLabel.setFont(this.getFont().deriveFont((float)this.getFont().getSize() - 1.0f));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            JLabel jLabel2 = new JLabel(GraphsUI.GC_TIME_NAME, new ColorIcon(GraphsUI.GC_TIME_PAINTER_LINE_COLOR, null, 8, 8), 10);
            jLabel2.setFont(this.getFont().deriveFont((float)this.getFont().getSize() - 1.0f));
            jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            JPanel jPanel2 = new JPanel(new FlowLayout(1, 0, 1));
            jPanel2.setBackground(GraphsUI.SMALL_LEGEND_BACKGROUND_COLOR);
            jPanel2.setBorder(new LineBorder(GraphsUI.SMALL_LEGEND_BORDER_COLOR, 1));
            jPanel2.add(jLabel);
            jPanel2.add(jLabel2);
            JPanel jPanel3 = new JPanel(new FlowLayout(1));
            jPanel3.setBackground(GraphsUI.SMALL_LEGEND_BACKGROUND_COLOR);
            jPanel3.add(jPanel2);
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel, "Center");
            this.add((Component)jPanel3, "South");
            this.chart.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                        action.actionPerformed(null);
                    }
                }
            });
            this.chartActions = new Action[0];
        } else {
            ProfilerXYTooltipPainter profilerXYTooltipPainter = new ProfilerXYTooltipPainter(2.1f, GraphsUI.TOOLTIP_OVERLAY_LINE_COLOR, GraphsUI.TOOLTIP_OVERLAY_FILL_COLOR, this.getTooltipModel());
            this.chart.addOverlayComponent(new ProfilerXYTooltipOverlay((ChartComponent)this.chart, profilerXYTooltipPainter));
            JScrollBar jScrollBar = new JScrollBar(0);
            this.chart.attachHorizontalScrollBar(jScrollBar);
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.setBorder(new BevelBorder(1));
            jPanel4.add((Component)jPanel, "Center");
            jPanel4.add((Component)jScrollBar, "South");
            JLabel jLabel = new JLabel(GraphsUI.SURVGEN_NAME, new ColorIcon(GraphsUI.SURVGEN_PAINTER_LINE_COLOR, Color.BLACK, 18, 9), 10);
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JLabel jLabel3 = new JLabel(GraphsUI.GC_TIME_NAME, new ColorIcon(GraphsUI.GC_TIME_PAINTER_LINE_COLOR, Color.BLACK, 18, 9), 10);
            jLabel3.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JPanel jPanel5 = new JPanel(new FlowLayout(4, 10, 10));
            jPanel5.add(jLabel);
            jPanel5.add(jLabel3);
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel4, "Center");
            this.add((Component)jPanel5, "South");
            this.chartActions = new Action[]{this.chart.zoomInAction(), this.chart.zoomOutAction(), this.chart.toggleViewAction()};
        }
    }

    @Override
    protected ProfilerXYTooltipModel createTooltipModel() {
        return new ProfilerXYTooltipModel(){

            @Override
            public String getTimeValue(long l) {
                return GraphPanel.DATE_FORMATTER.format(new Date(l));
            }

            @Override
            public int getRowsCount() {
                return 2;
            }

            @Override
            public String getRowName(int n) {
                switch (n) {
                    case 0: {
                        return GraphsUI.SURVGEN_NAME;
                    }
                    case 1: {
                        return GraphsUI.GC_TIME_NAME;
                    }
                }
                return null;
            }

            @Override
            public Color getRowColor(int n) {
                switch (n) {
                    case 0: {
                        return GraphsUI.SURVGEN_PAINTER_LINE_COLOR;
                    }
                    case 1: {
                        return GraphsUI.GC_TIME_PAINTER_LINE_COLOR;
                    }
                }
                return null;
            }

            @Override
            public String getRowValue(int n, long l) {
                switch (n) {
                    case 0: {
                        return GraphPanel.INT_FORMATTER.format(l);
                    }
                    case 1: {
                        String string = GraphPanel.PERCENT_FORMATTER.format((float)l / 1000.0f);
                        return this.trimPercents(string);
                    }
                }
                return null;
            }

            @Override
            public String getRowUnits(int n, long l) {
                switch (n) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return "%";
                    }
                }
                return null;
            }

            @Override
            public int getExtraRowsCount() {
                return this.getRowsCount();
            }

            @Override
            public String getExtraRowName(int n) {
                return SurvivingGenerationsGraphPanel.this.getMaxValueString(this.getRowName(n));
            }

            @Override
            public Color getExtraRowColor(int n) {
                return this.getRowColor(n);
            }

            @Override
            public String getExtraRowValue(int n) {
                SynchronousXYItem synchronousXYItem = SurvivingGenerationsGraphPanel.this.models.generationsItemsModel().getItem(n + 1);
                switch (n) {
                    case 0: {
                        return GraphPanel.INT_FORMATTER.format(synchronousXYItem.getMaxYValue());
                    }
                    case 1: {
                        String string = GraphPanel.PERCENT_FORMATTER.format((float)synchronousXYItem.getMaxYValue() / 1000.0f);
                        return this.trimPercents(string);
                    }
                }
                return null;
            }

            @Override
            public String getExtraRowUnits(int n) {
                return this.getRowUnits(n, -1L);
            }

            private String trimPercents(String string) {
                return !string.endsWith("%") ? string : string.substring(0, string.length() - 1).trim();
            }
        };
    }

    private PaintersModel createGenerationsPaintersModel() {
        SynchronousXYItemPainter synchronousXYItemPainter = SynchronousXYItemPainter.absolutePainter((float)3.0f, (Color)GraphsUI.SURVGEN_PAINTER_LINE_COLOR, (Color)GraphsUI.SURVGEN_PAINTER_FILL_COLOR);
        SynchronousXYItemMarker synchronousXYItemMarker = SynchronousXYItemMarker.absolutePainter((int)5, (float)0.75f, (Color)GraphsUI.SURVGEN_MARKER_LINE1_COLOR, (float)3.5f, (Color)GraphsUI.SURVGEN_MARKER_LINE2_COLOR, (Color)GraphsUI.SURVGEN_MARKER_FILL_COLOR);
        CompoundXYItemPainter compoundXYItemPainter = new CompoundXYItemPainter((XYItemPainter)synchronousXYItemPainter, (XYItemPainter)synchronousXYItemMarker);
        SynchronousXYItemPainter synchronousXYItemPainter2 = SynchronousXYItemPainter.relativePainter((float)3.0f, (Color)GraphsUI.GC_TIME_PAINTER_LINE_COLOR, (Color)GraphsUI.GC_TIME_PAINTER_FILL_COLOR, (int)10);
        SynchronousXYItemMarker synchronousXYItemMarker2 = SynchronousXYItemMarker.relativePainter((int)5, (float)0.75f, (Color)GraphsUI.GC_TIME_MARKER_LINE1_COLOR, (float)3.5f, (Color)GraphsUI.GC_TIME_MARKER_LINE2_COLOR, (Color)GraphsUI.GC_TIME_MARKER_FILL_COLOR, (int)10);
        CompoundXYItemPainter compoundXYItemPainter2 = new CompoundXYItemPainter((XYItemPainter)synchronousXYItemPainter2, (XYItemPainter)synchronousXYItemMarker2);
        ProfilerGCXYItemPainter profilerGCXYItemPainter = ProfilerGCXYItemPainter.painter(GraphsUI.GC_ACTIVITY_FILL_COLOR);
        SynchronousXYItemsModel synchronousXYItemsModel = this.models.generationsItemsModel();
        PaintersModel.Default default_ = new PaintersModel.Default(new ChartItem[]{synchronousXYItemsModel.getItem(0), synchronousXYItemsModel.getItem(1), synchronousXYItemsModel.getItem(2)}, (ItemPainter[])new XYItemPainter[]{profilerGCXYItemPainter, compoundXYItemPainter, compoundXYItemPainter2});
        return default_;
    }
}

