/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.treetable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.JTableHeader;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.components.JTreeTable;

public class JTreeTablePanel
extends JPanel {
    CustomTreeTableViewport treeTableViewport;
    protected JPanel scrollBarPanel;
    protected JScrollBar scrollBar;
    protected JScrollPane treeTableScrollPane;
    protected JTreeTable treeTable;
    private int invisibleRowsCount = -1;

    public JTreeTablePanel(JTreeTable jTreeTable) {
        super(new BorderLayout());
        this.treeTable = jTreeTable;
        this.initComponents();
        this.hookHeaderColumnResize();
        this.hookScrollBarValueChange();
        this.hookTreeCollapsedExpanded();
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && JTreeTablePanel.this.isShowing()) {
                    JTreeTablePanel.this.updateScrollBar(true);
                }
            }
        });
    }

    public void setCorner(String string, Component component) {
        this.treeTableScrollPane.setCorner(string, component);
    }

    public JScrollPane getScrollPane() {
        return this.treeTableScrollPane;
    }

    private void hookHeaderColumnResize() {
        this.treeTable.getTableHeader().getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                JTreeTablePanel.this.treeTableViewport.repaint();
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                JTreeTablePanel.this.treeTableViewport.repaint();
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
                JTreeTablePanel.this.treeTableViewport.repaint();
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
                JTreeTablePanel.this.treeTableViewport.repaint();
                JTreeTablePanel.this.updateScrollBar(true);
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }
        });
    }

    private void hookScrollBarValueChange() {
        this.scrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(final AdjustmentEvent adjustmentEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTreeTablePanel.this.treeTable.setTreeCellOffsetX(adjustmentEvent.getValue());
                        if (!adjustmentEvent.getValueIsAdjusting()) {
                            JTreeTablePanel.this.updateScrollBar(false);
                        }
                    }
                });
            }
        });
    }

    private void hookTreeCollapsedExpanded() {
        this.treeTable.getTree().addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                this.updateSB();
            }

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                this.updateSB();
            }

            private void updateSB() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTreeTablePanel.this.updateScrollBar(false);
                    }
                });
            }
        });
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.treeTableScrollPane = new JScrollPane(22, 31);
        this.treeTableScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.treeTableViewport = new CustomTreeTableViewport(this.treeTable);
        this.treeTableScrollPane.setViewport(this.treeTableViewport);
        this.treeTableScrollPane.addMouseWheelListener(this.treeTable);
        final JScrollBar jScrollBar = this.treeTableScrollPane.getVerticalScrollBar();
        jScrollBar.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Component component = JTreeTablePanel.this.treeTableViewport.getView();
                jScrollBar.setEnabled(JTreeTablePanel.this.isEnabled() && jScrollBar.getVisibleAmount() < jScrollBar.getMaximum());
            }
        });
        jScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (!adjustmentEvent.getValueIsAdjusting()) {
                    JTreeTablePanel.this.updateScrollBar(false);
                }
            }
        });
        this.scrollBar = new JScrollBar(0);
        this.scrollBar.setUnitIncrement(10);
        this.scrollBarPanel = new JPanel(new BorderLayout());
        this.scrollBarPanel.add((Component)this.scrollBar, "West");
        this.treeTable.setTreeCellOffsetX(0);
        this.scrollBarPanel.setVisible(false);
        this.scrollBar.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getScrollType() == 0) {
                    int n;
                    int n2 = mouseWheelEvent.getUnitsToScroll();
                    int n3 = n = n2 < 0 ? -1 : 1;
                    if (n2 != 0) {
                        int n4 = JTreeTablePanel.this.scrollBar.getUnitIncrement(n);
                        int n5 = JTreeTablePanel.this.scrollBar.getValue();
                        int n6 = n5 + n4 * n2;
                        if (n5 != (n6 = Math.max(Math.min(n6, JTreeTablePanel.this.scrollBar.getMaximum() - JTreeTablePanel.this.scrollBar.getVisibleAmount()), JTreeTablePanel.this.scrollBar.getMinimum()))) {
                            JTreeTablePanel.this.scrollBar.setValue(n6);
                        }
                    }
                }
            }
        });
        this.add((Component)this.treeTableScrollPane, "Center");
        this.add((Component)this.scrollBarPanel, "South");
    }

    private void updateScrollBar(boolean bl) {
        int n;
        int n2;
        int n3;
        if (!this.isShowing()) {
            return;
        }
        boolean bl2 = false;
        JTree jTree = this.treeTable.getTree();
        Point point = this.treeTableViewport.getViewPosition();
        int n4 = this.treeTableViewport.getHeight();
        TreePath treePath = jTree.getClosestPathForLocation(point.x, point.y);
        TreePath treePath2 = jTree.getClosestPathForLocation(point.x, point.y + n4 - 1);
        int n5 = jTree.getRowForPath(treePath);
        int n6 = jTree.getRowForPath(treePath2);
        if (n5 < 0) {
            return;
        }
        Rectangle rectangle = new Rectangle();
        for (n3 = n5; n3 <= n6; ++n3) {
            rectangle.add(jTree.getRowBounds(n3));
        }
        n3 = rectangle.width + 3;
        int n7 = this.treeTable.getColumnModel().getColumn(0).getWidth();
        int n8 = this.treeTable.getTreeCellOffsetX();
        int n9 = Math.max(n3 - n7, n8);
        if (this.scrollBarPanel.isVisible() && n9 <= 0 && (n2 = n6 + 1) <= (n = Math.min(n6 + this.getInvisibleRowsCount(), this.treeTable.getRowCount() - 1))) {
            int n10;
            rectangle = new Rectangle();
            for (n10 = n2; n10 <= n; ++n10) {
                rectangle.add(jTree.getRowBounds(n10));
            }
            rectangle.width += 3;
            n10 = Math.max(rectangle.width - n7, n8);
            if (n10 > 0) {
                n3 = rectangle.width;
                n9 = n10;
            }
        }
        if (n9 <= 0) {
            if (this.scrollBarPanel.isVisible()) {
                this.treeTable.setTreeCellOffsetX(0);
                this.scrollBarPanel.setVisible(false);
                bl2 = true;
            }
        } else {
            n2 = n8;
            n = n3;
            if (!this.scrollBarPanel.isVisible()) {
                this.scrollBarPanel.setVisible(true);
                bl2 = true;
            }
            this.scrollBar.setValues(n2, n, 0, n9 + n);
        }
        if (bl) {
            Dimension dimension = this.scrollBar.getPreferredSize();
            dimension.width = this.treeTable.getColumnModel().getColumn(0).getWidth();
            this.scrollBar.setPreferredSize(dimension);
            this.scrollBar.setBlockIncrement((int)((float)this.scrollBar.getModel().getExtent() * 0.95f));
            bl2 = true;
        }
        if (bl2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JTreeTablePanel.this.scrollBar.invalidate();
                    JTreeTablePanel.this.validate();
                    JTreeTablePanel.this.repaint();
                }
            });
        }
    }

    private int getInvisibleRowsCount() {
        if (this.invisibleRowsCount == -1) {
            this.invisibleRowsCount = (int)Math.ceil((float)this.scrollBar.getPreferredSize().height / (float)this.treeTable.getRowHeight());
        }
        return this.invisibleRowsCount;
    }

    private class CustomTreeTableViewport
    extends JViewport {
        private JTableHeader tableHeader;

        public CustomTreeTableViewport(JTreeTable jTreeTable) {
            this.setView(jTreeTable);
            this.setBackground(jTreeTable.getBackground());
            this.tableHeader = jTreeTable.getTableHeader();
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            this.paintVerticalLines(graphics);
        }

        private void paintVerticalLines(Graphics graphics) {
            Component component = this.getView();
            int n = component == null ? 0 : component.getHeight();
            int n2 = this.getHeight() - 1;
            if (n > 0 && n <= n2) {
                graphics.setColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
                int n3 = this.tableHeader.getColumnModel().getColumnCount();
                for (int i = 0; i < n3; ++i) {
                    Rectangle rectangle = this.tableHeader.getHeaderRect(i);
                    int n4 = rectangle.x + rectangle.width - 1;
                    graphics.drawLine(n4, n, n4, n2);
                }
            }
        }
    }
}

