/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.CellTipAware;
import org.netbeans.lib.profiler.ui.components.CellTipManager;
import org.netbeans.lib.profiler.ui.components.tree.TreeCellRendererPersistent;

public class JExtendedTree
extends JTree
implements CellTipAware {
    protected JToolTip cellTip;
    protected Rectangle rendererRect;
    protected TreePath lastTreePath = null;
    private PrivateComponentListener componentListener = new PrivateComponentListener();

    public JExtendedTree() {
        this.addMouseListener(this.componentListener);
        this.addMouseMotionListener(this.componentListener);
        this.setRowHeight(UIUtils.getDefaultRowHeight());
        this.cellTip = this.createCellTip();
        this.cellTip.setBackground(this.getBackground());
        this.cellTip.setBorder(BorderFactory.createLineBorder(UIConstants.TABLE_VERTICAL_GRID_COLOR));
        this.cellTip.setLayout(new BorderLayout());
        CellTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public JToolTip getCellTip() {
        return this.cellTip;
    }

    @Override
    public Point getCellTipLocation() {
        if (this.rendererRect == null) {
            return null;
        }
        return new Point(this.rendererRect.getLocation().x - 1, this.rendererRect.getLocation().y - 1);
    }

    @Override
    public void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
    }

    protected JToolTip createCellTip() {
        return new JToolTip();
    }

    protected void processCellTipMouseMove(MouseEvent mouseEvent) {
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == this.lastTreePath) {
            return;
        }
        this.lastTreePath = treePath;
        if (this.lastTreePath == null) {
            CellTipManager.sharedInstance().setEnabled(false);
            return;
        }
        int n = this.getRowForPath(this.lastTreePath);
        TreeCellRenderer treeCellRenderer = this.getCellRenderer();
        if (!(treeCellRenderer instanceof TreeCellRendererPersistent)) {
            return;
        }
        Component component = treeCellRenderer.getTreeCellRendererComponent(this, this.lastTreePath.getLastPathComponent(), false, this.isExpanded(n), this.getModel().isLeaf(this.lastTreePath.getLastPathComponent()), n, false);
        Component component2 = ((TreeCellRendererPersistent)treeCellRenderer).getTreeCellRendererComponentPersistent(this, this.lastTreePath.getLastPathComponent(), false, this.isExpanded(n), this.getModel().isLeaf(this.lastTreePath.getLastPathComponent()), n, false);
        if (component == null) {
            CellTipManager.sharedInstance().setEnabled(false);
            return;
        }
        Point point = this.getPathBounds(this.lastTreePath).getLocation();
        this.rendererRect = new Rectangle(point.x, point.y, component.getPreferredSize().width, component.getPreferredSize().height + 2);
        if (!this.rendererRect.contains(mouseEvent.getPoint())) {
            CellTipManager.sharedInstance().setEnabled(false);
            return;
        }
        Rectangle rectangle = this.getVisibleRect();
        if (this.rendererRect.x >= rectangle.x && this.rendererRect.x + this.rendererRect.width <= rectangle.x + rectangle.width) {
            CellTipManager.sharedInstance().setEnabled(false);
            return;
        }
        while (this.cellTip.getComponentCount() > 0) {
            this.cellTip.remove(0);
        }
        this.cellTip.add(component2, "Center");
        this.cellTip.setPreferredSize(new Dimension(component2.getPreferredSize().width + 2, this.getRowHeight() + 2));
        CellTipManager.sharedInstance().setEnabled(true);
    }

    private class PrivateComponentListener
    implements MouseListener,
    MouseMotionListener {
        private PrivateComponentListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            CellTipManager.sharedInstance().setEnabled(false);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (JExtendedTree.this.contains(mouseEvent.getPoint()) && JExtendedTree.this.cellTip.isShowing()) {
                return;
            }
            CellTipManager.sharedInstance().setEnabled(false);
            JExtendedTree.this.lastTreePath = null;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JExtendedTree.this.processCellTipMouseMove(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

