/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.sampler.cpu;

import com.sun.tools.visualvm.core.options.GlobalPreferences;
import com.sun.tools.visualvm.core.ui.components.DataViewComponent;
import com.sun.tools.visualvm.sampler.AbstractSamplerSupport;
import com.sun.tools.visualvm.sampler.cpu.CPUView;
import com.sun.tools.visualvm.sampler.cpu.SampledLivePanel;
import com.sun.tools.visualvm.sampler.cpu.ThreadInfoProvider;
import java.lang.management.ThreadInfo;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.filters.SimpleFilter;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.results.cpu.StackTraceSnapshotBuilder;
import org.openide.util.NbBundle;

public abstract class CPUSamplerSupport
extends AbstractSamplerSupport {
    private final ThreadInfoProvider threadInfoProvider;
    private final SnapshotDumper snapshotDumper;
    private final ThreadDumper threadDumper;
    private Timer timer;
    private TimerTask samplerTask;
    private final AbstractSamplerSupport.Refresher refresher;
    private int refreshRate;
    private StackTraceSnapshotBuilder builder;
    private volatile boolean sampleRunning;
    private final Object updateLock = new Object();
    private long currentLiveUpdate;
    private long lastLiveUpdate;
    private CPUView cpuView;
    private DataViewComponent.DetailsView[] detailsViews;

    public CPUSamplerSupport(ThreadInfoProvider tip, SnapshotDumper snapshotDumper, ThreadDumper threadDumper) {
        this.threadInfoProvider = tip;
        this.snapshotDumper = snapshotDumper;
        this.threadDumper = threadDumper;
        this.refreshRate = GlobalPreferences.sharedInstance().getMonitoredDataPoll() * 1000;
        this.refresher = new AbstractSamplerSupport.Refresher(){

            @Override
            public void setRefreshRate(int rr) {
                CPUSamplerSupport.this.refreshRate = rr;
            }

            @Override
            public int getRefreshRate() {
                return CPUSamplerSupport.this.refreshRate;
            }

            @Override
            protected boolean checkRefresh() {
                return CPUSamplerSupport.this.samplerTask != null && CPUSamplerSupport.this.cpuView.isShowing();
            }

            @Override
            protected void doRefresh() {
                CPUSamplerSupport.this.doRefreshImpl();
            }
        };
    }

    @Override
    public DataViewComponent.DetailsView[] getDetailsView() {
        if (this.detailsViews == null) {
            this.cpuView = new CPUView(this.refresher, this.snapshotDumper, this.threadDumper);
            this.detailsViews = new DataViewComponent.DetailsView[]{new DataViewComponent.DetailsView(NbBundle.getMessage(CPUSamplerSupport.class, (String)"LBL_Cpu_samples"), null, 10, (JComponent)this.cpuView, null)};
        }
        this.cpuView.initSession();
        return (DataViewComponent.DetailsView[])this.detailsViews.clone();
    }

    @Override
    public boolean startSampling(ProfilingSettings settings, int samplingRate, int refreshRate) {
        InstrumentationFilter filter = new InstrumentationFilter();
        SimpleFilter sf = (SimpleFilter)settings.getSelectedInstrumentationFilter();
        filter.setFilterStrings(sf.getFilterValue());
        filter.setFilterType(this.convertFilterType(sf.getFilterType()));
        this.snapshotDumper.builder = this.builder = new StackTraceSnapshotBuilder(1, filter);
        this.refresher.setRefreshRate(refreshRate);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CPUSamplerSupport.this.cpuView.setResultsPanel(new SampledLivePanel(CPUSamplerSupport.this.builder));
            }
        });
        if (this.timer == null) {
            this.timer = this.getTimer();
        }
        this.samplerTask = new SamplerTask(this.builder);
        try {
            this.timer.scheduleAtFixedRate(this.samplerTask, 0L, (long)samplingRate);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public synchronized void stopSampling() {
        if (this.samplerTask != null) {
            this.samplerTask.cancel();
            this.samplerTask = null;
        }
    }

    @Override
    public synchronized void terminate() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (this.cpuView != null) {
            this.cpuView.terminate();
        }
    }

    private void doRefreshImpl() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (CPUSamplerSupport.this.samplerTask == null) {
                    return;
                }
                if (!CPUSamplerSupport.this.sampleRunning) {
                    Object object = CPUSamplerSupport.this.updateLock;
                    synchronized (object) {
                        CPUSamplerSupport.this.lastLiveUpdate = CPUSamplerSupport.this.currentLiveUpdate;
                        CPUSamplerSupport.this.cpuView.refresh();
                    }
                } else {
                    SwingUtilities.invokeLater(this);
                }
            }
        });
    }

    private int convertFilterType(int simpleFilterrType) {
        if (simpleFilterrType == 0) {
            return 0;
        }
        if (simpleFilterrType == 1) {
            return 10;
        }
        if (simpleFilterrType == 2) {
            return 20;
        }
        throw new IllegalArgumentException("type " + simpleFilterrType);
    }

    public static abstract class SnapshotDumper {
        protected StackTraceSnapshotBuilder builder;

        public abstract void takeSnapshot(boolean var1);
    }

    public static abstract class ThreadDumper {
        public abstract void takeThreadDump(boolean var1);
    }

    private class SamplerTask
    extends TimerTask {
        private final StackTraceSnapshotBuilder builder;
        private final Set samplingThreads = new HashSet();

        public SamplerTask(StackTraceSnapshotBuilder builder) {
            this.builder = builder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (CPUSamplerSupport.this.sampleRunning) {
                return;
            }
            Object object = CPUSamplerSupport.this.updateLock;
            synchronized (object) {
                CPUSamplerSupport.this.sampleRunning = true;
                try {
                    ThreadInfo[] infos = CPUSamplerSupport.this.threadInfoProvider.dumpAllThreads();
                    long timestamp = System.nanoTime();
                    String samplingThreadName = this.findSamplingThread(infos);
                    if (samplingThreadName != null && this.samplingThreads.add(samplingThreadName)) {
                        this.builder.setIgnoredThreads(this.samplingThreads);
                    }
                    this.builder.addStacktrace(infos, timestamp);
                    CPUSamplerSupport.this.currentLiveUpdate = timestamp / 1000000L;
                    if (CPUSamplerSupport.this.currentLiveUpdate - CPUSamplerSupport.this.lastLiveUpdate >= (long)CPUSamplerSupport.this.refreshRate) {
                        CPUSamplerSupport.this.refresher.refresh();
                    }
                }
                catch (Throwable ex) {
                    CPUSamplerSupport.this.terminate();
                }
                finally {
                    CPUSamplerSupport.this.sampleRunning = false;
                }
            }
        }

        private String findSamplingThread(ThreadInfo[] infos) {
            return null;
        }
    }
}

