/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.execution;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.execution.ExecutionEngine;
import org.netbeans.core.execution.TaskThreadGroup;
import org.openide.execution.ExecutorTask;
import org.openide.util.Exceptions;
import org.openide.windows.InputOutput;

final class DefaultSysProcess
extends ExecutorTask {
    static int processCount;
    private final TaskThreadGroup group;
    private boolean destroyed = false;
    private final InputOutput io;
    private final String name;

    public DefaultSysProcess(Runnable runnable, TaskThreadGroup taskThreadGroup, InputOutput inputOutput, String string) {
        super(runnable);
        this.group = taskThreadGroup;
        this.io = inputOutput;
        this.name = string;
    }

    public synchronized void stop() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        try {
            this.group.interrupt();
            this.group.stop();
            this.group.getRunClassThread().waitForEnd();
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(DefaultSysProcess.class.getName()).log(Level.WARNING, null, interruptedException);
        }
        ExecutionEngine.closeGroup(this.group);
        this.group.kill();
        this.notifyFinished();
    }

    public int result() {
        try {
            this.group.waitFor();
        }
        catch (InterruptedException interruptedException) {
            return 4;
        }
        this.notifyFinished();
        return 0;
    }

    public InputOutput getInputOutput() {
        return this.io;
    }

    public void run() {
    }

    public String getName() {
        return this.name;
    }

    void destroyThreadGroup(ThreadGroup threadGroup) {
        new Thread(threadGroup, new Runnable(){

            @Override
            public void run() {
                try {
                    while (DefaultSysProcess.this.group.activeCount() > 0) {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
                if (!DefaultSysProcess.this.group.isDestroyed()) {
                    try {
                        DefaultSysProcess.this.group.destroy();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        // empty catch block
                    }
                }
            }
        }).start();
    }
}

