/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.netbeans.core.UIExceptions;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

abstract class ArrayOfIntSupport
extends PropertyEditorSupport
implements XMLPropertyEditor,
ExPropertyEditor {
    private static final String VALUE_FORMAT = NbBundle.getBundle(ArrayOfIntSupport.class).getString("EXC_BadFormatValue");
    private int count;
    private String className;
    PropertyEnv env;
    public static final String ATTR_VALUE = "value";

    public ArrayOfIntSupport(String string, int n) {
        this.className = string;
        this.count = n;
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        this.env = propertyEnv;
    }

    @Override
    public String getJavaInitializationString() {
        int[] nArray = this.getValues();
        StringBuffer stringBuffer = new StringBuffer("new ");
        stringBuffer.append(this.className);
        stringBuffer.append("(");
        this.addArray(stringBuffer, nArray);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    abstract int[] getValues();

    abstract void setValues(int[] var1);

    @Override
    public String getAsText() {
        if (this.getValue() == null) {
            return "null";
        }
        int[] nArray = this.getValues();
        if (nArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        this.addArray(stringBuffer, nArray);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void addArray(StringBuffer stringBuffer, int[] nArray) {
        for (int i = 0; i < this.count; ++i) {
            if (nArray == null) {
                stringBuffer.append("0");
            } else {
                stringBuffer.append(nArray[i]);
            }
            if (i >= this.count - 1) continue;
            stringBuffer.append(", ");
        }
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        if ("null".equals(string) || "".equals(string)) {
            this.setValue(null);
            return;
        }
        int[] nArray = new int[this.count];
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[] ,;", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (n >= this.count) {
                this.badFormat(null);
            }
            try {
                nArray[n] = new Integer(string2);
                ++n;
            }
            catch (NumberFormatException numberFormatException) {
                this.badFormat(numberFormatException);
            }
        }
        if (n != this.count && n > 0) {
            int n2 = nArray[n - 1];
            for (int i = n; i < this.count; ++i) {
                nArray[i] = n2;
            }
        }
        this.setValues(nArray);
    }

    private void badFormat(Exception exception) throws IllegalArgumentException {
        String string = new MessageFormat(VALUE_FORMAT).format(new Object[]{this.className, this.getHintFormat()});
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
        UIExceptions.annotateUser(illegalArgumentException, exception == null ? "" : exception.getMessage(), string, exception, new Date());
        throw illegalArgumentException;
    }

    String getHintFormat() {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < this.count; ++i) {
            stringBuffer.append("<n");
            stringBuffer.append(i);
            stringBuffer.append(">");
            if (i >= this.count - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected abstract String getXMLValueTag();

    public void readFromXML(Node node) throws IOException {
        if (!this.getXMLValueTag().equals(node.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        try {
            String string = namedNodeMap.getNamedItem(ATTR_VALUE).getNodeValue();
            this.setAsText(string);
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    public Node storeToXML(Document document) {
        Element element = document.createElement(this.getXMLValueTag());
        element.setAttribute(ATTR_VALUE, this.getAsText());
        return element;
    }
}

