/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.jvm;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.Jvm;
import com.sun.tools.visualvm.core.datasupport.DataRemovedListener;
import com.sun.tools.visualvm.core.options.GlobalPreferences;
import com.sun.tools.visualvm.jvm.JVMImpl;
import com.sun.tools.visualvm.jvm.MonitoredDataImpl;
import com.sun.tools.visualvm.tools.jmx.JmxModel;
import com.sun.tools.visualvm.tools.jmx.JmxModelFactory;
import com.sun.tools.visualvm.tools.jmx.JvmMXBeans;
import com.sun.tools.visualvm.tools.jmx.JvmMXBeansFactory;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxSupport
implements DataRemovedListener {
    private static final Logger LOGGER = Logger.getLogger(JmxSupport.class.getName());
    private static final String PROCESS_CPU_TIME_ATTR = "ProcessCpuTime";
    private static final String PROCESSING_CAPACITY_ATTR = "ProcessingCapacity";
    private static final String PERM_GEN = "Perm Gen";
    private static final String PS_PERM_GEN = "PS Perm Gen";
    private static final String CMS_PERM_GEN = "CMS Perm Gen";
    private static final String IBM_PERM_GEN = "class storage";
    private static final ObjectName osName = JmxSupport.getOSName();
    private static long INITIAL_DELAY = 100L;
    private Application application;
    private JvmMXBeans mxbeans;
    private JVMImpl jvm;
    private Object processCPUTimeAttributeLock = new Object();
    private Boolean processCPUTimeAttribute;
    private long processCPUTimeMultiplier;
    private Boolean readOnlyConnection;
    private Timer timer;
    private MemoryPoolMXBean permGenPool;
    private Collection<GarbageCollectorMXBean> gcList;

    JmxSupport(Application app, JVMImpl vm) {
        this.jvm = vm;
        this.application = app;
        app.notifyWhenRemoved((DataRemovedListener)this);
    }

    RuntimeMXBean getRuntime() {
        JvmMXBeans jmx = this.getJvmMXBeans();
        if (jmx != null) {
            return jmx.getRuntimeMXBean();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasProcessCPUTimeAttribute() {
        Object object = this.processCPUTimeAttributeLock;
        synchronized (object) {
            MBeanServerConnection conn;
            if (this.processCPUTimeAttribute != null) {
                return this.processCPUTimeAttribute;
            }
            this.processCPUTimeAttribute = Boolean.FALSE;
            JmxModel jmx = JmxModelFactory.getJmxModelFor((Application)this.application);
            if (jmx != null && jmx.getConnectionState().equals((Object)JmxModel.ConnectionState.CONNECTED) && (conn = jmx.getMBeanServerConnection()) != null) {
                try {
                    MBeanInfo info = conn.getMBeanInfo(osName);
                    MBeanAttributeInfo[] attrs = info.getAttributes();
                    this.processCPUTimeMultiplier = 1L;
                    for (MBeanAttributeInfo attr : attrs) {
                        String name = attr.getName();
                        if (PROCESS_CPU_TIME_ATTR.equals(name)) {
                            this.processCPUTimeAttribute = Boolean.TRUE;
                        }
                        if (!PROCESSING_CAPACITY_ATTR.equals(name)) continue;
                        Number mul = (Number)conn.getAttribute(osName, PROCESSING_CAPACITY_ATTR);
                        this.processCPUTimeMultiplier = mul.longValue();
                    }
                }
                catch (Exception ex) {
                    LOGGER.throwing(JmxSupport.class.getName(), "hasProcessCPUTimeAttribute", ex);
                }
            }
            return this.processCPUTimeAttribute;
        }
    }

    long getProcessCPUTime() {
        MBeanServerConnection conn;
        if (!this.hasProcessCPUTimeAttribute()) {
            throw new UnsupportedOperationException();
        }
        JmxModel jmx = JmxModelFactory.getJmxModelFor((Application)this.application);
        if (jmx != null && jmx.getConnectionState().equals((Object)JmxModel.ConnectionState.CONNECTED) && (conn = jmx.getMBeanServerConnection()) != null) {
            try {
                Long cputime = (Long)conn.getAttribute(osName, PROCESS_CPU_TIME_ATTR);
                return cputime * this.processCPUTimeMultiplier;
            }
            catch (Exception ex) {
                LOGGER.throwing(JmxSupport.class.getName(), "hasProcessCPUTimeAttribute", ex);
            }
        }
        return -1L;
    }

    synchronized JvmMXBeans getJvmMXBeans() {
        JmxModel jmxModel;
        if (this.mxbeans == null && (jmxModel = JmxModelFactory.getJmxModelFor((Application)this.application)) != null && jmxModel.getConnectionState() == JmxModel.ConnectionState.CONNECTED) {
            this.mxbeans = JvmMXBeansFactory.getJvmMXBeans((JmxModel)jmxModel);
        }
        return this.mxbeans;
    }

    synchronized boolean isReadOnlyConnection() {
        if (this.readOnlyConnection == null) {
            ThreadMXBean threads;
            this.readOnlyConnection = Boolean.FALSE;
            JvmMXBeans mxbeans = this.getJvmMXBeans();
            if (mxbeans != null && (threads = mxbeans.getThreadMXBean()) != null) {
                try {
                    threads.getThreadInfo(1L);
                }
                catch (SecurityException ex) {
                    this.readOnlyConnection = Boolean.TRUE;
                }
            }
        }
        return this.readOnlyConnection;
    }

    synchronized Collection<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        JvmMXBeans jmx;
        if (this.gcList == null && (jmx = this.getJvmMXBeans()) != null) {
            this.gcList = jmx.getGarbageCollectorMXBeans();
        }
        return this.gcList;
    }

    String getJvmArgs() {
        try {
            RuntimeMXBean runtime = this.getRuntime();
            if (runtime != null) {
                StringBuilder buf = new StringBuilder();
                List<String> args = runtime.getInputArguments();
                for (String arg : args) {
                    buf.append(arg).append(' ');
                }
                return buf.toString();
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.throwing(JmxSupport.class.getName(), "getJvmArgs", e);
            return null;
        }
    }

    MemoryPoolMXBean getPermGenPool() {
        try {
            JvmMXBeans jmx;
            if (this.permGenPool == null && (jmx = this.getJvmMXBeans()) != null) {
                Collection pools = jmx.getMemoryPoolMXBeans();
                for (MemoryPoolMXBean pool : pools) {
                    MemoryType type = pool.getType();
                    String name = pool.getName();
                    if (!MemoryType.NON_HEAP.equals((Object)type) || !PERM_GEN.equals(name) && !PS_PERM_GEN.equals(name) && !CMS_PERM_GEN.equals(name) && !IBM_PERM_GEN.equals(name)) continue;
                    this.permGenPool = pool;
                    break;
                }
            }
            return this.permGenPool;
        }
        catch (Exception e) {
            LOGGER.throwing(JmxSupport.class.getName(), "getPermGenPool", e);
            return null;
        }
    }

    void initTimer() {
        int interval = GlobalPreferences.sharedInstance().getMonitoredDataPoll() * 1000;
        final JvmMXBeans jmx = this.getJvmMXBeans();
        if (jmx != null) {
            TimerTask task = new TimerTask(){

                public void run() {
                    try {
                        MonitoredDataImpl data = new MonitoredDataImpl((Jvm)JmxSupport.this.jvm, JmxSupport.this, jmx);
                        JmxSupport.this.jvm.notifyListeners(data);
                    }
                    catch (UndeclaredThrowableException e) {
                        LOGGER.throwing(JmxSupport.class.getName(), "MonitoredDataImpl<init>", e);
                    }
                }
            };
            this.timer = new Timer("JMX MonitoredData timer for " + this.application.getId());
            this.timer.schedule(task, INITIAL_DELAY, (long)interval);
        }
    }

    void disableTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private static ObjectName getOSName() {
        try {
            return new ObjectName("java.lang:type=OperatingSystem");
        }
        catch (MalformedObjectNameException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void dataRemoved(Object dataSource) {
        this.disableTimer();
    }
}

