/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelListener;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.filters.FilterUtils;
import org.netbeans.lib.profiler.common.filters.GlobalFilters;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.JExtendedTable;
import org.netbeans.lib.profiler.ui.components.table.BooleanTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class GlobalFiltersPanel
extends JPanel
implements HelpCtx.Provider {
    private static final String DEFAULT_FILTER_NAME = NbBundle.getMessage(GlobalFiltersPanel.class, (String)"GlobalFiltersPanel_DefaultFilterName");
    private static final String COLUMN_NAME_NAME = NbBundle.getMessage(GlobalFiltersPanel.class, (String)"GlobalFiltersPanel_ColumnNameName");
    private static final String COLUMN_NAME_VALUE = NbBundle.getMessage(GlobalFiltersPanel.class, (String)"GlobalFiltersPanel_ColumnNameValue");
    private static final String DEFINED_FILTERS_LABEL_TEXT = NbBundle.getMessage(GlobalFiltersPanel.class, (String)"GlobalFiltersPanel_DefinedFiltersLabelText");
    private static final String NEW_BUTTON_TEXT = NbBundle.getMessage(GlobalFiltersPanel.class, (String)"GlobalFiltersPanel_NewButtonText");
    private static final String EDIT_BUTTON_TEXT = NbBundle.getMessage(GlobalFiltersPanel.class, (String)"GlobalFiltersPanel_EditButtonText");
    private static final String DELETE_BUTTON_TEXT = NbBundle.getMessage(GlobalFiltersPanel.class, (String)"GlobalFiltersPanel_DeleteButtonText");
    private static final String MOVE_UP_BUTTON_TEXT = NbBundle.getMessage(GlobalFiltersPanel.class, (String)"GlobalFiltersPanel_MoveUpButtonText");
    private static final String MOVE_DOWN_BUTTON_TEXT = NbBundle.getMessage(GlobalFiltersPanel.class, (String)"GlobalFiltersPanel_MoveDownButtonText");
    private static final String OK_BUTTON_TEXT = NbBundle.getMessage(GlobalFiltersPanel.class, (String)"GlobalFiltersPanel_OkButtonText");
    private static final String CANCEL_BUTTON_TEXT = NbBundle.getMessage(GlobalFiltersPanel.class, (String)"GlobalFiltersPanel_CancelButtonText");
    private static final String HINT_MSG = NbBundle.getMessage(GlobalFiltersPanel.class, (String)"GlobalFiltersPanel_HintMsg");
    private static final String FILTER_TABLE_ACCESS_NAME = NbBundle.getMessage(GlobalFiltersPanel.class, (String)"GlobalFiltersPanel_FilterTableAccessName");
    private static final String NEW_BUTTON_ACCESS_DESC = NbBundle.getMessage(GlobalFiltersPanel.class, (String)"GlobalFiltersPanel_NewButtonAccessDesc");
    private static final String EDIT_BUTTON_ACCESS_DESC = NbBundle.getMessage(GlobalFiltersPanel.class, (String)"GlobalFiltersPanel_EditButtonAccessDesc");
    private static final String DELETE_BUTTON_ACCESS_DESC = NbBundle.getMessage(GlobalFiltersPanel.class, (String)"GlobalFiltersPanel_DeleteButtonAccessDesc");
    private static final String MOVE_UP_BUTTON_ACCESS_DESC = NbBundle.getMessage(GlobalFiltersPanel.class, (String)"GlobalFiltersPanel_MoveUpButtonAccessDesc");
    private static final String MOVE_DOWN_BUTTON_ACCESS_DESC = NbBundle.getMessage(GlobalFiltersPanel.class, (String)"GlobalFiltersPanel_MoveDownButtonAccessDesc");
    private static final String HELP_CTX_KEY = "GlobalFiltersPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("GlobalFiltersPanel.HelpCtx");
    private static GlobalFiltersPanel defaultInstance;
    JTextField filterTableStringCellEditorComponent;
    private ActionListener buttonsListener;
    private HTMLTextArea hintArea;
    private JButton CancelButton;
    private JButton OKButton;
    private JButton deleteButton;
    private JButton editButton;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JButton newButton;
    private JExtendedTable filterTable;
    private JLabel definedFiltersLabel;
    private final NetBeansProfiler nbProfiler = (NetBeansProfiler)Profiler.getDefault();
    private SelectionListener selectionListener;
    private final Class[] columnClasses;
    private final String[] columnNames = new String[]{COLUMN_NAME_NAME, COLUMN_NAME_VALUE};
    private String cellValueBeforeEditing;
    private String[] filterNames;
    private String[] filterValues;
    private boolean filterCellEditorChangesOKButton = false;

    public GlobalFiltersPanel(String[] stringArray, String[] stringArray2) {
        super(new BorderLayout());
        this.columnClasses = new Class[]{String.class, String.class};
        this.setFilterNamesFrom(stringArray);
        this.setFilterValuesFrom(stringArray2);
        this.initComponents();
    }

    private GlobalFiltersPanel() {
        super(new BorderLayout());
        this.columnClasses = new Class[]{String.class, String.class};
        this.setFilterNamesFrom(new String[0]);
        this.setFilterValuesFrom(new String[0]);
        this.initComponents();
    }

    public static GlobalFiltersPanel getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new GlobalFiltersPanel();
        }
        return defaultInstance;
    }

    public JButton getCancelButton() {
        return this.CancelButton;
    }

    public String[] getFilterNamesCopy() {
        String[] stringArray = new String[this.filterNames.length];
        System.arraycopy(this.filterNames, 0, stringArray, 0, this.filterNames.length);
        return stringArray;
    }

    public void setFilterNamesFrom(String[] stringArray) {
        this.filterNames = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.filterNames, 0, stringArray.length);
        if (this.filterTable != null) {
            ((AbstractTableModel)this.filterTable.getModel()).fireTableDataChanged();
        }
    }

    public String[] getFilterValuesCopy() {
        String[] stringArray = new String[this.filterValues.length];
        System.arraycopy(this.filterValues, 0, stringArray, 0, this.filterValues.length);
        return this.filterValues;
    }

    public void setFilterValuesFrom(String[] stringArray) {
        this.filterValues = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.filterValues, 0, stringArray.length);
        if (this.filterTable != null) {
            ((AbstractTableModel)this.filterTable.getModel()).fireTableDataChanged();
        }
        this.updateOKButton();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public JButton getOKButton() {
        return this.OKButton;
    }

    public void applyChanges() {
        this.stopFilterTableEditing();
        GlobalFilters globalFilters = this.nbProfiler.getGlobalFilters();
        globalFilters.setFilterNames(this.getFilterNamesCopy());
        globalFilters.setFilterValues(this.getFilterValuesCopy());
        this.nbProfiler.saveGlobalFilters();
    }

    public void editFilterValueAtRow(int n) {
        this.processUniqueFilterNameCheckAt(this.filterTable.getEditingRow(), this.filterTable.getEditingColumn());
        this.stopFilterTableEditing();
        this.filterTable.clearSelection();
        this.filterTable.addRowSelectionInterval(n, n);
        this.editSelectedRow(1);
        this.filterTableStringCellEditorComponent.selectAll();
    }

    public void init() {
        this.stopFilterTableEditing();
        this.filterTable.clearSelection();
        GlobalFilters globalFilters = this.nbProfiler.getGlobalFilters();
        this.setFilterNamesFrom(globalFilters.getFilterNames());
        this.setFilterValuesFrom(globalFilters.getFilterValues());
    }

    private boolean isValidFilter(String string) {
        if (string == null) {
            return false;
        }
        String[] stringArray = FilterUtils.getSeparateFilters((String)string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (FilterUtils.isValidProfilerFilter((String)stringArray[i])) continue;
            return false;
        }
        return true;
    }

    private void addNewFilter() {
        int n = this.filterNames.length;
        String[] stringArray = new String[n + 1];
        String[] stringArray2 = new String[n + 1];
        Boolean[] booleanArray = new Boolean[n + 1];
        System.arraycopy(this.filterNames, 0, stringArray, 0, n);
        System.arraycopy(this.filterValues, 0, stringArray2, 0, n);
        stringArray[n] = this.createUniqueFilterName();
        stringArray2[n] = "";
        booleanArray[n] = Boolean.TRUE;
        this.filterNames = stringArray;
        this.filterValues = stringArray2;
        this.filterTable.invalidate();
        this.revalidate();
        this.repaint();
        this.filterTable.clearSelection();
        this.filterTable.addRowSelectionInterval(n, n);
        this.makeSelectedFilterVisible();
        this.filterTable.editCellAt(n, 0);
        this.filterTableStringCellEditorComponent.selectAll();
    }

    private boolean areFiltersValidExceptRow(int n) {
        for (int i = 0; i < this.filterValues.length; ++i) {
            if (i == n || this.isValidFilter(this.filterValues[i])) continue;
            return false;
        }
        return true;
    }

    private boolean containsFilterName(String string) {
        for (int i = 0; i < this.filterNames.length; ++i) {
            if (!this.filterNames[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean containsFilterNameExceptRow(String string, int n) {
        for (int i = 0; i < this.filterNames.length; ++i) {
            if (i == n || !this.filterNames[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    private String createUniqueFilterName() {
        return this.createUniqueFilterName(DEFAULT_FILTER_NAME);
    }

    private String createUniqueFilterName(String string) {
        int n = 1;
        String string2 = "";
        while (this.containsFilterName(string + string2)) {
            string2 = " (" + ++n + ")";
        }
        return string + string2;
    }

    private void deleteSelectedFilters() {
        int n = this.filterTable.getSelectedRowCount();
        int n2 = this.filterNames.length - n;
        int n3 = 0;
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        int n4 = 0;
        for (int i = 0; i < this.filterNames.length; ++i) {
            if (!this.filterTable.isRowSelected(i)) {
                stringArray[n4] = this.filterNames[i];
                stringArray2[n4] = this.filterValues[i];
                ++n4;
                continue;
            }
            n3 = Math.max(0, n4 - 1);
            this.filterTable.removeRowSelectionInterval(i, i);
        }
        this.stopFilterTableEditing();
        this.filterNames = stringArray;
        this.filterValues = stringArray2;
        this.filterTable.invalidate();
        this.revalidate();
        this.repaint();
        if (this.filterTable.getRowCount() > 0) {
            this.filterTable.addRowSelectionInterval(n3, n3);
            this.makeSelectedFilterVisible();
        }
        this.updateOKButton();
    }

    private void editSelectedCell() {
        this.filterTable.editCellAt(this.filterTable.getSelectedRow(), this.filterTable.getSelectedColumn(), new EventObject(this.filterTable));
    }

    private void editSelectedRow(int n) {
        this.filterTable.editCellAt(this.filterTable.getSelectedRow(), n, new EventObject(this.filterTable));
    }

    private void initComponents() {
        this.OKButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.OKButton, (String)OK_BUTTON_TEXT);
        this.CancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.CancelButton, (String)CANCEL_BUTTON_TEXT);
        this.buttonsListener = new ButtonsListener();
        this.selectionListener = new SelectionListener();
        this.definedFiltersLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.definedFiltersLabel, (String)DEFINED_FILTERS_LABEL_TEXT);
        this.definedFiltersLabel.setOpaque(false);
        this.definedFiltersLabel.setBorder(BorderFactory.createEmptyBorder(15, 5, 0, 5));
        this.add((Component)this.definedFiltersLabel, "North");
        LabelTableCellRenderer labelTableCellRenderer = new LabelTableCellRenderer(){

            protected void setState(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (n2 == 1) {
                    if (GlobalFiltersPanel.this.isValidFilter((String)object)) {
                        this.label.setForeground(UIManager.getColor("Label.foreground"));
                    } else {
                        this.label.setForeground(Color.red);
                    }
                }
            }
        };
        labelTableCellRenderer.setSupportsFocusBorder(true);
        BooleanTableCellRenderer booleanTableCellRenderer = new BooleanTableCellRenderer();
        booleanTableCellRenderer.setSupportsFocusBorder(true);
        this.filterTableStringCellEditorComponent = new JTextField();
        this.filterTableStringCellEditorComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIUtils.getDarkerLine((Color)UIConstants.TABLE_SELECTION_BACKGROUND_COLOR, (float)0.65f)), BorderFactory.createEmptyBorder(1, 2, 1, 3)));
        this.filterTableStringCellEditorComponent.setSelectionColor(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.filterTableStringCellEditorComponent.setSelectedTextColor(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.filterTableStringCellEditorComponent.addKeyListener(new CellEditorKeyListener());
        this.filterTableStringCellEditorComponent.addFocusListener(new CellEditorFocusListener());
        this.filterTableStringCellEditorComponent.getDocument().addDocumentListener(new CellEditorDocumentListener());
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(this.filterTableStringCellEditorComponent);
        this.filterTable = new JExtendedTable(new FilterTableModel()){

            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                Component component;
                boolean bl = super.editCellAt(n, n2, eventObject);
                if (bl && (component = this.getEditorComponent()) != null) {
                    component.requestFocus();
                    component.repaint();
                }
                return bl;
            }
        };
        this.definedFiltersLabel.setLabelFor((Component)this.filterTable);
        this.filterTable.getAccessibleContext().setAccessibleName(FILTER_TABLE_ACCESS_NAME);
        this.filterTable.setSurrendersFocusOnKeystroke(true);
        this.filterTable.setRowSelectionAllowed(true);
        this.filterTable.setSelectionMode(2);
        this.filterTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.filterTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.filterTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.filterTable.setShowHorizontalLines(false);
        this.filterTable.setShowVerticalLines(true);
        this.filterTable.setRowMargin(0);
        this.filterTable.getTableHeader().setReorderingAllowed(false);
        this.filterTable.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.filterTable.setDefaultRenderer(String.class, (TableCellRenderer)labelTableCellRenderer);
        this.filterTable.setDefaultRenderer(Boolean.class, (TableCellRenderer)booleanTableCellRenderer);
        this.filterTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.filterTable.setDefaultEditor(String.class, (TableCellEditor)defaultCellEditor);
        this.filterTable.addKeyListener((KeyListener)new FilterTableKeyListener());
        final JScrollPane jScrollPane = new JScrollPane(22, 31);
        FilterTableViewport filterTableViewport = new FilterTableViewport((JTable)this.filterTable);
        jScrollPane.setViewport(filterTableViewport);
        jScrollPane.addMouseWheelListener((MouseWheelListener)this.filterTable);
        jScrollPane.getVerticalScrollBar().getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (jScrollPane.getVerticalScrollBar().getModel().getExtent() == jScrollPane.getVerticalScrollBar().getModel().getMaximum()) {
                    jScrollPane.getVerticalScrollBar().setEnabled(false);
                } else {
                    jScrollPane.getVerticalScrollBar().setEnabled(true);
                }
            }
        });
        jScrollPane.setPreferredSize(new Dimension(490, 370));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 3));
        jPanel.add((Component)jScrollPane, "Center");
        this.newButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.newButton, (String)NEW_BUTTON_TEXT);
        this.newButton.getAccessibleContext().setAccessibleDescription(NEW_BUTTON_ACCESS_DESC);
        this.newButton.addActionListener(this.buttonsListener);
        this.editButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)EDIT_BUTTON_TEXT);
        this.editButton.getAccessibleContext().setAccessibleDescription(EDIT_BUTTON_ACCESS_DESC);
        this.editButton.setEnabled(false);
        this.editButton.addActionListener(this.buttonsListener);
        this.deleteButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)DELETE_BUTTON_TEXT);
        this.deleteButton.getAccessibleContext().setAccessibleDescription(DELETE_BUTTON_ACCESS_DESC);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(this.buttonsListener);
        this.moveUpButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpButton, (String)MOVE_UP_BUTTON_TEXT);
        this.moveUpButton.getAccessibleContext().setAccessibleDescription(MOVE_UP_BUTTON_ACCESS_DESC);
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.addActionListener(this.buttonsListener);
        this.moveDownButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownButton, (String)MOVE_DOWN_BUTTON_TEXT);
        this.moveDownButton.getAccessibleContext().setAccessibleDescription(MOVE_DOWN_BUTTON_ACCESS_DESC);
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.addActionListener(this.buttonsListener);
        JPanel jPanel2 = new JPanel(new GridLayout(6, 1, 0, 5));
        jPanel2.add(this.newButton);
        jPanel2.add(this.editButton);
        jPanel2.add(this.deleteButton);
        jPanel2.add(new JPanel());
        jPanel2.add(this.moveUpButton);
        jPanel2.add(this.moveDownButton);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        jPanel3.add((Component)jPanel2, "North");
        Color color = UIManager.getColor("Panel.background");
        Color color2 = UIUtils.getSafeColor((int)(color.getRed() - 10), (int)(color.getGreen() - 10), (int)(color.getBlue() - 10));
        this.hintArea = new HTMLTextArea(){

            public Dimension getPreferredSize() {
                return new Dimension(1, super.getPreferredSize().height);
            }
        };
        this.hintArea.setText(HINT_MSG);
        this.hintArea.setEnabled(false);
        this.hintArea.setDisabledTextColor(Color.darkGray);
        this.hintArea.setBackground(color2);
        this.hintArea.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(7, 7, 10, 7, UIManager.getColor("Panel.background")), BorderFactory.createMatteBorder(10, 10, 10, 10, color2)));
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel3, "East");
        this.add((Component)this.hintArea, "South");
        this.updateOKButton();
    }

    private void makeSelectedFilterVisible() {
        this.filterTable.scrollRectToVisible(this.filterTable.getCellRect(this.filterTable.getSelectedRow(), this.filterTable.getSelectedColumn(), true));
    }

    private void moveSelectedRowDown() {
        this.stopFilterTableEditing();
        int n = this.filterTable.getSelectedRow();
        if (n < this.filterTable.getRowCount() - 1) {
            String string = this.filterNames[n + 1];
            String string2 = this.filterValues[n + 1];
            this.filterNames[n + 1] = this.filterNames[n];
            this.filterValues[n + 1] = this.filterValues[n];
            this.filterNames[n] = string;
            this.filterValues[n] = string2;
            this.filterTable.repaint();
            this.filterTable.clearSelection();
            this.filterTable.addRowSelectionInterval(n + 1, n + 1);
            this.makeSelectedFilterVisible();
        }
    }

    private void moveSelectedRowUp() {
        this.stopFilterTableEditing();
        int n = this.filterTable.getSelectedRow();
        if (n > 0) {
            String string = this.filterNames[n - 1];
            String string2 = this.filterValues[n - 1];
            this.filterNames[n - 1] = this.filterNames[n];
            this.filterValues[n - 1] = this.filterValues[n];
            this.filterNames[n] = string;
            this.filterValues[n] = string2;
            this.filterTable.repaint();
            this.filterTable.clearSelection();
            this.filterTable.addRowSelectionInterval(n - 1, n - 1);
            this.makeSelectedFilterVisible();
        }
    }

    private void processUniqueFilterNameCheckAt(int n, int n2) {
        boolean bl;
        if (n2 != 0) {
            return;
        }
        this.filterNames[n] = this.filterNames[n].trim();
        boolean bl2 = bl = this.filterNames[n].length() == 0;
        if (bl || this.containsFilterNameExceptRow(this.filterNames[n], n)) {
            this.stopFilterTableEditing();
            this.filterNames[n] = bl ? this.createUniqueFilterName() : this.createUniqueFilterName(this.filterNames[n]);
        }
        this.filterTable.repaint();
    }

    private void stopFilterTableEditing() {
        if (this.filterTable.getCellEditor() == null) {
            return;
        }
        if (this.filterNames.length == 0 || this.filterValues.length == 0) {
            return;
        }
        this.filterTable.getCellEditor().stopCellEditing();
    }

    private void updateOKButton() {
        if (this.OKButton == null) {
            return;
        }
        for (int i = 0; i < this.filterValues.length; ++i) {
            if (this.isValidFilter(this.filterValues[i])) continue;
            this.OKButton.setEnabled(false);
            return;
        }
        this.OKButton.setEnabled(true);
    }

    private final class SelectionListener
    implements ListSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = GlobalFiltersPanel.this.filterTable.getSelectedRowCount();
            if (n == 0) {
                GlobalFiltersPanel.this.editButton.setEnabled(false);
                GlobalFiltersPanel.this.deleteButton.setEnabled(false);
                GlobalFiltersPanel.this.moveUpButton.setEnabled(false);
                GlobalFiltersPanel.this.moveDownButton.setEnabled(false);
            } else {
                GlobalFiltersPanel.this.editButton.setEnabled(true);
                GlobalFiltersPanel.this.deleteButton.setEnabled(true);
                if (n == 1 && GlobalFiltersPanel.this.filterTable.getSelectedRow() > 0) {
                    GlobalFiltersPanel.this.moveUpButton.setEnabled(true);
                } else {
                    GlobalFiltersPanel.this.moveUpButton.setEnabled(false);
                }
                if (n == 1 && GlobalFiltersPanel.this.filterTable.getSelectedRow() < GlobalFiltersPanel.this.filterTable.getRowCount() - 1) {
                    GlobalFiltersPanel.this.moveDownButton.setEnabled(true);
                } else {
                    GlobalFiltersPanel.this.moveDownButton.setEnabled(false);
                }
            }
        }
    }

    private final class FilterTableViewport
    extends JViewport
    implements TableColumnModelListener {
        private final JTableHeader tableHeader;

        public FilterTableViewport(JTable jTable) {
            this.setView(jTable);
            this.setBackground(jTable.getBackground());
            this.tableHeader = jTable.getTableHeader();
            this.tableHeader.getColumnModel().addColumnModelListener(this);
        }

        @Override
        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            this.repaint();
        }

        @Override
        public void columnMarginChanged(ChangeEvent changeEvent) {
            this.repaint();
        }

        @Override
        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            this.repaint();
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            this.repaint();
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            this.paintVerticalLines(graphics);
        }

        private int getEmptySpaceY() {
            if (this.getView() == null) {
                return 0;
            }
            return this.getView().getHeight();
        }

        private void paintVerticalLines(Graphics graphics) {
            int n = this.getEmptySpaceY();
            graphics.setColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
            for (int i = 0; i < this.tableHeader.getColumnModel().getColumnCount(); ++i) {
                Rectangle rectangle = this.tableHeader.getHeaderRect(i);
                graphics.drawLine(rectangle.x + rectangle.width - 1, n, rectangle.x + rectangle.width - 1, this.getHeight() - 1);
            }
        }
    }

    private final class FilterTableModel
    extends AbstractTableModel {
        private FilterTableModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public Class getColumnClass(int n) {
            return GlobalFiltersPanel.this.columnClasses[n];
        }

        @Override
        public int getColumnCount() {
            return GlobalFiltersPanel.this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return GlobalFiltersPanel.this.columnNames[n];
        }

        @Override
        public int getRowCount() {
            return GlobalFiltersPanel.this.filterNames.length;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            switch (n2) {
                case 0: {
                    ((GlobalFiltersPanel)GlobalFiltersPanel.this).filterNames[n] = ((String)object).trim();
                    break;
                }
                case 1: {
                    ((GlobalFiltersPanel)GlobalFiltersPanel.this).filterValues[n] = (String)object;
                }
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return GlobalFiltersPanel.this.filterNames[n];
                }
                case 1: {
                    return GlobalFiltersPanel.this.filterValues[n];
                }
            }
            return null;
        }
    }

    private final class FilterTableKeyListener
    extends KeyAdapter {
        private FilterTableKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 127: {
                    keyEvent.consume();
                    GlobalFiltersPanel.this.deleteSelectedFilters();
                    break;
                }
                case 78: {
                    if (keyEvent.getModifiers() == 2) {
                        keyEvent.consume();
                        GlobalFiltersPanel.this.addNewFilter();
                        break;
                    }
                }
                case 38: {
                    if (keyEvent.getModifiers() == 2) {
                        keyEvent.consume();
                        if (GlobalFiltersPanel.this.filterTable.getSelectedRowCount() != 1 || GlobalFiltersPanel.this.filterTable.getSelectedRow() <= 0) break;
                        GlobalFiltersPanel.this.moveSelectedRowUp();
                        break;
                    }
                }
                case 40: {
                    if (keyEvent.getModifiers() == 2) {
                        keyEvent.consume();
                        if (GlobalFiltersPanel.this.filterTable.getSelectedRowCount() != 1 || GlobalFiltersPanel.this.filterTable.getSelectedRow() >= GlobalFiltersPanel.this.filterTable.getRowCount() - 1) break;
                        GlobalFiltersPanel.this.moveSelectedRowDown();
                        break;
                    }
                }
                case 27: {
                    GlobalFiltersPanel.this.processKeyEvent(keyEvent);
                }
            }
        }
    }

    private final class CellEditorKeyListener
    extends KeyAdapter {
        private CellEditorKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 10: {
                    if (GlobalFiltersPanel.this.filterTable.getEditingColumn() != 0) break;
                    keyEvent.consume();
                    GlobalFiltersPanel.this.processUniqueFilterNameCheckAt(GlobalFiltersPanel.this.filterTable.getEditingRow(), GlobalFiltersPanel.this.filterTable.getEditingColumn());
                    GlobalFiltersPanel.this.stopFilterTableEditing();
                    GlobalFiltersPanel.this.editSelectedRow(1);
                    GlobalFiltersPanel.this.filterTableStringCellEditorComponent.selectAll();
                    break;
                }
                case 27: {
                    keyEvent.consume();
                    GlobalFiltersPanel.this.filterTableStringCellEditorComponent.setText(GlobalFiltersPanel.this.cellValueBeforeEditing);
                    GlobalFiltersPanel.this.stopFilterTableEditing();
                }
            }
        }
    }

    private final class CellEditorFocusListener
    extends FocusAdapter {
        private int lastEditedColumn;
        private int lastEditedRow;

        private CellEditorFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.lastEditedRow = GlobalFiltersPanel.this.filterTable.getEditingRow();
            this.lastEditedColumn = GlobalFiltersPanel.this.filterTable.getEditingColumn();
            GlobalFiltersPanel.this.editButton.setEnabled(false);
            GlobalFiltersPanel.this.cellValueBeforeEditing = (String)GlobalFiltersPanel.this.filterTable.getValueAt(this.lastEditedRow, this.lastEditedColumn);
            GlobalFiltersPanel.this.filterCellEditorChangesOKButton = GlobalFiltersPanel.this.areFiltersValidExceptRow(this.lastEditedRow);
            if (this.lastEditedColumn == 1) {
                if (GlobalFiltersPanel.this.isValidFilter(GlobalFiltersPanel.this.filterTableStringCellEditorComponent.getText())) {
                    GlobalFiltersPanel.this.filterTableStringCellEditorComponent.setForeground(UIManager.getColor("Label.foreground"));
                    GlobalFiltersPanel.this.filterTableStringCellEditorComponent.setSelectedTextColor(UIManager.getColor("Label.foreground"));
                } else {
                    GlobalFiltersPanel.this.filterTableStringCellEditorComponent.setForeground(Color.red);
                    GlobalFiltersPanel.this.filterTableStringCellEditorComponent.setSelectedTextColor(Color.red);
                }
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            GlobalFiltersPanel.this.processUniqueFilterNameCheckAt(this.lastEditedRow, this.lastEditedColumn);
            GlobalFiltersPanel.this.editButton.setEnabled(true);
        }
    }

    private final class CellEditorDocumentListener
    implements DocumentListener {
        private CellEditorDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            if (GlobalFiltersPanel.this.filterTable.getEditingColumn() == 0) {
                this.updateFilterName();
            } else if (GlobalFiltersPanel.this.filterTable.getEditingColumn() == 1) {
                this.checkFilterValue();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (GlobalFiltersPanel.this.filterTable.getEditingColumn() == 0) {
                this.updateFilterName();
            } else if (GlobalFiltersPanel.this.filterTable.getEditingColumn() == 1) {
                this.checkFilterValue();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (GlobalFiltersPanel.this.filterTable.getEditingColumn() == 0) {
                this.updateFilterName();
            } else if (GlobalFiltersPanel.this.filterTable.getEditingColumn() == 1) {
                this.checkFilterValue();
            }
        }

        private void checkFilterValue() {
            if (!GlobalFiltersPanel.this.isValidFilter(GlobalFiltersPanel.this.filterTableStringCellEditorComponent.getText())) {
                GlobalFiltersPanel.this.filterTableStringCellEditorComponent.setForeground(Color.red);
                GlobalFiltersPanel.this.filterTableStringCellEditorComponent.setSelectedTextColor(Color.red);
                if (GlobalFiltersPanel.this.filterCellEditorChangesOKButton) {
                    GlobalFiltersPanel.this.OKButton.setEnabled(false);
                }
            } else {
                GlobalFiltersPanel.this.filterTableStringCellEditorComponent.setForeground(UIManager.getColor("Label.foreground"));
                GlobalFiltersPanel.this.filterTableStringCellEditorComponent.setSelectedTextColor(UIManager.getColor("Label.foreground"));
                if (GlobalFiltersPanel.this.filterCellEditorChangesOKButton) {
                    GlobalFiltersPanel.this.OKButton.setEnabled(true);
                }
            }
        }

        private void updateFilterName() {
            ((GlobalFiltersPanel)GlobalFiltersPanel.this).filterNames[((GlobalFiltersPanel)GlobalFiltersPanel.this).filterTable.getEditingRow()] = GlobalFiltersPanel.this.filterTableStringCellEditorComponent.getText();
        }
    }

    private final class ButtonsListener
    implements ActionListener {
        private ButtonsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GlobalFiltersPanel.this.newButton) {
                GlobalFiltersPanel.this.addNewFilter();
            } else if (actionEvent.getSource() == GlobalFiltersPanel.this.editButton) {
                GlobalFiltersPanel.this.editSelectedCell();
            } else if (actionEvent.getSource() == GlobalFiltersPanel.this.deleteButton) {
                GlobalFiltersPanel.this.deleteSelectedFilters();
            } else if (actionEvent.getSource() == GlobalFiltersPanel.this.moveUpButton) {
                GlobalFiltersPanel.this.moveSelectedRowUp();
            } else if (actionEvent.getSource() == GlobalFiltersPanel.this.moveDownButton) {
                GlobalFiltersPanel.this.moveSelectedRowDown();
            }
        }
    }
}

