/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.profiler.heap.Field;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.lib.profiler.heap.Type;
import org.netbeans.modules.profiler.heapwalk.memorylint.Distribution;

public final class Walker {
    private static final Type OBJECT = new Type(){

        public String getName() {
            return "object";
        }
    };
    private Distribution log = new Distribution();

    public Distribution getResults() {
        return this.log;
    }

    public void walk(Instance instance) {
        this.walk(instance, null);
    }

    public void walk(Instance instance, Filter filter) {
        LinkedList<Instance> linkedList = new LinkedList<Instance>();
        linkedList.add(instance);
        this.log.add(instance);
        while (!linkedList.isEmpty()) {
            List list;
            Instance instance2 = (Instance)linkedList.poll();
            if (instance2 instanceof ObjectArrayInstance) {
                list = ((ObjectArrayInstance)instance2).getValues();
                int n = 0;
                for (Instance instance3 : list) {
                    if (instance3 != null && (filter == null || filter.accept(new ArrayEntryValue(n, instance2, instance3))) && !this.log.isCounted(instance3)) {
                        this.log.add(instance3);
                        linkedList.add(instance3);
                    }
                    ++n;
                }
            }
            list = instance2.getFieldValues();
            for (FieldValue fieldValue : list) {
                Instance instance4;
                Instance instance3;
                if (!(fieldValue instanceof ObjectFieldValue)) continue;
                instance3 = (ObjectFieldValue)fieldValue;
                if (filter != null && !filter.accept((ObjectFieldValue)instance3) || (instance4 = instance3.getInstance()) == null || this.log.isCounted(instance4)) continue;
                this.log.add(instance4);
                linkedList.add(instance4);
            }
        }
    }

    public static interface Filter {
        public boolean accept(ObjectFieldValue var1);
    }

    private class ArrayEntryValue
    implements ObjectFieldValue,
    Field {
        int idx;
        private Instance src;
        private Instance target;

        public ArrayEntryValue(int n, Instance instance, Instance instance2) {
            this.idx = n;
            this.src = instance;
            this.target = instance2;
        }

        public Instance getInstance() {
            return this.target;
        }

        public Field getField() {
            return this;
        }

        public String getValue() {
            return "Instance #" + this.target.getInstanceId();
        }

        public Instance getDefiningInstance() {
            return this.src;
        }

        public JavaClass getDeclaringClass() {
            return this.src.getJavaClass();
        }

        public String getName() {
            return "[" + this.idx + "]";
        }

        public boolean isStatic() {
            return false;
        }

        public Type getType() {
            return OBJECT;
        }
    }
}

