/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.heapwalk.HeapWalkerManager;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class LoadSnapshotAction
extends AbstractAction {
    private static final String ACTION_DESCR = NbBundle.getMessage(LoadSnapshotAction.class, (String)"LoadSnapshotAction_ActionDescr");
    private static final String OPEN_SNAPSHOT_DIALOG_CAPTION = NbBundle.getMessage(LoadSnapshotAction.class, (String)"LoadSnapshotAction_OpenSnapshotDialogCaption");
    private static final String PROFILER_SNAPSHOT_FILE_FILTER = NbBundle.getMessage(LoadSnapshotAction.class, (String)"LoadSnapshotAction_ProfilerSnapshotFileFilter");
    private static final String OPEN_SNAPSHOT_HEAPDUMP_DIALOG_CAPTION = NbBundle.getMessage(LoadSnapshotAction.class, (String)"LoadSnapshotAction_OpenSnapshotHeapdumpDialogCaption");
    private static final String PROFILER_SNAPSHOT_HEAPDUMP_FILE_FILTER = NbBundle.getMessage(LoadSnapshotAction.class, (String)"LoadSnapshotAction_ProfilerSnapshotHeapdumpFileFilter");
    private static final String CANNOT_OPEN_SNAPSHOT_MSG = NbBundle.getMessage(LoadSnapshotAction.class, (String)"LoadSnapshotAction_No_Snapshot_Selected");
    private static File importDir;

    public LoadSnapshotAction() {
        this.putValue("ShortDescription", ACTION_DESCR);
    }

    @Override
    public boolean isEnabled() {
        return NetBeansProfiler.isInitialized();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.loadSnapshot(false);
    }

    public void loadSnapshotOrHeapdump() {
        this.loadSnapshot(true);
    }

    private void loadSnapshot(final boolean bl) {
        JFileChooser jFileChooser = new JFileChooser();
        if (importDir != null) {
            jFileChooser.setCurrentDirectory(importDir);
        }
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.setDialogType(0);
        jFileChooser.setDialogTitle(bl ? OPEN_SNAPSHOT_HEAPDUMP_DIALOG_CAPTION : OPEN_SNAPSHOT_DIALOG_CAPTION);
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getName();
                if (string.endsWith(".nps")) {
                    return true;
                }
                if (string.endsWith(".npss")) {
                    return true;
                }
                return bl && string.endsWith(".hprof");
            }

            @Override
            public String getDescription() {
                return bl ? MessageFormat.format(PROFILER_SNAPSHOT_HEAPDUMP_FILE_FILTER, "nps", "hprof") : MessageFormat.format(PROFILER_SNAPSHOT_FILE_FILTER, "nps");
            }
        });
        if (jFileChooser.showOpenDialog(IDEUtils.getMainWindow()) == 0) {
            File[] fileArray = jFileChooser.getSelectedFiles();
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            final ArrayList<File> arrayList2 = new ArrayList<File>();
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                String string = file.getName();
                if (string.endsWith(".nps") || string.endsWith(".npss")) {
                    arrayList.add(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file)));
                    continue;
                }
                if (!string.endsWith(".hprof")) continue;
                arrayList2.add(file);
            }
            if (!arrayList.isEmpty()) {
                LoadedSnapshot[] loadedSnapshotArray = ResultsManager.getDefault().loadSnapshots(arrayList.toArray(new FileObject[arrayList.size()]));
                ResultsManager.getDefault().openSnapshots(loadedSnapshotArray);
            } else if (!bl) {
                NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_OPEN_SNAPSHOT_MSG, null));
            }
            if (!arrayList2.isEmpty()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        HeapWalkerManager.getDefault().openHeapWalkers(arrayList2.toArray(new File[arrayList2.size()]));
                    }
                });
            }
            importDir = jFileChooser.getCurrentDirectory();
        }
    }
}

